/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.engine;

import com.enterprisemath.utils.Dates;
import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.engine.TaskRunExceptionReport;
import com.enterprisemath.utils.engine.TaskRunListener;
import com.enterprisemath.utils.engine.TaskRunStopReport;
import com.enterprisemath.utils.engine.TaskRunSuccessReport;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogTaskRunListener
implements TaskRunListener {
    private static final Logger log = LoggerFactory.getLogger(Slf4jLogTaskRunListener.class);
    private Set<String> debugSuccessfulTasks = new HashSet<String>();
    private String successMessageFormat;
    private String exceptionMessageFormat;
    private String stopMessageFormat;

    public Slf4jLogTaskRunListener(Builder builder) {
        this.debugSuccessfulTasks = DomainUtils.softCopyUnmodifiableSet(builder.debugSuccessfulTasks);
        this.successMessageFormat = builder.successMessageFormat;
        this.exceptionMessageFormat = builder.exceptionMessageFormat;
        this.stopMessageFormat = builder.stopMessageFormat;
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotEmptyStringInCollection(this.debugSuccessfulTasks, "debugSuccessfulTasks cannot have empty element");
        ValidationUtils.guardNotEmpty(this.successMessageFormat, "successMessageFormat cnnot be empty");
        ValidationUtils.guardNotEmpty(this.exceptionMessageFormat, "exceptionMessageFormat cnnot be empty");
        ValidationUtils.guardNotEmpty(this.stopMessageFormat, "stopMessageFormat cnnot be empty");
    }

    @Override
    public void runFinishedBySuccess(TaskRunSuccessReport report) {
        if (this.debugSuccessfulTasks.contains(report.getTaskClass()) && !log.isDebugEnabled()) {
            return;
        }
        String msg = this.successMessageFormat;
        msg = msg.replace("{code}", report.getCode());
        msg = msg.replace("{taskClass}", report.getTaskClass());
        msg = msg.replace("{parameters}", report.getParameters().toString());
        msg = msg.replace("{result}", report.getResult().toString());
        msg = msg.replace("{startTimestamp}", Dates.format(report.getStartTimestamp(), "yyyy/MM/dd HH:mm:ss"));
        msg = msg.replace("{endTimestamp}", Dates.format(report.getEndTimestamp(), "yyyy/MM/dd HH:mm:ss"));
        msg = msg.replace("{duration}", String.valueOf(report.getDuration()));
        if (this.debugSuccessfulTasks.contains(report.getTaskClass())) {
            log.debug(msg);
        } else {
            log.info(msg);
        }
    }

    @Override
    public void runFinishedByExceptin(TaskRunExceptionReport report) {
        String msg = this.exceptionMessageFormat;
        msg = msg.replace("{code}", report.getCode());
        msg = msg.replace("{taskClass}", report.getTaskClass());
        msg = msg.replace("{parameters}", report.getParameters().toString());
        msg = msg.replace("{exceptionDetails}", report.getExceptionDetails().toString());
        msg = msg.replace("{startTimestamp}", Dates.format(report.getStartTimestamp(), "yyyy/MM/dd HH:mm:ss"));
        msg = msg.replace("{endTimestamp}", Dates.format(report.getEndTimestamp(), "yyyy/MM/dd HH:mm:ss"));
        msg = msg.replace("{duration}", String.valueOf(report.getDuration()));
        log.error(msg);
    }

    @Override
    public void runFinishedByStop(TaskRunStopReport report) {
        String msg = this.stopMessageFormat;
        msg = msg.replace("{code}", report.getCode());
        msg = msg.replace("{taskClass}", report.getTaskClass());
        msg = msg.replace("{parameters}", report.getParameters().toString());
        msg = msg.replace("{startTimestamp}", Dates.format(report.getStartTimestamp(), "yyyy/MM/dd HH:mm:ss"));
        msg = msg.replace("{endTimestamp}", Dates.format(report.getEndTimestamp(), "yyyy/MM/dd HH:mm:ss"));
        msg = msg.replace("{duration}", String.valueOf(report.getDuration()));
        log.warn(msg);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class Builder {
        private Set<String> debugSuccessfulTasks = new HashSet<String>();
        private String successMessageFormat = "Task successfully finished: {code} - {taskClass} - {parameters} - {duration}";
        private String exceptionMessageFormat = "Task error: {code} - {taskClass} - {parameters} - {exceptionDetails}";
        private String stopMessageFormat = "Task was stopped: {code} - {taskClass} - {parameters}";

        public Builder setDebugSuccessfulTasks(Set<String> debugSuccessfulTasks) {
            this.debugSuccessfulTasks = debugSuccessfulTasks;
            return this;
        }

        public Builder setSuccessMessageFormat(String successMessageFormat) {
            this.successMessageFormat = successMessageFormat;
            return this;
        }

        public Builder setExceptionMessageFormat(String exceptionMessageFormat) {
            this.exceptionMessageFormat = exceptionMessageFormat;
            return this;
        }

        public Builder setStopMessageFormat(String stopMessageFormat) {
            this.stopMessageFormat = stopMessageFormat;
            return this;
        }

        public Slf4jLogTaskRunListener build() {
            return new Slf4jLogTaskRunListener(this);
        }
    }
}

