/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.engine;

import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.engine.TaskProgress;
import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class EngineTaskStatus {
    private String code;
    private String taskClass;
    private Date startTimestamp;
    private TaskProgress progress;

    public EngineTaskStatus(Builder builder) {
        this.code = builder.code;
        this.taskClass = builder.taskClass;
        this.startTimestamp = DomainUtils.copyDate(builder.startTimestamp);
        this.progress = builder.progress;
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotEmpty(this.code, "code cannot be empty");
        ValidationUtils.guardNotEmpty(this.taskClass, "taskClass cannot be empty");
        ValidationUtils.guardNotNull(this.startTimestamp, "startTimestamp cannot be null");
        ValidationUtils.guardNotNull(this.progress, "progress cannot be null");
    }

    public String getCode() {
        return this.code;
    }

    public String getTaskClass() {
        return this.taskClass;
    }

    public Date getStartTimestamp() {
        return DomainUtils.copyDate(this.startTimestamp);
    }

    public TaskProgress getProgress() {
        return this.progress;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class Builder {
        private String code;
        private String taskClass;
        private Date startTimestamp;
        private TaskProgress progress;

        public Builder setCode(String code) {
            this.code = code;
            return this;
        }

        public Builder setTaskClass(String taskClass) {
            this.taskClass = taskClass;
            return this;
        }

        public Builder setStartTimestamp(Date startTimestamp) {
            this.startTimestamp = DomainUtils.copyDate(startTimestamp);
            return this;
        }

        public Builder setProgress(TaskProgress progress) {
            this.progress = progress;
            return this;
        }

        public EngineTaskStatus build() {
            return new EngineTaskStatus(this);
        }
    }
}

