/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.engine;

import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.engine.EngineTaskStatus;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class EngineStatus {
    private List<EngineTaskStatus> taskStatuses;

    public EngineStatus(Builder builder) {
        this.taskStatuses = DomainUtils.softCopyUnmodifiableList(builder.taskStatuses);
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotNullCollection(this.taskStatuses, "taskStatuses cannot have null element");
    }

    public List<EngineTaskStatus> getTaskStatuses() {
        return this.taskStatuses;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class Builder {
        private List<EngineTaskStatus> taskStatuses = new ArrayList<EngineTaskStatus>();

        public Builder setTaskStatuses(List<EngineTaskStatus> taskStatuses) {
            this.taskStatuses = DomainUtils.softCopyList(taskStatuses);
            return this;
        }

        public Builder addTaskStatus(EngineTaskStatus taskStatus) {
            this.taskStatuses.add(taskStatus);
            return this;
        }

        public EngineStatus build() {
            return new EngineStatus(this);
        }
    }
}

