/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils;

import com.enterprisemath.utils.Dates;
import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.PropertyStringComparator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class StringMapCodec {
    private static final Set<Class<?>> PRIMITIVE_CLASSES = DomainUtils.createSet(Boolean.TYPE, Byte.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.class, Byte.class, Integer.class, Long.class, Float.class, Double.class, String.class);

    private StringMapCodec() {
    }

    public static Map<String, String> encode(Object object) {
        return StringMapCodec.encode(object, "");
    }

    public static Map<String, String> encode(Object object, String prefix) {
        if (prefix == null) {
            prefix = "";
        } else if (StringUtils.isNotEmpty((String)prefix) && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        if (object == null) {
            return Collections.singletonMap(prefix + "class", "null");
        }
        if (PRIMITIVE_CLASSES.contains(object.getClass())) {
            TreeMap<String, String> res = new TreeMap<String, String>(PropertyStringComparator.create());
            res.put(prefix + "class", object.getClass().getName());
            res.put(prefix + "value", object.toString());
            return res;
        }
        if (object instanceof List) {
            TreeMap<String, String> res = new TreeMap<String, String>(PropertyStringComparator.create());
            res.put(prefix + "class", List.class.getName());
            List list = (List)object;
            int i = 0;
            for (Object item : list) {
                String prfx = prefix + "items[" + i + "]";
                res.putAll(StringMapCodec.encode(item, prfx));
                ++i;
            }
            return res;
        }
        if (object instanceof Set) {
            TreeMap<String, String> res = new TreeMap<String, String>(PropertyStringComparator.create());
            res.put(prefix + "class", Set.class.getName());
            Set set = (Set)object;
            int i = 0;
            for (Object item : set) {
                String prfx = prefix + "items[" + i + "]";
                res.putAll(StringMapCodec.encode(item, prfx));
                ++i;
            }
            return res;
        }
        if (object instanceof Map) {
            TreeMap<String, String> res = new TreeMap<String, String>(PropertyStringComparator.create());
            res.put(prefix + "class", Map.class.getName());
            Map map = (Map)object;
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                String kprfx = prefix + "entries[" + i + "].key";
                res.putAll(StringMapCodec.encode(entry.getKey(), kprfx));
                String vprfx = prefix + "entries[" + i + "].value";
                res.putAll(StringMapCodec.encode(entry.getValue(), vprfx));
                ++i;
            }
            return res;
        }
        if (object instanceof Enum) {
            Enum enm = (Enum)object;
            return DomainUtils.createMap(prefix + "class", object.getClass().getName(), prefix + "value", enm.name());
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return DomainUtils.createMap(prefix + "class", "java.util.Date", prefix + "value", Dates.format(date, "yyyy/MM/dd HH:mm:ss.SSS"));
        }
        Class<?> builderClass = StringMapCodec.getBuilderClass(object.getClass().getName());
        SortedSet<String> properties = StringMapCodec.getPropertyNames(builderClass);
        TreeMap<String, String> res = new TreeMap<String, String>(PropertyStringComparator.create());
        res.put(prefix + "class", object.getClass().getName());
        for (String property : properties) {
            Object propValue = StringMapCodec.getPropertyValue(object, property);
            String prfx = prefix + property;
            res.putAll(StringMapCodec.encode(propValue, prfx));
        }
        return res;
    }

    public static <T> T decode(Map<String, String> buf, Class<T> clazz) {
        return StringMapCodec.decode(buf, "", clazz);
    }

    public static <T> T decode(Map<String, String> buf, String prefix, Class<T> clazz) {
        if (prefix == null) {
            prefix = "";
        } else if (StringUtils.isNotEmpty((String)prefix) && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        String className = buf.get(prefix + "class");
        if (className.equals("null")) {
            return null;
        }
        Class<?> objectType = StringMapCodec.getClass(className);
        if (PRIMITIVE_CLASSES.contains(objectType)) {
            String val = buf.get(prefix + "value");
            return (T)StringMapCodec.getPrimitiveValue(objectType, val);
        }
        if (objectType.equals(List.class)) {
            ArrayList<Object> res = new ArrayList<Object>();
            int i = 0;
            while (buf.containsKey(prefix + "items[" + i + "].class")) {
                String prfx = prefix + "items[" + i + "]";
                Object elm = StringMapCodec.decode(buf, prfx, Object.class);
                res.add(elm);
                ++i;
            }
            return (T)res;
        }
        if (objectType.equals(Set.class)) {
            HashSet<Object> res = new HashSet<Object>();
            int i = 0;
            while (buf.containsKey(prefix + "items[" + i + "].class")) {
                String prfx = prefix + "items[" + i + "]";
                Object elm = StringMapCodec.decode(buf, prfx, Object.class);
                res.add(elm);
                ++i;
            }
            return (T)res;
        }
        if (objectType.equals(Map.class)) {
            HashMap<Object, Object> res = new HashMap<Object, Object>();
            int i = 0;
            while (buf.containsKey(prefix + "entries[" + i + "].key.class")) {
                String kprfx = prefix + "entries[" + i + "].key";
                String vprfx = prefix + "entries[" + i + "].value";
                Object key = StringMapCodec.decode(buf, kprfx, Object.class);
                Object value = StringMapCodec.decode(buf, vprfx, Object.class);
                res.put(key, value);
                ++i;
            }
            return (T)res;
        }
        if (objectType.isEnum()) {
            String val = buf.get(prefix + "value");
            return (T)StringMapCodec.createEnum(objectType, val);
        }
        if (objectType.equals(Date.class)) {
            String val = buf.get(prefix + "value");
            return (T)Dates.parse(val, "yyyy/MM/dd HH:mm:ss.SSS");
        }
        Class<?> builderClass = StringMapCodec.getBuilderClass(objectType.getName());
        SortedSet<String> properties = StringMapCodec.getPropertyNames(builderClass);
        Object builder = StringMapCodec.createObject(builderClass);
        for (String property : properties) {
            String prfx = prefix + property;
            Object val = StringMapCodec.decode(buf, prfx, Object.class);
            StringMapCodec.setPropertyValue(builder, property, val);
        }
        return (T)StringMapCodec.buildObject(builder);
    }

    private static Class<?> getBuilderClass(String objClassName) {
        try {
            Class<?> builderClass = Class.forName(objClassName + "$Builder");
            return builderClass;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("builder class is not defined, this is not supported: " + objClassName, e);
        }
    }

    private static Class<?> getClass(String className) {
        try {
            Class<?> builderClass = Class.forName(className);
            return builderClass;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("class not found: " + className, e);
        }
    }

    private static SortedSet<String> getPropertyNames(Class<?> clazz) {
        TreeSet<String> res = new TreeSet<String>();
        Field[] fields = clazz.getDeclaredFields();
        if (fields == null) {
            return res;
        }
        for (Field field : fields) {
            res.add(field.getName());
        }
        return res;
    }

    private static Object createObject(Class<?> clazz) {
        try {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object res = constructor.newInstance(new Object[0]);
            return res;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object createEnum(Class<?> clazz, String value) {
        try {
            Method method = clazz.getMethod("valueOf", String.class);
            Object res = method.invoke(null, value);
            return res;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object buildObject(Object builderObject) {
        try {
            Method method = builderObject.getClass().getMethod("build", new Class[0]);
            Object res = method.invoke(builderObject, new Object[0]);
            return res;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> getPropertyClass(Object obj, String property) {
        try {
            Field field = obj.getClass().getDeclaredField(property);
            return field.getType();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object getPropertyValue(Object obj, String property) {
        try {
            Field field = obj.getClass().getDeclaredField(property);
            if (field.isAccessible()) {
                return field.get(obj);
            }
            field.setAccessible(true);
            Object res = field.get(obj);
            field.setAccessible(false);
            return res;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setPropertyValue(Object obj, String property, Object value) {
        if (StringMapCodec.setPropertyValueBySetter(obj, property, value)) {
            return;
        }
        if (StringMapCodec.setPropertyValueByInjection(obj, property, value)) {
            return;
        }
        throw new RuntimeException("Unable to set property value: obj = " + obj + "; property = " + property + "; value = " + value);
    }

    private static boolean setPropertyValueBySetter(Object obj, String property, Object value) {
        String setterName = "set" + StringUtils.capitalize((String)property);
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        Method setter = null;
        for (Method candidate : methods) {
            Class<?>[] parameters;
            if (!candidate.getName().equals(setterName) || (parameters = candidate.getParameterTypes()).length != 1) continue;
            if (value == null) {
                setter = candidate;
                continue;
            }
            if (parameters[0].isPrimitive() && (parameters[0].equals(Double.TYPE) && value.getClass().equals(Double.class) || parameters[0].equals(Float.TYPE) && value.getClass().equals(Float.class) || parameters[0].equals(Long.TYPE) && value.getClass().equals(Long.class) || parameters[0].equals(Integer.TYPE) && value.getClass().equals(Integer.class) || parameters[0].equals(Byte.TYPE) && value.getClass().equals(Byte.class) || parameters[0].equals(Boolean.TYPE) && value.getClass().equals(Boolean.class))) {
                setter = candidate;
                continue;
            }
            if (parameters[0].isAssignableFrom(SortedSet.class) && value.getClass().equals(HashSet.class)) {
                value = new TreeSet((Set)((Object)value));
                setter = candidate;
            }
            if (parameters[0].isAssignableFrom(SortedMap.class) && value.getClass().equals(HashMap.class)) {
                value = new TreeMap((Map)((Object)value));
                setter = candidate;
            }
            if (!parameters[0].isAssignableFrom(value.getClass())) continue;
            setter = candidate;
        }
        if (setter == null) {
            return false;
        }
        try {
            setter.invoke(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private static boolean setPropertyValueByInjection(Object obj, String property, Object value) {
        Class<?> clazz = obj.getClass();
        Field field = null;
        try {
            field = clazz.getDeclaredField(property);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        try {
            Class<Object> fc = field.getType();
            Class<?> vc = value.getClass();
            if (fc.isAssignableFrom(SortedSet.class) && !fc.isAssignableFrom(Set.class) && vc.equals(HashSet.class)) {
                value = new TreeSet((Set)((Object)value));
            }
            if (fc.isAssignableFrom(SortedMap.class) && !fc.isAssignableFrom(Map.class) && vc.equals(HashMap.class)) {
                value = new TreeMap((Map)((Object)value));
            }
            if (field.isAccessible()) {
                field.set(obj, value);
            } else {
                field.setAccessible(true);
                field.set(obj, value);
                field.setAccessible(false);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private static Object getPrimitiveValue(Class<?> clazz, String val) {
        if (clazz.equals(String.class)) {
            return val;
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return Double.valueOf(val);
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return Float.valueOf(val);
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return Long.valueOf(val);
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return Integer.valueOf(val);
        }
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            return Byte.valueOf(val);
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return Boolean.valueOf(val);
        }
        throw new RuntimeException("unknown primitive type class: " + clazz);
    }
}

