/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils;

import com.enterprisemath.utils.DayOfWeek;
import com.enterprisemath.utils.Month;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.time.DateUtils;

public class Dates {
    private Dates() {
    }

    public static Date now() {
        return new Date();
    }

    public static Date today() {
        return DateUtils.truncate((Date)new Date(), (int)5);
    }

    public static Date yesterday() {
        return DateUtils.addDays((Date)Dates.today(), (int)-1);
    }

    public static Date tomorrow() {
        return DateUtils.addDays((Date)Dates.today(), (int)1);
    }

    public static Date fromToday(int numDays) {
        return DateUtils.addDays((Date)Dates.today(), (int)numDays);
    }

    public static Date createDate(int year, Month month, int day) {
        return Dates.createTime(year, month, day, 0, 0, 0, 0);
    }

    public static Date createTime(int year, Month month, int day, int hour, int minute, int second) {
        return Dates.createTime(year, month, day, hour, minute, second, 0);
    }

    public static Date createTime(int year, Month month, int day, int hour, int minute, int second, int millisecond) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        calendar.set(1, year);
        switch (month) {
            case JANUARY: {
                calendar.set(2, 0);
                break;
            }
            case FEBRUARY: {
                calendar.set(2, 1);
                break;
            }
            case MARCH: {
                calendar.set(2, 2);
                break;
            }
            case APRIL: {
                calendar.set(2, 3);
                break;
            }
            case MAY: {
                calendar.set(2, 4);
                break;
            }
            case JUNE: {
                calendar.set(2, 5);
                break;
            }
            case JULY: {
                calendar.set(2, 6);
                break;
            }
            case AUGUST: {
                calendar.set(2, 7);
                break;
            }
            case SEPTEMBER: {
                calendar.set(2, 8);
                break;
            }
            case OCTOBER: {
                calendar.set(2, 9);
                break;
            }
            case NOVEMBER: {
                calendar.set(2, 10);
                break;
            }
            case DECEMBER: {
                calendar.set(2, 11);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown month: month = " + (Object)((Object)month));
            }
        }
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar.getTime();
    }

    public static int getMinuteOfDay(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(11) * 60 + calendar.get(12);
    }

    public static int getHourOfDay(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int getDayOfYear(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(6);
    }

    public static int getYear(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static Month getMonth(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int month = calendar.get(2);
        switch (month) {
            case 0: {
                return Month.JANUARY;
            }
            case 1: {
                return Month.FEBRUARY;
            }
            case 2: {
                return Month.MARCH;
            }
            case 3: {
                return Month.APRIL;
            }
            case 4: {
                return Month.MAY;
            }
            case 5: {
                return Month.JUNE;
            }
            case 6: {
                return Month.JULY;
            }
            case 7: {
                return Month.AUGUST;
            }
            case 8: {
                return Month.SEPTEMBER;
            }
            case 9: {
                return Month.OCTOBER;
            }
            case 10: {
                return Month.NOVEMBER;
            }
            case 11: {
                return Month.DECEMBER;
            }
        }
        throw new IllegalArgumentException("unknown month: month = " + month);
    }

    public static int getDayOfMonth(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static DayOfWeek getDayOfWeek(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int dow = calendar.get(7);
        switch (dow) {
            case 1: {
                return DayOfWeek.SUNDAY;
            }
            case 2: {
                return DayOfWeek.MONDAY;
            }
            case 3: {
                return DayOfWeek.TUESDAY;
            }
            case 4: {
                return DayOfWeek.WEDNESDAY;
            }
            case 5: {
                return DayOfWeek.THURSDAY;
            }
            case 6: {
                return DayOfWeek.FRIDAY;
            }
            case 7: {
                return DayOfWeek.SATURDAY;
            }
        }
        throw new IllegalArgumentException("unknown day of the week: day of the week = " + dow);
    }

    public static int getDifferenceInDays(Date first, Date second) {
        Date firstDay = DateUtils.truncate((Date)first, (int)5);
        Date secondDay = DateUtils.truncate((Date)second, (int)5);
        return Long.valueOf((secondDay.getTime() - firstDay.getTime()) / 1000L / 60L / 60L / 24L).intValue();
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static Date parse(String date, String ... patterns) {
        for (String pattern : patterns) {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            try {
                return sdf.parse(date);
            }
            catch (ParseException e) {
            }
        }
        throw new IllegalArgumentException("no pattern matches the date format: date = " + date + ", patterns = " + Arrays.asList(patterns));
    }

    public static boolean safeEqualsToSeconds(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 == null || date2 == null) {
            return false;
        }
        return DateUtils.truncatedEquals((Date)date1, (Date)date2, (int)13);
    }
}

