/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils;

import com.enterprisemath.utils.DatesProvider;
import com.enterprisemath.utils.UniqueCodeGenerator;
import com.enterprisemath.utils.ValidationUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class AlphanumericUniqueCodeGenerator
implements UniqueCodeGenerator {
    private String staticPart;
    private Integer numRandomCharacters;
    private DatesProvider datesProvider;
    private String lastTimePart = null;
    private Lock lock = new ReentrantLock();

    public AlphanumericUniqueCodeGenerator(Builder builder) {
        this.staticPart = builder.staticPart;
        this.numRandomCharacters = builder.numRandomCharacters;
        this.datesProvider = builder.datesProvider;
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotNull(this.staticPart, "staticPart cannot be null");
        ValidationUtils.guardNotNull(this.numRandomCharacters, "numRandomCharacters cannot be null");
        ValidationUtils.guardNotNegativeInt(this.numRandomCharacters, "numRandomCharacters cannot be negative");
        ValidationUtils.guardNotNull(this.datesProvider, "datesProvider cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateUniqueCode(String prefix) {
        this.lock.lock();
        try {
            String tm = StringUtils.reverse((String)Long.toString(this.datesProvider.now().getTime(), 36).toUpperCase());
            while (tm.equals(this.lastTimePart)) {
                tm = StringUtils.reverse((String)Long.toString(this.datesProvider.now().getTime(), 36).toUpperCase());
            }
            this.lastTimePart = tm;
            String string = prefix + "-" + this.staticPart + RandomStringUtils.randomAlphanumeric((int)this.numRandomCharacters).toUpperCase() + tm;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> generateUniqueCodes(String prefix, int number) {
        this.lock.lock();
        try {
            HashSet<String> res = new HashSet<String>();
            while (res.size() != number) {
                String tm = StringUtils.reverse((String)Long.toString(this.datesProvider.now().getTime(), 36).toUpperCase());
                while (tm.equals(this.lastTimePart)) {
                    tm = StringUtils.reverse((String)Long.toString(this.datesProvider.now().getTime(), 36).toUpperCase());
                }
                this.lastTimePart = tm;
                int currentSize = res.size();
                for (int i = 0; i < number - currentSize; ++i) {
                    res.add(prefix + "-" + this.staticPart + RandomStringUtils.randomAlphanumeric((int)this.numRandomCharacters).toUpperCase() + tm);
                }
            }
            HashSet<String> hashSet = res;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class Builder {
        private String staticPart;
        private Integer numRandomCharacters;
        private DatesProvider datesProvider;

        public Builder setStaticPart(String staticPart) {
            this.staticPart = staticPart;
            return this;
        }

        public Builder setNumRandomCharacters(int numRandomCharacters) {
            this.numRandomCharacters = numRandomCharacters;
            return this;
        }

        public Builder setDatesProvider(DatesProvider datesProvider) {
            this.datesProvider = datesProvider;
            return this;
        }

        public AlphanumericUniqueCodeGenerator build() {
            return new AlphanumericUniqueCodeGenerator(this);
        }
    }
}

