package com.enterprisemath.utils.messaging;

import com.enterprisemath.utils.Dates;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

/**
 * Classes for messaging related utility methods.
 *
 * @author radek.hecl
 */
public class MessagingUtils {

    /**
     * Prevent construction.
     */
    private MessagingUtils() {
    }

    /**
     * Creates default template provider.
     *
     * @param templateDirectoryPath path to the directory with templates
     * @return created provider
     */
    public static MessageTemplateProvider createDefaultTemplateProvider(String templateDirectoryPath) {
        final String tdp = templateDirectoryPath;
        return new MessageTemplateProvider() {

            @Override
            public String getTemplate(String messageType, String part) {
                return tdp + "/" + messageType + "-" + part + ".vm";
            }
        };
    }

    /**
     * Creates default model.
     * Default model is pre populated with keys starting with capital letter.
     * In the future more elements might be added to the model.
     * If you use and additional model data, then make sure they are not starting with capital letter.
     *
     * @param model additional model which will be merged
     * @return created model
     */
    public static Map<String, Object> createDefaultModel(Map<String, Object> model) {
        Map<String, Object> res = new HashMap<String, Object>();
        res.put("Dates", Dates.class);
        res.put("URLEncoder", URLEncoder.class);
        res.putAll(model);
        return res;
    }

}
