package com.enterprisemath.utils;

import java.util.Date;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * Default implementation of the dates provider.
 *
 * @author radek.hecl
 *
 */
public class DefaultDatesProvider implements DatesProvider {

    /**
     * Builder object.
     */
    public static class Builder {

        /**
         * Builds the result object.
         *
         * @return created object
         */
        public DefaultDatesProvider build() {
            return new DefaultDatesProvider(this);
        }

    }

    /**
     * Creates new instance.
     *
     * @param builder builder object
     */
    public DefaultDatesProvider(Builder builder) {
        guardInvariants();
    }

    /**
     * Guards this object to be consistent. Throws exception if this is not the case.
     */
    private void guardInvariants() {
    }

    @Override
    public Date yesterday() {
        return Dates.yesterday();
    }

    @Override
    public Date today() {
        return Dates.today();
    }

    @Override
    public Date now() {
        return Dates.now();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    /**
     * Creates new default dates provider.
     *
     * @return created provider
     */
    public static DefaultDatesProvider create() {
        return new DefaultDatesProvider.Builder().
                build();
    }

}
