package com.enterprisemath.utils;

import java.util.Date;

/**
 * Interface which providing functions to access the popular dates.
 *
 * <p>
 * <strong>Note:</strong> Adding functions to this interface will <strong>NOT</strong> be
 * considered as breaking binary compatibility.
 * </p>
 *
 * @author radek.hecl
 *
 */
public interface DatesProvider {

    /**
     * Returns the yesterdays date. This is truncated to date minus 1 day.
     *
     * @return yesterdays date
     */
    public Date yesterday();

    /**
     * Returns todays date. This is current timestamp which is truncated to days.
     *
     * @return todays date
     */
    public Date today();

    /**
     * Returns the current timestamp.
     *
     * @return current timestamp
     */
    public Date now();

}
