/*
 * Decompiled with CFR 0.152.
 */
package com.empyr.api.model;

import com.empyr.api.annotations.ApiField;
import com.empyr.api.annotations.Documented;
import com.empyr.api.model.RestBase;
import com.empyr.api.model.RestCompactUser;
import java.util.Date;

@Documented(name="userSummary", description="An object that summarizes stats about the given user in the current month.")
public class RestUserTxSummary
extends RestBase {
    @ApiField(value="The id of the user summary object.")
    public Integer id;
    @ApiField(value="The month that this summary is over.")
    public Date date;
    @ApiField(value="The balance of the user.")
    public Double balance;
    @ApiField(value="The cashback earned this month")
    public Double curMonthCashback;
    @ApiField(value="The total cashback earned up to this month.")
    public Double totalCashback;
    @ApiField(value="The spend this month.")
    public Double curMonthRevenue;
    @ApiField(value="The total spend up to this month.")
    public Double totalRevenue;
    @ApiField(value="The number of meals donated this month.")
    public int curMonthMealsDonated;
    @ApiField(value="The total number of meals donated up to this month.")
    public int totalMealsDonated;
    @ApiField(value="The number of transactions this month.")
    public int curMonthTransactions;
    @ApiField(value="The total number of transactions up to this month.")
    public int totalTransactions;
    @ApiField(value="The amount of donations this month.")
    public Double curMonthDonationValue;
    @ApiField(value="The amount of donations all time.")
    public Double totalDonationValue;
    @ApiField(value="The total number of jackpots won up to this month.")
    public int totalJackpotsWon;
    @ApiField(value="The total number of distinct places visited.")
    public int totalPlaces;
    @ApiField(value="The meals donated over the last 90 days.")
    public int mealsDonated90;
    @ApiField(value="The total donation value over the last 90 days.")
    public Double donationLast90;
    @ApiField(value="The rank of this object in a leaderboard. Note that this will only be provided on leaderboard methods.")
    public Integer rank;
    @ApiField(value="The compact user for this summary.")
    public RestCompactUser user;
    @ApiField(value="The next period for which the user can expect a payment.")
    public Date nextPayPeriodDate;
    public Double nextPayPeriodAmount;
    @ApiField(value="The expected payout to the user.")
    public Double expectedPayout;
    @ApiField(value="The total amount of money earned from jackpots, cashback, friends etc.")
    public Double moneyEarned;
}

