/*
 * Decompiled with CFR 0.152.
 */
package com.empyr.api;

import com.empyr.api.HttpRequest;
import com.empyr.api.model.RestResponse;
import com.empyr.api.util.MethodType;
import com.empyr.api.util.TypeReference;
import java.util.HashMap;
import java.util.Map;

public class Request<T>
extends HttpRequest {
    private RestResponse<T> response;
    private boolean requiresToken = false;
    private Map<String, Object> expected = new HashMap<String, Object>();

    protected Request(MethodType t, String endPoint, boolean requiresToken) {
        super(t, endPoint);
        this.requiresToken = requiresToken;
    }

    public static <F> Request<F> createRequest(MethodType get, String endpoint) {
        return Request.createRequest(get, endpoint, false);
    }

    public static <F> Request<F> createRequest(MethodType get, String endpoint, boolean requiresToken) {
        return Request.createRequest(get, endpoint, requiresToken, null);
    }

    public static <F> Request<F> createRequest(MethodType get, String endpoint, boolean requiresToken, String userToken) {
        Request r = new Request(get, endpoint, requiresToken);
        if (userToken != null) {
            r.addParams(new Object[]{"user_token", userToken});
        }
        return r;
    }

    @Override
    public Request<T> addParams(Map<String, Object> params) {
        super.addParams(params);
        return this;
    }

    @Override
    public Request<T> addParams(Object ... params) {
        super.addParams(params);
        return this;
    }

    public Map<String, Object> getExpected() {
        return this.expected;
    }

    public Request<T> expects(String returnKey, Class<?> response) {
        this.expected.put(returnKey, response);
        return this;
    }

    public <F> Request<T> expects(String returnKey, TypeReference<F> type) {
        this.expected.put(returnKey, type);
        return this;
    }

    public RestResponse<T> getResponse() {
        return this.response;
    }

    public void setResponse(RestResponse<T> response) {
        this.response = response;
    }

    public boolean isRequiresToken() {
        return this.requiresToken;
    }
}

