/*
 * Decompiled with CFR 0.152.
 */
package com.empyr.api.util;

import com.empyr.api.model.RestUrl;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.util.Date;

public class ApiJacksonObjectMapper
extends ObjectMapper {
    private StdScalarSerializer<RestUrl> urlSerializer = null;
    private StdScalarDeserializer<RestUrl> urlDeserializer = null;

    public StdScalarSerializer<RestUrl> getUrlSerializer() {
        return this.urlSerializer;
    }

    public void setUrlSerializer(StdScalarSerializer<RestUrl> urlSerializer) {
        this.urlSerializer = urlSerializer;
    }

    public StdScalarDeserializer<RestUrl> getUrlDeserializer() {
        return this.urlDeserializer;
    }

    public void setUrlDeserializer(StdScalarDeserializer<RestUrl> urlDeserializer) {
        this.urlDeserializer = urlDeserializer;
    }

    public ApiJacksonObjectMapper() {
        JacksonAnnotationIntrospector primary = new JacksonAnnotationIntrospector();
        this.getDeserializationConfig().with((AnnotationIntrospector)primary);
        this.getSerializationConfig().with((AnnotationIntrospector)primary);
        this.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static ObjectMapper getInstance(StdScalarSerializer<RestUrl> serializer, StdScalarDeserializer<RestUrl> deserializer) {
        ApiJacksonObjectMapper mapper = new ApiJacksonObjectMapper();
        SimpleModule module = new SimpleModule("UrlModule");
        if (serializer != null) {
            module.addSerializer(RestUrl.class, serializer);
        }
        if (deserializer != null) {
            module.addDeserializer(RestUrl.class, deserializer);
        }
        mapper.registerModule((Module)module);
        module = new SimpleModule("DecimalModule");
        module.addSerializer(Double.class, (JsonSerializer)new StdScalarSerializer<Double>(Double.class){

            public void serialize(Double value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
                if (value != null) {
                    double rval = (double)Math.round(value * 100.0) / 100.0;
                    jgen.writeNumber(rval);
                }
            }
        });
        module.addSerializer(Float.class, (JsonSerializer)new StdScalarSerializer<Float>(Float.class){

            public void serialize(Float value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
                if (value != null) {
                    double rval = (double)Math.round(value.floatValue() * 100.0f) / 100.0;
                    jgen.writeNumber(rval);
                }
            }
        });
        mapper.registerModule((Module)module);
        module = new SimpleModule("DateModule");
        module.addSerializer(Date.class, (JsonSerializer)new StdScalarSerializer<Date>(Date.class){

            public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
                if (value != null) {
                    long time = value.getTime() / 1000L;
                    jgen.writeNumber(time);
                }
            }
        });
        module.addDeserializer(Date.class, (JsonDeserializer)new StdScalarDeserializer<Date>(Date.class){

            public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                long time = jp.getLongValue() * 1000L;
                if (jp.getValueAsString().length() > 12) {
                    time = jp.getLongValue();
                }
                return new Date(time);
            }
        });
        mapper.registerModule((Module)module);
        return mapper;
    }

    public final class UrlStringModule
    extends SimpleModule {
        public UrlStringModule() {
            if (ApiJacksonObjectMapper.this.urlSerializer != null) {
                this.addSerializer(RestUrl.class, (JsonSerializer)ApiJacksonObjectMapper.this.urlSerializer);
            }
            if (ApiJacksonObjectMapper.this.urlDeserializer != null) {
                this.addDeserializer(RestUrl.class, (JsonDeserializer)ApiJacksonObjectMapper.this.urlDeserializer);
            }
        }
    }
}

