/*
 * Decompiled with CFR 0.152.
 */
package com.empyr.api.model;

import com.empyr.api.annotations.ApiField;
import com.empyr.api.annotations.Documented;
import com.empyr.api.model.RestBase;
import com.empyr.api.model.RestCompactUser;
import com.empyr.api.model.RestFundraiserSummary;
import com.empyr.api.model.RestUrl;
import java.util.Date;

@Documented(name="fundraiser", description="Represents a fundraiser that a user can donate to.")
public class RestFundraiser
extends RestBase {
    @ApiField(value="The id of the fundraiser.")
    public Integer id;
    @ApiField(value="The name of the fundraiser.")
    public String name;
    @ApiField(value="A description of the fundraiser.")
    public String description;
    @ApiField(value="A code that can be used to help people sign up to the fundraiser.")
    public String fundraiserCode;
    @ApiField(value="The goal for the fundraiser.")
    public Double goalAmount;
    @ApiField(value="A thumbnail of the fundraiser.", optional=true)
    public RestUrl thumbnailUrl;
    @ApiField(value="The website for the fundraiser.", nullable=true)
    public String website;
    @ApiField(value="A date when the fundraiser would end.", nullable=true)
    public Date endDate;
    @ApiField(value="The organizer of the fundraiser.")
    public RestCompactUser organizer;
    @ApiField(value="The summary information about this fundraiser. Only appended in search.")
    public RestFundraiserSummary fundraiserSummary;
}

