/*
 * Decompiled with CFR 0.152.
 */
package com.empyr.api.model;

import com.empyr.api.annotations.ApiField;
import com.empyr.api.annotations.Documented;
import com.empyr.api.model.RestBase;
import java.util.Date;

@Documented(name="redemption", description="Represents a redemption that was applied to the transaction.")
public class RestRedemption
extends RestBase {
    @ApiField(value="The id of the redemption.")
    public Integer id;
    @ApiField(value="The state of the redemption (can be UNQUALIFIED, PENDING, COMPLETED, or REVERSED). PENDING would only be the case on a multi purchase offer.")
    public RedeemState state;
    @ApiField(value="The date the redemption was added.")
    public Date dateAdded;
    @ApiField(value="The date that the redemption was reversed. Only supplied when the transaction is in fact reversed.")
    public Date dateReversed;
    @ApiField(value="The cashback amount rewarded to the consumer.")
    public double cashbackAmount = 0.0;
    @ApiField(value="The referral fee collected from the merchant.")
    public double referralFee = 0.0;
    @ApiField(value="The amount of qualified spend applied to the redemption.")
    public double qualifiedSpend = 0.0;
    @ApiField(value="The amount of publisher commission earned.")
    public double publisherCommission = 0.0;
    @ApiField(value="The amount of reseller commission earned.")
    public double resellerCommission = 0.0;
    @ApiField(value="The id of the offer that triggered this redemption.")
    public Integer offerId;
    @ApiField(value="The post dine survey link (if applicable).")
    public String surveyLink;

    public static enum RedeemState {
        PENDING,
        COMPLETED,
        REVERSED,
        UNQUALIFIED;

    }
}

