/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.encryption;

import com.emc.vipr.transform.TransformException;
import com.emc.vipr.transform.encryption.EncryptionInputTransform;
import com.emc.vipr.transform.encryption.KeyUtils;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class BasicEncryptionInputTransform
extends EncryptionInputTransform {
    private CipherInputStream decryptedInput;

    public BasicEncryptionInputTransform(String transformConfig, InputStream streamToDecode, Map<String, String> metadataToDecode, KeyPair masterKey, Provider provider) throws TransformException {
        super(streamToDecode, metadataToDecode, provider);
        String[] transformParams = transformConfig.split("/");
        if (transformParams.length != 3) {
            throw new TransformException("Encryption configuration should be in the form Alg/Mode/Padding: " + transformConfig);
        }
        String encodedObjectKey = metadataToDecode.get("x-emc-enc-object-key");
        if (encodedObjectKey == null) {
            throw new TransformException("Object key not found in object metadata");
        }
        SecretKey sk = KeyUtils.decryptKey(encodedObjectKey, transformParams[0], provider, masterKey.getPrivate());
        String encodedIv = metadataToDecode.get("x-emc-iv");
        if (encodedIv == null) {
            throw new TransformException("Initialization Vector (IV) not found in object metadata");
        }
        byte[] ivData = KeyUtils.urlSafeDecodeBase64(encodedIv);
        try {
            Cipher cipher = null;
            cipher = provider != null ? Cipher.getInstance(transformConfig, provider) : Cipher.getInstance(transformConfig);
            IvParameterSpec ivspec = new IvParameterSpec(ivData);
            cipher.init(2, (Key)sk, ivspec);
            this.decryptedInput = new CipherInputStream(streamToDecode, cipher);
        }
        catch (GeneralSecurityException e) {
            throw new TransformException("Could not initialize cipher", e);
        }
    }

    @Override
    public InputStream getDecodedInputStream() {
        return this.decryptedInput;
    }

    @Override
    public Map<String, String> getDecodedMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.putAll(this.metadataToDecode);
        return metadata;
    }
}

