/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.compression;

import com.emc.vipr.transform.compression.CompressionStream;
import com.emc.vipr.transform.encryption.KeyUtils;
import com.emc.vipr.transform.util.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;

public class DeflateInputFilter
extends InputStream
implements CompressionStream {
    private CountingInputStream uncompressedCounter;
    private CountingInputStream compressedCounter;
    private DigestInputStream digester;
    private boolean closed;
    private byte[] uncompressedDigest;

    public DeflateInputFilter(InputStream in, int level) throws IOException {
        Deflater def = new Deflater(level);
        this.uncompressedCounter = new CountingInputStream(in);
        try {
            this.digester = new DigestInputStream(this.uncompressedCounter, MessageDigest.getInstance("SHA1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unable to initialize digest", e);
        }
        DeflaterInputStream deflateFilter = new DeflaterInputStream(this.digester, def);
        this.compressedCounter = new CountingInputStream(deflateFilter);
    }

    @Override
    public int read() throws IOException {
        return this.compressedCounter.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.compressedCounter.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.compressedCounter.read(b);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.compressedCounter.close();
        this.uncompressedDigest = this.digester.getMessageDigest().digest();
    }

    @Override
    public int available() throws IOException {
        return this.compressedCounter.available();
    }

    @Override
    public Map<String, String> getStreamMetadata() {
        if (!this.closed) {
            throw new IllegalStateException("Stream must be closed before getting metadata");
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        long compSize = this.compressedCounter.getByteCount();
        long uncompSize = this.uncompressedCounter.getByteCount();
        String compRatioString = String.format("%.1f%%", 100.0 - (double)compSize * 100.0 / (double)uncompSize);
        metadata.put("x-emc-comp-uncompressed-size", "" + uncompSize);
        metadata.put("x-emc-comp-compressed-size", "" + compSize);
        metadata.put("x-emc-comp-compression-ratio", "" + compRatioString);
        metadata.put("x-emc-comp-uncompressed-sha1", KeyUtils.toHexPadded(this.uncompressedDigest));
        return metadata;
    }
}

