/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.compression;

import com.emc.codec.EncodeOutputStream;
import com.emc.codec.compression.CompressionException;
import com.emc.codec.compression.CompressionMetadata;
import com.emc.codec.util.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class CompressionOutputStream
extends EncodeOutputStream<CompressionMetadata> {
    private CompressionMetadata metadata;
    private boolean closed = false;
    private CountingOutputStream uncompressedCounter;
    private CountingOutputStream compressedCounter;
    private DigestOutputStream digester;

    public CompressionOutputStream(OutputStream output, String encodeSpec) {
        super(output);
        this.metadata = new CompressionMetadata(encodeSpec);
    }

    protected abstract OutputStream getCompressionStream(OutputStream var1) throws IOException;

    protected void initStreams(OutputStream originalStream) {
        try {
            this.compressedCounter = new CountingOutputStream(originalStream);
            OutputStream compressionStream = this.getCompressionStream(this.compressedCounter);
            this.uncompressedCounter = new CountingOutputStream(compressionStream);
            this.digester = new DigestOutputStream(this.uncompressedCounter, MessageDigest.getInstance("SHA1"));
            this.out = this.digester;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CompressionException("Unable to initialize digest", e);
        }
        catch (IOException e) {
            throw new CompressionException("Could not create compression stream", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        this.metadata.setOriginalSize(this.uncompressedCounter.getByteCount());
        this.metadata.setCompressedSize(this.compressedCounter.getByteCount());
        this.metadata.setOriginalDigest(this.digester.getMessageDigest().digest());
        this.notifyListeners();
    }

    @Override
    public CompressionMetadata getEncodeMetadata() {
        return this.metadata;
    }
}

