/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.util;

import com.emc.object.util.ChecksumAlgorithm;

public abstract class ChecksumValue {
    public abstract ChecksumAlgorithm getAlgorithm();

    public abstract long getOffset();

    public abstract byte[] getByteValue();

    public abstract String getHexValue();

    @Deprecated
    public String getValue() {
        return this.getHexValue();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteCount) {
        String out = this.getAlgorithm().toString();
        if (includeByteCount) {
            out = out + "/" + this.getOffset();
        }
        out = out + "/" + this.getHexValue();
        return out;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChecksumValue)) {
            return false;
        }
        ChecksumValue that = (ChecksumValue)o;
        if (this.getOffset() != that.getOffset()) {
            return false;
        }
        if (this.getAlgorithm() != that.getAlgorithm()) {
            return false;
        }
        return this.getHexValue().equals(that.getHexValue());
    }

    public int hashCode() {
        int result = this.getAlgorithm().hashCode();
        result = 31 * result + (int)(this.getOffset() ^ this.getOffset() >>> 32);
        result = 31 * result + this.getHexValue().hashCode();
        return result;
    }
}

