/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.EntityRequest;
import com.emc.object.Method;
import com.emc.object.s3.bean.AccessControlList;
import com.emc.object.s3.bean.CannedAcl;
import com.emc.object.s3.request.S3ObjectRequest;
import com.emc.object.util.RestUtil;
import java.util.List;
import java.util.Map;

public class SetObjectAclRequest
extends S3ObjectRequest
implements EntityRequest {
    private String versionId;
    private AccessControlList acl;
    private CannedAcl cannedAcl;

    public SetObjectAclRequest(String bucketName, String key) {
        super(Method.PUT, bucketName, key, "acl");
        this.property("com.emc.object.generateContentMd5", Boolean.TRUE);
    }

    @Override
    public Map<String, String> getQueryParams() {
        Map<String, String> queryParams = super.getQueryParams();
        if (this.versionId != null) {
            queryParams.put("versionId", this.versionId);
        }
        return queryParams;
    }

    @Override
    public Map<String, List<Object>> getHeaders() {
        Map<String, List<Object>> headers = super.getHeaders();
        if (this.cannedAcl != null) {
            RestUtil.putSingle(headers, "x-amz-acl", this.cannedAcl.getHeaderValue());
        }
        return headers;
    }

    @Override
    public Object getEntity() {
        return this.acl;
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    @Override
    public Long getContentLength() {
        return null;
    }

    @Override
    public boolean isChunkable() {
        return false;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public CannedAcl getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAcl cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public SetObjectAclRequest withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public SetObjectAclRequest withAcl(AccessControlList acl) {
        this.setAcl(acl);
        return this;
    }

    public SetObjectAclRequest withCannedAcl(CannedAcl cannedAcl) {
        this.setCannedAcl(cannedAcl);
        return this;
    }
}

