/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.Method;
import com.emc.object.s3.bean.AccessControlList;
import com.emc.object.s3.bean.CannedAcl;
import com.emc.object.s3.bean.MetadataSearchKey;
import com.emc.object.s3.request.AbstractBucketRequest;
import com.emc.object.util.RestUtil;
import java.util.List;
import java.util.Map;

public class CreateBucketRequest
extends AbstractBucketRequest {
    private CannedAcl cannedAcl;
    private AccessControlList acl;
    private String vPoolId;
    private Boolean fileSystemEnabled;
    private Boolean staleReadAllowed;
    private Boolean encryptionEnabled;
    private Long retentionPeriod;
    private String metadataSearchKeys;

    public CreateBucketRequest(String bucketName) {
        super(Method.PUT, bucketName, "", null);
    }

    @Override
    public Map<String, List<Object>> getHeaders() {
        Map<String, List<Object>> headers = super.getHeaders();
        if (this.cannedAcl != null) {
            RestUtil.putSingle(headers, "x-amz-acl", this.cannedAcl.getHeaderValue());
        }
        if (this.acl != null) {
            headers.putAll(this.acl.toHeaders());
        }
        if (this.vPoolId != null) {
            RestUtil.putSingle(headers, "x-emc-dataservice-vpool", this.vPoolId);
        }
        if (this.fileSystemEnabled != null) {
            RestUtil.putSingle(headers, "x-emc-file-system-access-enabled", this.fileSystemEnabled);
        }
        if (this.staleReadAllowed != null) {
            RestUtil.putSingle(headers, "x-emc-is-stale-allowed", this.staleReadAllowed);
        }
        if (this.encryptionEnabled != null) {
            RestUtil.putSingle(headers, "x-emc-server-side-encryption-enabled", this.encryptionEnabled);
        }
        if (this.retentionPeriod != null) {
            RestUtil.putSingle(headers, "x-emc-retention-period", this.retentionPeriod);
        }
        if (this.metadataSearchKeys != null) {
            RestUtil.putSingle(headers, "x-emc-metadata-search", this.metadataSearchKeys);
        }
        return headers;
    }

    public CannedAcl getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAcl cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public String getvPoolId() {
        return this.vPoolId;
    }

    public void setvPoolId(String vPoolId) {
        this.vPoolId = vPoolId;
    }

    public Boolean getFileSystemEnabled() {
        return this.fileSystemEnabled;
    }

    public void setFileSystemEnabled(Boolean fileSystemEnabled) {
        this.fileSystemEnabled = fileSystemEnabled;
    }

    public Boolean getStaleReadAllowed() {
        return this.staleReadAllowed;
    }

    public void setStaleReadAllowed(Boolean staleReadAllowed) {
        this.staleReadAllowed = staleReadAllowed;
    }

    public Boolean getEncryptionEnabled() {
        return this.encryptionEnabled;
    }

    public void setEncryptionEnabled(Boolean encryptionEnabled) {
        this.encryptionEnabled = encryptionEnabled;
    }

    public Long getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public void setRetentionPeriod(Long retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public void setMetadataSearchKeys(List<MetadataSearchKey> metadataSearchKeys) {
        StringBuilder sb = new StringBuilder();
        for (MetadataSearchKey key : metadataSearchKeys) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(key.getName()).append(';').append((Object)key.getDatatype());
        }
        this.metadataSearchKeys = sb.toString();
    }

    public CreateBucketRequest withCannedAcl(CannedAcl cannedAcl) {
        this.setCannedAcl(cannedAcl);
        return this;
    }

    public CreateBucketRequest withAcl(AccessControlList acl) {
        this.setAcl(acl);
        return this;
    }

    public CreateBucketRequest withVPoolId(String vPoolId) {
        this.setvPoolId(vPoolId);
        return this;
    }

    public CreateBucketRequest withFileSystemEnabled(boolean fileSystemEnabled) {
        this.setFileSystemEnabled(fileSystemEnabled);
        return this;
    }

    public CreateBucketRequest withStaleReadAllowed(boolean staleReadAllowed) {
        this.setStaleReadAllowed(staleReadAllowed);
        return this;
    }

    public CreateBucketRequest withEncryptionEnabled(Boolean encryptionEnabled) {
        this.setEncryptionEnabled(encryptionEnabled);
        return this;
    }

    public CreateBucketRequest withRetentionPeriod(long retentionPeriod) {
        this.setRetentionPeriod(retentionPeriod);
        return this;
    }

    public CreateBucketRequest withMetadataSearchKeys(List<MetadataSearchKey> metadataSearchKeys) {
        this.setMetadataSearchKeys(metadataSearchKeys);
        return this;
    }
}

