/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.s3.S3Config;
import com.emc.object.s3.S3SignerV2;
import com.emc.object.s3.VHostUtil;
import com.emc.object.util.ChecksumAlgorithm;
import com.emc.object.util.ChecksumError;
import com.emc.object.util.ChecksumValueImpl;
import com.emc.object.util.ChecksummedInputStream;
import com.emc.object.util.ChecksummedOutputStream;
import com.emc.object.util.RestUtil;
import com.emc.object.util.RunningChecksum;
import com.sun.jersey.api.client.AbstractClientRequestAdapter;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientRequestAdapter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

public class ChecksumFilter
extends ClientFilter {
    private S3Config s3Config;
    private S3SignerV2 signer;

    public ChecksumFilter(S3Config s3Config) {
        this.s3Config = s3Config;
        this.signer = new S3SignerV2(s3Config);
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        try {
            String contentMd5;
            ClientResponse response;
            String md5Header;
            Boolean generateMd5;
            ChecksumAdapter adapter = new ChecksumAdapter(request.getAdapter());
            Boolean verifyWrite = (Boolean)request.getProperties().get("com.emc.object.verifyWriteChecksum");
            if (verifyWrite != null && verifyWrite.booleanValue()) {
                request.setAdapter((ClientRequestAdapter)adapter);
            }
            if ((generateMd5 = (Boolean)request.getProperties().get("com.emc.object.generateContentMd5")) != null && generateMd5.booleanValue()) {
                ContentMd5Adapter md5Adapter = new ContentMd5Adapter(request.getAdapter());
                request.setAdapter((ClientRequestAdapter)md5Adapter);
            }
            if ((md5Header = RestUtil.getFirstAsString((response = this.getNext().handle(request)).getHeaders(), "ETag")) != null) {
                md5Header = md5Header.replaceAll("\"", "");
            }
            if (md5Header != null && (md5Header.length() <= 2 || md5Header.contains("-"))) {
                md5Header = null;
            }
            if ((contentMd5 = RestUtil.getFirstAsString(response.getHeaders(), "x-emc-content-md5")) != null) {
                md5Header = contentMd5;
            }
            if (verifyWrite != null && verifyWrite.booleanValue() && md5Header != null && !adapter.getChecksum().getHexValue().equals(md5Header)) {
                throw new ChecksumError("Checksum failure while writing stream", adapter.getChecksum().getHexValue(), md5Header);
            }
            Boolean verifyRead = (Boolean)request.getProperties().get("com.emc.object.verifyReadChecksum");
            if (verifyRead != null && verifyRead.booleanValue() && md5Header != null) {
                response.setEntityInputStream((InputStream)new ChecksummedInputStream(response.getEntityInputStream(), new ChecksumValueImpl(ChecksumAlgorithm.MD5, 0L, md5Header)));
            }
            return response;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("fatal: MD5 algorithm not found");
        }
    }

    private static interface CloseEventListener
    extends EventListener {
        public void streamClosed(CloseNotifyOutputStream var1) throws IOException;
    }

    private class CloseNotifyOutputStream
    extends FilterOutputStream {
        private List<CloseEventListener> listeners;

        CloseNotifyOutputStream(OutputStream out, CloseEventListener ... listeners) {
            super(out);
            this.listeners = new ArrayList<CloseEventListener>();
            if (listeners != null) {
                this.listeners.addAll(Arrays.asList(listeners));
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            super.close();
            for (CloseEventListener listener : this.listeners) {
                listener.streamClosed(this);
            }
        }
    }

    private class ContentMd5Adapter
    extends AbstractClientRequestAdapter
    implements CloseEventListener {
        ClientRequest request;
        OutputStream finalStream;
        RunningChecksum checksum;
        ByteArrayOutputStream buffer;

        ContentMd5Adapter(ClientRequestAdapter parent) {
            super(parent);
        }

        public OutputStream adapt(ClientRequest request, OutputStream out) throws IOException {
            this.request = request;
            this.finalStream = out;
            try {
                this.checksum = new RunningChecksum(ChecksumAlgorithm.MD5);
                this.buffer = new ByteArrayOutputStream();
                out = new CloseNotifyOutputStream(this.buffer, this);
                out = new ChecksummedOutputStream(out, this.checksum);
                return this.getAdapter().adapt(request, out);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("fatal: MD5 algorithm not found");
            }
        }

        @Override
        public void streamClosed(CloseNotifyOutputStream stream) throws IOException {
            this.request.getHeaders().putSingle((Object)"Content-MD5", (Object)DatatypeConverter.printBase64Binary((byte[])this.checksum.getByteValue()));
            if (ChecksumFilter.this.s3Config.getIdentity() != null) {
                Map<String, String> parameters = RestUtil.getQueryParameterMap(this.request.getURI().getRawQuery());
                String resource = VHostUtil.getResourceString(ChecksumFilter.this.s3Config, (String)this.request.getProperties().get("com.emc.object.namespace"), (String)this.request.getProperties().get("com.emc.object.s3.bucketName"), RestUtil.getEncodedPath(this.request.getURI()));
                ChecksumFilter.this.signer.sign(this.request.getMethod(), resource, parameters, (Map<String, List<Object>>)this.request.getHeaders());
            }
            this.finalStream.write(this.buffer.toByteArray());
        }
    }

    private class ChecksumAdapter
    extends AbstractClientRequestAdapter {
        RunningChecksum checksum;

        ChecksumAdapter(ClientRequestAdapter parent) {
            super(parent);
        }

        public OutputStream adapt(ClientRequest request, OutputStream out) throws IOException {
            try {
                this.checksum = new RunningChecksum(ChecksumAlgorithm.MD5);
                out = new ChecksummedOutputStream(out, this.checksum);
                return this.getAdapter().adapt(request, out);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("fatal: MD5 algorithm not found");
            }
        }

        public RunningChecksum getChecksum() {
            return this.checksum;
        }
    }
}

