/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object;

import com.emc.object.Method;
import com.emc.object.util.RestUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ObjectRequest {
    private String namespace;
    private Method method;
    private String path;
    private String subresource;
    private Map<String, List<Object>> customHeaders = new HashMap<String, List<Object>>();
    private Map<String, Object> properties = new HashMap<String, Object>();

    public ObjectRequest(Method method, String path, String subresource) {
        this.method = method;
        this.path = path;
        this.subresource = subresource;
    }

    public ObjectRequest(ObjectRequest other) {
        this.namespace = other.namespace;
        this.method = other.method;
        this.path = other.path;
        this.subresource = other.subresource;
        this.properties.putAll(other.properties);
    }

    public Map<String, String> getQueryParams() {
        return new TreeMap<String, String>();
    }

    public Map<String, List<Object>> getHeaders() {
        return new HashMap<String, List<Object>>(this.customHeaders);
    }

    public void addCustomHeader(String key, Object value) {
        RestUtil.putSingle(this.customHeaders, key, value);
    }

    public Map<String, List<Object>> getCustomHeaders() {
        return this.customHeaders;
    }

    public final String getQueryString() {
        return this.getRawQueryString();
    }

    public final String getRawQueryString() {
        String paramString = RestUtil.generateRawQueryString(this.getQueryParams());
        String queryString = "";
        if (this.subresource != null) {
            queryString = queryString + this.subresource;
        }
        if (paramString.length() > 0) {
            queryString = queryString + "&" + paramString;
        }
        if (queryString.startsWith("&")) {
            queryString = queryString.substring(1);
        }
        return queryString.length() > 0 ? queryString : null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    public String getSubresource() {
        return this.subresource;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void property(String name, Object value) {
        this.properties.put(name, value);
    }
}

