/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.common.util;

import com.embabel.common.util.AnsiBuilder;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a'\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\b\"\u00020\u0005\u00a2\u0006\u0002\u0010\t\u001a\u0012\u0010\n\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\u001a$\u0010\n\u001a\u00020\u0005*\u00020\u00052\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0012\u0010\n\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u0012\u0010\f\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\u001a\n\u0010\r\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u000e\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u000f\u001a\u00020\u0005*\u00020\u0005\u001a\u001f\u0010\u0010\u001a\u00020\u00052\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\b\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0012\u001a#\u0010\u0013\u001a\u00020\u0005*\u00020\u00052\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\b\u0017\u00a8\u0006\u0018"}, d2={"hexToRgb", "Lkotlin/Triple;", "", "hexValue", "ansi", "", "text", "styles", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "color", "rgb", "bgColor", "bold", "italic", "underline", "concatFormatted", "parts", "([Ljava/lang/String;)Ljava/lang/String;", "styled", "setup", "Lkotlin/Function1;", "Lcom/embabel/common/util/AnsiBuilder;", "Lkotlin/ExtensionFunctionType;", "embabel-common-util"})
public final class AnsiBuilderKt {
    @NotNull
    public static final Triple<Integer, Integer, Integer> hexToRgb(int hexValue) {
        int r = hexValue >> 16 & 0xFF;
        int g = hexValue >> 8 & 0xFF;
        int b = hexValue & 0xFF;
        return new Triple((Object)r, (Object)g, (Object)b);
    }

    @NotNull
    public static final String ansi(@NotNull String text, String ... styles) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)styles, (String)"styles");
        String start = "\u001b[" + ArraysKt.joinToString$default((Object[])styles, (CharSequence)";", null, null, (int)0, null, null, (int)62, null) + "m";
        String reset = "\u001b[0m";
        return start + text + reset;
    }

    @NotNull
    public static final String color(@NotNull String $this$color, @NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)$this$color, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        String[] stringArray = new String[]{color};
        return AnsiBuilderKt.ansi($this$color, stringArray);
    }

    @NotNull
    public static final String color(@NotNull String $this$color, @NotNull Triple<Integer, Integer, Integer> rgb) {
        Intrinsics.checkNotNullParameter((Object)$this$color, (String)"<this>");
        Intrinsics.checkNotNullParameter(rgb, (String)"rgb");
        int r = ((Number)rgb.component1()).intValue();
        int g = ((Number)rgb.component2()).intValue();
        int b = ((Number)rgb.component3()).intValue();
        return "\u001b[38;2;" + r + ";" + g + ";" + b + "m" + $this$color + "\u001b[0m";
    }

    @NotNull
    public static final String color(@NotNull String $this$color, int rgb) {
        Intrinsics.checkNotNullParameter((Object)$this$color, (String)"<this>");
        return AnsiBuilderKt.color($this$color, AnsiBuilderKt.hexToRgb(rgb));
    }

    @NotNull
    public static final String bgColor(@NotNull String $this$bgColor, @NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)$this$bgColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        String[] stringArray = new String[]{color};
        return AnsiBuilderKt.ansi($this$bgColor, stringArray);
    }

    @NotNull
    public static final String bold(@NotNull String $this$bold) {
        Intrinsics.checkNotNullParameter((Object)$this$bold, (String)"<this>");
        String[] stringArray = new String[]{"1"};
        return AnsiBuilderKt.ansi($this$bold, stringArray);
    }

    @NotNull
    public static final String italic(@NotNull String $this$italic) {
        Intrinsics.checkNotNullParameter((Object)$this$italic, (String)"<this>");
        String[] stringArray = new String[]{"3"};
        return AnsiBuilderKt.ansi($this$italic, stringArray);
    }

    @NotNull
    public static final String underline(@NotNull String $this$underline) {
        Intrinsics.checkNotNullParameter((Object)$this$underline, (String)"<this>");
        String[] stringArray = new String[]{"4"};
        return AnsiBuilderKt.ansi($this$underline, stringArray);
    }

    @NotNull
    public static final String concatFormatted(String ... parts) {
        Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
        return ArraysKt.joinToString$default((Object[])parts, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String styled(@NotNull String $this$styled, @NotNull Function1<? super AnsiBuilder, AnsiBuilder> setup) {
        Intrinsics.checkNotNullParameter((Object)$this$styled, (String)"<this>");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        return ((AnsiBuilder)setup.invoke((Object)new AnsiBuilder())).format($this$styled);
    }
}

