/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.starter.shell.spi;

import com.embabel.agent.starter.shell.AgentShellStarterProperties;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.BindException;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class ShellEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(ShellEnvironmentPostProcessor.class);
    private static final String SHELL_PROPERTIES_SOURCE_NAME = "shellModeProperties";
    private static final String SHELL_CONFIG_PREFIX = "embabel.agent.shell";
    private static final String WEB_APPLICATION_TYPE_PROPERTY = "spring.main.web-application-type";
    private static final String SHELL_EXIT_ENABLED_PROPERTY = "spring.shell.command.exit.enabled";
    private static final String SHELL_QUIT_ENABLED_PROPERTY = "spring.shell.command.quit.enabled";
    private static final String SHELL_INTERACTIVE_ENABLED_PROPERTY = "spring.shell.interactive.enabled";
    private static final String SHELL_HISTORY_ENABLED_PROPERTY = "spring.shell.history.enabled";

    public int getOrder() {
        return -2147483638;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        logger.debug("Shell mode detected - applying shell environment configuration");
        ShellConfiguration shellConfig = this.resolveShellConfiguration(environment);
        this.applyShellConfiguration(environment, shellConfig);
        logger.debug("Shell environment configuration applied successfully");
    }

    private ShellConfiguration resolveShellConfiguration(ConfigurableEnvironment environment) {
        try {
            AgentShellStarterProperties properties = (AgentShellStarterProperties)Binder.get((Environment)environment).bind(SHELL_CONFIG_PREFIX, AgentShellStarterProperties.class).orElseGet(AgentShellStarterProperties::new);
            return new ShellConfiguration(properties);
        }
        catch (BindException e) {
            logger.warn("Failed to bind shell properties from '{}', using defaults: {}", (Object)SHELL_CONFIG_PREFIX, (Object)e.getMessage());
            return new ShellConfiguration(new AgentShellStarterProperties());
        }
        catch (Exception e) {
            logger.error("Unexpected error while resolving shell configuration, using defaults", (Throwable)e);
            return new ShellConfiguration(new AgentShellStarterProperties());
        }
    }

    private void applyShellConfiguration(ConfigurableEnvironment environment, ShellConfiguration shellConfig) {
        Map<String, Object> shellProperties = this.buildShellProperties(shellConfig);
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource(SHELL_PROPERTIES_SOURCE_NAME, shellProperties));
        logger.debug("Added shell properties with {} entries", (Object)shellProperties.size());
    }

    private Map<String, Object> buildShellProperties(ShellConfiguration shellConfig) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(WEB_APPLICATION_TYPE_PROPERTY, shellConfig.getWebApplicationType());
        properties.put(SHELL_EXIT_ENABLED_PROPERTY, shellConfig.isExitCommandEnabled());
        properties.put(SHELL_QUIT_ENABLED_PROPERTY, shellConfig.isQuitCommandEnabled());
        properties.put(SHELL_INTERACTIVE_ENABLED_PROPERTY, shellConfig.isInteractiveMode());
        properties.put(SHELL_HISTORY_ENABLED_PROPERTY, shellConfig.isHistoryEnabled());
        return properties;
    }

    private static class ShellConfiguration {
        private final AgentShellStarterProperties properties;

        public ShellConfiguration(AgentShellStarterProperties properties) {
            this.properties = properties;
        }

        public String getWebApplicationType() {
            return this.properties.getWebApplicationType();
        }

        public boolean isExitCommandEnabled() {
            return this.properties.getCommand().isExitEnabled();
        }

        public boolean isQuitCommandEnabled() {
            return this.properties.getCommand().isQuitEnabled();
        }

        public boolean isInteractiveMode() {
            return this.properties.getInteractive().isEnabled();
        }

        public boolean isHistoryEnabled() {
            return this.properties.getInteractive().isHistoryEnabled();
        }
    }
}

