/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.observability.mdc;

import com.embabel.agent.api.event.ActionExecutionResultEvent;
import com.embabel.agent.api.event.ActionExecutionStartEvent;
import com.embabel.agent.api.event.AgentProcessCompletedEvent;
import com.embabel.agent.api.event.AgentProcessCreationEvent;
import com.embabel.agent.api.event.AgentProcessEvent;
import com.embabel.agent.api.event.AgentProcessFailedEvent;
import com.embabel.agent.api.event.AgenticEventListener;
import com.embabel.agent.api.event.ProcessKilledEvent;
import com.embabel.agent.observability.ObservabilityProperties;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.slf4j.MDC;

public class MdcPropagationEventListener
implements AgenticEventListener {
    static final String MDC_RUN_ID = "embabel.agent.run_id";
    static final String MDC_AGENT_NAME = "embabel.agent.name";
    static final String MDC_ACTION_NAME = "embabel.action.name";
    private final ObservabilityProperties properties;

    public MdcPropagationEventListener(ObservabilityProperties properties) {
        this.properties = properties;
    }

    public void onProcessEvent(AgentProcessEvent event) {
        if (!this.properties.isMdcPropagation()) {
            return;
        }
        AgentProcessEvent agentProcessEvent = event;
        Objects.requireNonNull(agentProcessEvent);
        AgentProcessEvent agentProcessEvent2 = agentProcessEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AgentProcessCreationEvent.class, ActionExecutionStartEvent.class, ActionExecutionResultEvent.class, AgentProcessCompletedEvent.class, AgentProcessFailedEvent.class, ProcessKilledEvent.class}, (Object)agentProcessEvent2, n)) {
            case 0: {
                AgentProcessCreationEvent e = (AgentProcessCreationEvent)agentProcessEvent2;
                MDC.put((String)MDC_RUN_ID, (String)e.getAgentProcess().getId());
                MDC.put((String)MDC_AGENT_NAME, (String)e.getAgentProcess().getAgent().getName());
                break;
            }
            case 1: {
                ActionExecutionStartEvent e = (ActionExecutionStartEvent)agentProcessEvent2;
                MDC.put((String)MDC_ACTION_NAME, (String)e.getAction().getName());
                break;
            }
            case 2: {
                ActionExecutionResultEvent e = (ActionExecutionResultEvent)agentProcessEvent2;
                MDC.remove((String)MDC_ACTION_NAME);
                break;
            }
            case 3: {
                AgentProcessCompletedEvent e = (AgentProcessCompletedEvent)agentProcessEvent2;
                this.clearAll();
                break;
            }
            case 4: {
                AgentProcessFailedEvent e = (AgentProcessFailedEvent)agentProcessEvent2;
                this.clearAll();
                break;
            }
            case 5: {
                ProcessKilledEvent e = (ProcessKilledEvent)agentProcessEvent2;
                this.clearAll();
                break;
            }
        }
    }

    private void clearAll() {
        MDC.remove((String)MDC_RUN_ID);
        MDC.remove((String)MDC_AGENT_NAME);
        MDC.remove((String)MDC_ACTION_NAME);
    }
}

