/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.mcpserver.sync.config;

import com.embabel.agent.api.common.ToolObject;
import com.embabel.agent.core.support.SpringAiUtilsKt;
import com.embabel.agent.mcpserver.AbstractMcpServerConfiguration;
import com.embabel.agent.mcpserver.McpExportToolCallbackPublisher;
import com.embabel.agent.mcpserver.McpServerStrategy;
import com.embabel.agent.mcpserver.ServerInfoFactory;
import com.embabel.agent.mcpserver.UnifiedBannerTool;
import com.embabel.agent.mcpserver.domain.McpExecutionMode;
import com.embabel.agent.mcpserver.domain.ServerInfo;
import com.embabel.agent.mcpserver.sync.McpPromptPublisher;
import com.embabel.agent.mcpserver.sync.McpResourcePublisher;
import com.embabel.agent.mcpserver.sync.SyncServerStrategy;
import com.embabel.agent.mcpserver.sync.config.McpSyncServerCondition;
import io.modelcontextprotocol.server.McpSyncServer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.McpToolUtils;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;

@Configuration
@Conditional(value={McpSyncServerCondition.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012H\u0016J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/embabel/agent/mcpserver/sync/config/McpSyncServerConfiguration;", "Lcom/embabel/agent/mcpserver/AbstractMcpServerConfiguration;", "applicationContext", "Lorg/springframework/context/ConfigurableApplicationContext;", "<init>", "(Lorg/springframework/context/ConfigurableApplicationContext;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "serverInfo", "Lcom/embabel/agent/mcpserver/domain/ServerInfo;", "syncBannerCallback", "Lorg/springframework/ai/tool/ToolCallbackProvider;", "createServerStrategy", "Lcom/embabel/agent/mcpserver/McpServerStrategy;", "createBannerTool", "getToolPublishers", "", "Lcom/embabel/agent/mcpserver/McpExportToolCallbackPublisher;", "getResourcePublishers", "Lcom/embabel/agent/mcpserver/sync/McpResourcePublisher;", "getPromptPublishers", "Lcom/embabel/agent/mcpserver/sync/McpPromptPublisher;", "convertToToolSpecifications", "", "toolCallbacks", "getExecutionMode", "", "embabel-agent-mcpserver"})
@SourceDebugExtension(value={"SMAP\nMcpSyncServerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpSyncServerConfiguration.kt\ncom/embabel/agent/mcpserver/sync/config/McpSyncServerConfiguration\n+ 2 BeanFactoryExtensions.kt\norg/springframework/beans/factory/BeanFactoryExtensionsKt\n+ 3 ListableBeanFactoryExtensions.kt\norg/springframework/beans/factory/ListableBeanFactoryExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n30#2:161\n64#2:162\n36#3,3:163\n36#3,3:166\n36#3,3:169\n808#4,11:172\n*S KotlinDebug\n*F\n+ 1 McpSyncServerConfiguration.kt\ncom/embabel/agent/mcpserver/sync/config/McpSyncServerConfiguration\n*L\n97#1:161\n97#1:162\n120#1:163,3\n129#1:166,3\n138#1:169,3\n149#1:172,11\n*E\n"})
public class McpSyncServerConfiguration
extends AbstractMcpServerConfiguration {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ServerInfo serverInfo;

    public McpSyncServerConfiguration(@NotNull ConfigurableApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        super(applicationContext);
        Logger logger = LoggerFactory.getLogger(McpSyncServerConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.serverInfo = ServerInfoFactory.INSTANCE.create(McpExecutionMode.SYNC);
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return this.logger;
    }

    @Bean
    @NotNull
    public ToolCallbackProvider syncBannerCallback() {
        return this.createBannerTool();
    }

    @Override
    @NotNull
    public McpServerStrategy createServerStrategy() {
        BeanFactory $this$getBean$iv = (BeanFactory)this.getApplicationContext();
        boolean $i$f$getBean = false;
        BeanFactory $this$getBeanProvider$iv$iv = $this$getBean$iv;
        boolean $i$f$getBeanProvider = false;
        ObjectProvider objectProvider = $this$getBeanProvider$iv$iv.getBeanProvider(ResolvableType.forType((Type)new ParameterizedTypeReference<McpSyncServer>(){}.getType()));
        Intrinsics.checkNotNullExpressionValue((Object)objectProvider, (String)"getBeanProvider(Resolvab\u2026Reference<T>() {}).type))");
        Object object = objectProvider.getObject();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBeanProvider<T>().getObject()");
        McpSyncServer syncServer = (McpSyncServer)object;
        return new SyncServerStrategy(syncServer);
    }

    @Override
    @NotNull
    public ToolCallbackProvider createBannerTool() {
        ToolCallbackProvider toolCallbackProvider = ToolCallbackProvider.from((List)SpringAiUtilsKt.safelyGetToolCallbacksFrom((ToolObject)ToolObject.Companion.from((Object)new UnifiedBannerTool(this.serverInfo))));
        Intrinsics.checkNotNullExpressionValue((Object)toolCallbackProvider, (String)"from(...)");
        return toolCallbackProvider;
    }

    @Override
    @NotNull
    public List<McpExportToolCallbackPublisher> getToolPublishers() {
        ListableBeanFactory $this$getBeansOfType_u24default$iv = (ListableBeanFactory)this.getApplicationContext();
        boolean includeNonSingletons$iv = true;
        boolean allowEagerInit$iv = true;
        boolean $i$f$getBeansOfType = false;
        Map map = $this$getBeansOfType_u24default$iv.getBeansOfType(McpExportToolCallbackPublisher.class, includeNonSingletons$iv, allowEagerInit$iv);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getBeansOfType(T::class.\u2026ngletons, allowEagerInit)");
        return CollectionsKt.toList((Iterable)map.values());
    }

    @NotNull
    public List<McpResourcePublisher> getResourcePublishers() {
        ListableBeanFactory $this$getBeansOfType_u24default$iv = (ListableBeanFactory)this.getApplicationContext();
        boolean includeNonSingletons$iv = true;
        boolean allowEagerInit$iv = true;
        boolean $i$f$getBeansOfType = false;
        Map map = $this$getBeansOfType_u24default$iv.getBeansOfType(McpResourcePublisher.class, includeNonSingletons$iv, allowEagerInit$iv);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getBeansOfType(T::class.\u2026ngletons, allowEagerInit)");
        return CollectionsKt.toList((Iterable)map.values());
    }

    @NotNull
    public List<McpPromptPublisher> getPromptPublishers() {
        ListableBeanFactory $this$getBeansOfType_u24default$iv = (ListableBeanFactory)this.getApplicationContext();
        boolean includeNonSingletons$iv = true;
        boolean allowEagerInit$iv = true;
        boolean $i$f$getBeansOfType = false;
        Map map = $this$getBeansOfType_u24default$iv.getBeansOfType(McpPromptPublisher.class, includeNonSingletons$iv, allowEagerInit$iv);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getBeansOfType(T::class.\u2026ngletons, allowEagerInit)");
        return CollectionsKt.toList((Iterable)map.values());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Object> convertToToolSpecifications(@NotNull List<? extends Object> toolCallbacks) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(toolCallbacks, (String)"toolCallbacks");
        Iterable $this$filterIsInstance$iv = toolCallbacks;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ToolCallback)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List callbacks = (List)destination$iv$iv;
        List list = McpToolUtils.toSyncToolSpecification((List)callbacks);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toSyncToolSpecification(...)");
        return list;
    }

    @Override
    @NotNull
    protected String getExecutionMode() {
        return "SYNC";
    }
}

