/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.mcpserver.sync;

import com.embabel.agent.mcpserver.McpServerStrategy;
import com.embabel.agent.mcpserver.ToolRegistry;
import com.embabel.agent.mcpserver.domain.McpExecutionMode;
import com.embabel.agent.mcpserver.sync.SyncToolRegistry;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/embabel/agent/mcpserver/sync/SyncServerStrategy;", "Lcom/embabel/agent/mcpserver/McpServerStrategy;", "server", "Lio/modelcontextprotocol/server/McpSyncServer;", "<init>", "(Lio/modelcontextprotocol/server/McpSyncServer;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "executionMode", "Lcom/embabel/agent/mcpserver/domain/McpExecutionMode;", "getExecutionMode", "()Lcom/embabel/agent/mcpserver/domain/McpExecutionMode;", "addTool", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "toolSpec", "", "removeTool", "toolName", "", "addResource", "resourceSpec", "addPrompt", "promptSpec", "getToolRegistry", "Lcom/embabel/agent/mcpserver/ToolRegistry;", "embabel-agent-mcpserver"})
public final class SyncServerStrategy
implements McpServerStrategy {
    @NotNull
    private final McpSyncServer server;
    private final Logger logger;
    @NotNull
    private final McpExecutionMode executionMode;

    public SyncServerStrategy(@NotNull McpSyncServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.server = server;
        this.logger = LoggerFactory.getLogger(SyncServerStrategy.class);
        this.executionMode = McpExecutionMode.SYNC;
    }

    @Override
    @NotNull
    public McpExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    @Override
    @NotNull
    public Mono<Void> addTool(@NotNull Object toolSpec) {
        Intrinsics.checkNotNullParameter((Object)toolSpec, (String)"toolSpec");
        Mono mono = Mono.fromRunnable(() -> SyncServerStrategy.addTool$lambda$0(toolSpec, this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"fromRunnable(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Void> removeTool(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Mono mono = Mono.fromRunnable(() -> SyncServerStrategy.removeTool$lambda$1(this, toolName));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"fromRunnable(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Void> addResource(@NotNull Object resourceSpec) {
        Intrinsics.checkNotNullParameter((Object)resourceSpec, (String)"resourceSpec");
        Mono mono = Mono.fromRunnable(() -> SyncServerStrategy.addResource$lambda$2(resourceSpec, this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"fromRunnable(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Void> addPrompt(@NotNull Object promptSpec) {
        Intrinsics.checkNotNullParameter((Object)promptSpec, (String)"promptSpec");
        Mono mono = Mono.fromRunnable(() -> SyncServerStrategy.addPrompt$lambda$3(promptSpec, this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"fromRunnable(...)");
        return mono;
    }

    @Override
    @NotNull
    public ToolRegistry getToolRegistry() {
        return new SyncToolRegistry(this.server);
    }

    private static final void addTool$lambda$0(Object $toolSpec, SyncServerStrategy this$0) {
        if (!($toolSpec instanceof McpServerFeatures.SyncToolSpecification)) {
            throw new IllegalArgumentException("Expected SyncToolSpecification");
        }
        this$0.server.addTool((McpServerFeatures.SyncToolSpecification)$toolSpec);
    }

    private static final void removeTool$lambda$1(SyncServerStrategy this$0, String $toolName) {
        this$0.server.removeTool($toolName);
    }

    private static final void addResource$lambda$2(Object $resourceSpec, SyncServerStrategy this$0) {
        if (!($resourceSpec instanceof McpServerFeatures.SyncResourceSpecification)) {
            throw new IllegalArgumentException("Expected SyncResourceSpecification");
        }
        this$0.server.addResource((McpServerFeatures.SyncResourceSpecification)$resourceSpec);
    }

    private static final void addPrompt$lambda$3(Object $promptSpec, SyncServerStrategy this$0) {
        if (!($promptSpec instanceof McpServerFeatures.SyncPromptSpecification)) {
            throw new IllegalArgumentException("Expected SyncPromptSpecification");
        }
        this$0.server.addPrompt((McpServerFeatures.SyncPromptSpecification)$promptSpec);
    }
}

