/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.common.ai.converters.streaming.support;

import com.embabel.common.core.streaming.ThinkingState;
import com.embabel.common.core.thinking.ThinkingTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\nJ\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/embabel/common/ai/converters/streaming/support/ThinkingDetector;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "thinkingTags", "", "", "Lkotlin/Pair;", "isThinkingLine", "", "line", "extractThinkingContent", "detectThinkingState", "Lcom/embabel/common/core/streaming/ThinkingState;", "isValidJson", "startTags", "", "endTags", "thinkingPatterns", "Lkotlin/text/Regex;", "embabel-agent-common"})
@SourceDebugExtension(value={"SMAP\nThinkingDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinkingDetector.kt\ncom/embabel/common/ai/converters/streaming/support/ThinkingDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,221:1\n1755#2,3:222\n1755#2,3:225\n1755#2,3:228\n1755#2,3:231\n1755#2,3:234\n1755#2,3:237\n1755#2,3:240\n1557#2:250\n1628#2,3:251\n1557#2:254\n1628#2,3:255\n1863#2,2:258\n560#3:243\n545#3,6:244\n*S KotlinDebug\n*F\n+ 1 ThinkingDetector.kt\ncom/embabel/common/ai/converters/streaming/support/ThinkingDetector\n*L\n50#1:222,3\n113#1:225,3\n114#1:228,3\n135#1:231,3\n140#1:234,3\n145#1:237,3\n150#1:240,3\n199#1:250\n199#1:251,3\n204#1:254\n204#1:255,3\n212#1:258,2\n37#1:243\n37#1:244,6\n*E\n"})
public final class ThinkingDetector {
    @NotNull
    public static final ThinkingDetector INSTANCE;
    private static final Logger logger;
    @NotNull
    private static final Map<String, Pair<String, String>> thinkingTags;
    @NotNull
    private static final List<String> startTags;
    @NotNull
    private static final List<String> endTags;
    @NotNull
    private static final List<Regex> thinkingPatterns;

    private ThinkingDetector() {
    }

    public final boolean isThinkingLine(@NotNull String line) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Iterable $this$any$iv = thinkingPatterns;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex pattern = (Regex)element$iv;
                    boolean bl2 = false;
                    if (!pattern.containsMatchIn((CharSequence)line)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final String extractThinkingContent(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        for (Regex pattern : thinkingPatterns) {
            MatchResult match = Regex.find$default((Regex)pattern, (CharSequence)line, (int)0, (int)2, null);
            if (match == null) continue;
            if (match.getGroupValues().size() > 1) {
                return ((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(1)))).toString();
            }
            if (!StringsKt.startsWith$default((String)line, (String)"//THINKING:", (boolean)false, (int)2, null)) continue;
            return ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)line, (CharSequence)"//THINKING:"))).toString();
        }
        return ((Object)StringsKt.trim((CharSequence)line)).toString();
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final ThinkingState detectThinkingState(@NotNull String line) {
        block38: {
            block40: {
                block36: {
                    block39: {
                        block34: {
                            block33: {
                                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                                trimmed = StringsKt.trim((CharSequence)line).toString();
                                ThinkingDetector.logger.debug("Detecting thinking state for line: '{}'", (Object)StringsKt.take((String)trimmed, (int)50));
                                if (this.isThinkingLine(line)) {
                                    block32: {
                                        block31: {
                                            ThinkingDetector.logger.debug("Line matches complete thinking pattern");
                                            $this$any$iv = ThinkingDetector.startTags;
                                            $i$f$any = false;
                                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                                v0 = false;
                                            } else {
                                                for (Object element$iv : $this$any$iv) {
                                                    it = (String)element$iv;
                                                    $i$a$-any-ThinkingDetector$detectThinkingState$hasStartTag$1 = false;
                                                    if (!StringsKt.contains$default((CharSequence)line, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                                                    v0 = true;
                                                    break block31;
                                                }
                                                v0 = false;
                                            }
                                        }
                                        hasStartTag = v0;
                                        $this$any$iv = ThinkingDetector.endTags;
                                        $i$f$any = false;
                                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                            v1 = false;
                                        } else {
                                            for (E element$iv : $this$any$iv) {
                                                it = (String)element$iv;
                                                $i$a$-any-ThinkingDetector$detectThinkingState$hasEndTag$1 = false;
                                                if (!StringsKt.contains$default((CharSequence)line, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                                                v1 = true;
                                                break block32;
                                            }
                                            v1 = false;
                                        }
                                    }
                                    hasEndTag = v1;
                                    state = hasStartTag != false && hasEndTag != false ? ThinkingState.BOTH : (hasStartTag != false ? ThinkingState.START : (hasEndTag != false ? ThinkingState.END : (StringsKt.startsWith$default((String)line, (String)"//THINKING:", (boolean)false, (int)2, null) != false ? ThinkingState.BOTH : ThinkingState.CONTINUATION)));
                                    $i$f$any = new Object[]{hasStartTag, hasEndTag, state};
                                    ThinkingDetector.logger.debug("Complete pattern classification: hasStart={}, hasEnd={}, state={}", $i$f$any);
                                    return state;
                                }
                                $this$any$iv = ThinkingDetector.startTags;
                                $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    v2 = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        it = (String)element$iv;
                                        $i$a$-any-ThinkingDetector$detectThinkingState$1 = false;
                                        if (!Intrinsics.areEqual((Object)trimmed, (Object)it)) continue;
                                        v2 = true;
                                        break block33;
                                    }
                                    v2 = false;
                                }
                            }
                            if (v2) {
                                ThinkingDetector.logger.debug("Line is standalone start tag");
                                return ThinkingState.START;
                            }
                            $this$any$iv = ThinkingDetector.endTags;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v3 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    it = (String)element$iv;
                                    $i$a$-any-ThinkingDetector$detectThinkingState$2 = false;
                                    if (!Intrinsics.areEqual((Object)trimmed, (Object)it)) continue;
                                    v3 = true;
                                    break block34;
                                }
                                v3 = false;
                            }
                        }
                        if (v3) {
                            ThinkingDetector.logger.debug("Line is standalone end tag");
                            return ThinkingState.END;
                        }
                        $this$any$iv = ThinkingDetector.startTags;
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block39;
                        v4 = false;
                        break block36;
                    }
                    for (T element$iv : $this$any$iv) {
                        block35: {
                            it = (String)element$iv;
                            $i$a$-any-ThinkingDetector$detectThinkingState$3 = false;
                            if (!StringsKt.startsWith$default((String)trimmed, (String)it, (boolean)false, (int)2, null)) ** GOTO lbl-1000
                            $this$any$iv = ThinkingDetector.endTags;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v5 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    end = (String)element$iv;
                                    $i$a$-any-ThinkingDetector$detectThinkingState$3$1 = false;
                                    if (!StringsKt.contains$default((CharSequence)trimmed, (CharSequence)end, (boolean)false, (int)2, null)) continue;
                                    v5 = true;
                                    break block35;
                                }
                                v5 = false;
                            }
                        }
                        if (!v5) {
                            v6 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v6 = false;
                        }
                        if (!v6) continue;
                        v4 = true;
                        break block36;
                    }
                    v4 = false;
                }
                if (v4) {
                    ThinkingDetector.logger.debug("Line starts with opening tag but no closing tag");
                    return ThinkingState.START;
                }
                $this$any$iv = ThinkingDetector.endTags;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block40;
                v7 = false;
                break block38;
            }
            for (T element$iv : $this$any$iv) {
                block37: {
                    it = (String)element$iv;
                    $i$a$-any-ThinkingDetector$detectThinkingState$4 = false;
                    if (!StringsKt.endsWith$default((String)trimmed, (String)it, (boolean)false, (int)2, null)) ** GOTO lbl-1000
                    $this$any$iv = ThinkingDetector.startTags;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v8 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            start = (String)element$iv;
                            $i$a$-any-ThinkingDetector$detectThinkingState$4$1 = false;
                            if (!StringsKt.contains$default((CharSequence)trimmed, (CharSequence)start, (boolean)false, (int)2, null)) continue;
                            v8 = true;
                            break block37;
                        }
                        v8 = false;
                    }
                }
                if (!v8) {
                    v9 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v9 = false;
                }
                if (!v9) continue;
                v7 = true;
                break block38;
            }
            v7 = false;
        }
        if (v7) {
            ThinkingDetector.logger.debug("Line ends with closing tag but no opening tag");
            return ThinkingState.END;
        }
        isJson = this.isValidJson(line);
        if (isJson) {
            ThinkingDetector.logger.debug("Line classified as JSON content");
            v10 = ThinkingState.NONE;
        } else {
            ThinkingDetector.logger.debug("Line classified as thinking continuation");
            v10 = ThinkingState.CONTINUATION;
        }
        return v10;
    }

    private final boolean isValidJson(String line) {
        String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
        boolean isValid = ((CharSequence)trimmed).length() > 0 && StringsKt.startsWith$default((String)trimmed, (String)"{", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)trimmed, (String)"}", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)trimmed, (CharSequence)":", (boolean)false, (int)2, null);
        logger.debug("JSON validation for '{}': {}", (Object)StringsKt.take((String)trimmed, (int)50), (Object)isValid);
        return isValid;
    }

    static {
        List list;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Pair it;
        Iterable $this$filterNotTo$iv$iv;
        INSTANCE = new ThinkingDetector();
        logger = LoggerFactory.getLogger(ThinkingDetector.class);
        Map $this$filterNot$iv = ThinkingTags.INSTANCE.getTAG_DEFINITIONS();
        boolean $i$f$filterNot = false;
        Map map = $this$filterNot$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            Object[] objectArray = new String[]{"legacy_prefix", "no_prefix"};
            if (CollectionsKt.listOf((Object[])objectArray).contains(it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        thinkingTags = destination$iv$iv;
        Iterable $this$map$iv = thinkingTags.values();
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add((String)it.getFirst());
        }
        startTags = (List)destination$iv$iv;
        $this$map$iv = thinkingTags.values();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add((String)it.getSecond());
        }
        endTags = (List)destination$iv$iv;
        List $this$thinkingPatterns_u24lambda_u2413 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = thinkingTags.values();
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv) {
            Pair tagPair = (Pair)element$iv;
            boolean bl2 = false;
            String escapedStart = Regex.Companion.escape((String)tagPair.getFirst());
            String escapedEnd = Regex.Companion.escape((String)tagPair.getSecond());
            $this$thinkingPatterns_u24lambda_u2413.add(new Regex(escapedStart + "(.*?)" + escapedEnd, RegexOption.DOT_MATCHES_ALL));
        }
        $this$thinkingPatterns_u24lambda_u2413.add(new Regex("^//THINKING:.*", RegexOption.MULTILINE));
        thinkingPatterns = CollectionsKt.build((List)list);
    }
}

