/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.coding.tools.api;

import com.embabel.agent.api.annotation.LlmTool;
import com.embabel.agent.api.reference.LlmReference;
import com.embabel.agent.api.tool.Tool;
import com.embabel.coding.tools.api.Api;
import com.embabel.coding.tools.api.ApiClass;
import com.embabel.coding.tools.api.ApiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0006\u0010\u0012\u001a\u00020\u0003J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0007J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0007J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0007J\u000e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/embabel/coding/tools/api/ApiReference;", "Lcom/embabel/agent/api/reference/LlmReference;", "description", "", "api", "Lcom/embabel/coding/tools/api/Api;", "classLimit", "", "<init>", "(Ljava/lang/String;Lcom/embabel/coding/tools/api/Api;I)V", "getDescription", "()Ljava/lang/String;", "name", "getName", "tools", "", "Lcom/embabel/agent/api/tool/Tool;", "notes", "formatAsText", "findClassSignatureByFqn", "fqn", "findClassSignatureBySimpleName", "simpleName", "findPackageSignature", "packageName", "formatClass", "clazz", "Lcom/embabel/coding/tools/api/ApiClass;", "embabel-agent-code"})
@SourceDebugExtension(value={"SMAP\nApiReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiReference.kt\ncom/embabel/coding/tools/api/ApiReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1053#2:154\n774#2:155\n865#2,2:156\n774#2:158\n865#2,2:159\n1863#2,2:161\n774#2:163\n865#2,2:164\n1053#2:166\n1863#2,2:167\n*S KotlinDebug\n*F\n+ 1 ApiReference.kt\ncom/embabel/coding/tools/api/ApiReference\n*L\n57#1:154\n67#1:155\n67#1:156,2\n82#1:158\n82#1:159,2\n90#1:161,2\n100#1:163\n100#1:164,2\n108#1:166\n138#1:167,2\n*E\n"})
public final class ApiReference
implements LlmReference {
    @NotNull
    private final String description;
    @NotNull
    private final Api api;
    private final int classLimit;
    @NotNull
    private final String name;

    public ApiReference(@NotNull String description, @NotNull Api api, int classLimit) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.description = description;
        this.api = api;
        this.classLimit = classLimit;
        this.name = this.api.getName();
    }

    public /* synthetic */ ApiReference(String string, Api api, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 100;
        }
        this(string, api, n);
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<Tool> tools() {
        return Tool.Companion.fromInstance((Object)this);
    }

    @NotNull
    public String notes() {
        if (this.api.getClasses().size() > this.classLimit) {
            return StringsKt.trimIndent((String)("\n                API reference is too large to include here (contains " + this.api.getTotalClasses() + " classes and " + this.api.getTotalMethods() + " methods).\n                Use tools to look up specific classes or packages by their fully qualified names (FQN).\n            "));
        }
        return StringsKt.trimIndent((String)("\n            API reference for " + this.api.getTotalClasses() + " classes and " + this.api.getTotalMethods() + " methods.\n            Use this reference to answer questions about the API, find class or package signatures, and understand how to use the classes and methods.\n            You can also use tools to look up specific classes or packages by their fully qualified names (FQN).\n\n            " + this.formatAsText() + "\n        "));
    }

    @NotNull
    public final String formatAsText() {
        StringBuilder sb = new StringBuilder();
        sb.append("API Reference - " + this.api.getTotalClasses() + " classes, " + this.api.getTotalMethods() + " methods").append('\n');
        sb.append('\n');
        Iterable $this$sortedBy$iv = this.api.getClasses();
        boolean $i$f$sortedBy = false;
        for (ApiClass clazz : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ApiClass it = (ApiClass)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)(it.getPackageName() + "." + it.getName()));
                it = (ApiClass)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)(it.getPackageName() + "." + it.getName()))));
            }
        })) {
            sb.append('\n');
            sb.append(this.formatClass(clazz));
            sb.append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @LlmTool(description="find the signature of a class by FQN")
    @NotNull
    public final String findClassSignatureByFqn(@NotNull String fqn) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        Iterable $this$filter$iv = this.api.getClasses();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ApiClass it = (ApiClass)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.equals((String)it.fqn(), (String)fqn, (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List classes = (List)destination$iv$iv;
        return classes.isEmpty() ? "Class not found: " + fqn : (classes.size() > 1 ? StringsKt.trimIndent((String)("\n                Multiple classes found with FQN '" + fqn + "'!!\n                " + CollectionsKt.joinToString$default((Iterable)classes, null, null, null, (int)0, null, arg_0 -> ApiReference.findClassSignatureByFqn$lambda$2(this, arg_0), (int)31, null) + "\n            ")) : this.formatClass((ApiClass)CollectionsKt.first((List)classes)));
    }

    /*
     * WARNING - void declaration
     */
    @LlmTool(description="find the signature of a class by simple name")
    @NotNull
    public final String findClassSignatureBySimpleName(@NotNull String simpleName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
        Iterable $this$filter$iv = this.api.getClasses();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ApiClass it = (ApiClass)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.equals((String)it.getName(), (String)simpleName, (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List matchingClasses = (List)destination$iv$iv;
        return switch (matchingClasses.size()) {
            case 0 -> "Class not found: " + simpleName;
            case 1 -> this.formatClass((ApiClass)CollectionsKt.first((List)matchingClasses));
            default -> {
                StringBuilder sb = new StringBuilder();
                sb.append("Multiple classes found with name '" + simpleName + "':").append('\n');
                Iterable $this$forEach$iv = matchingClasses;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ApiClass clazz = (ApiClass)element$iv;
                    boolean $i$a$-forEach-ApiReference$findClassSignatureBySimpleName$1 = false;
                    sb.append(clazz.getPackageName() + "." + clazz.getName()).append('\n');
                }
                String v1 = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toString(...)");
                yield ((Object)StringsKt.trimEnd((CharSequence)v1)).toString();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @LlmTool(description="find the signature of a package by FQN")
    @NotNull
    public final String findPackageSignature(@NotNull String packageName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Iterable $this$filter$iv = this.api.getClasses();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ApiClass it = (ApiClass)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getPackageName(), (Object)packageName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List classesInPackage = (List)destination$iv$iv;
        if (classesInPackage.isEmpty()) {
            return "Package not found: " + packageName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Package: " + packageName).append('\n');
        sb.append("Classes:").append('\n');
        Iterable $this$sortedBy$iv = classesInPackage;
        boolean $i$f$sortedBy = false;
        for (ApiClass clazz : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ApiClass it = (ApiClass)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (ApiClass)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        })) {
            sb.append("  - " + clazz.getName() + " (" + clazz.getType() + ")").append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String formatClass(@NotNull ApiClass clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        StringBuilder sb = new StringBuilder();
        sb.append(clazz.getPackageName() + "." + clazz.getName());
        if (!Intrinsics.areEqual((Object)clazz.getType(), (Object)"class")) {
            sb.append(" (" + clazz.getType() + ")");
        }
        sb.append('\n');
        String string = clazz.getComment();
        if (string != null) {
            String comment = string;
            boolean bl = false;
            sb.append("  // " + comment).append('\n');
        }
        if (!((Collection)clazz.getSuperTypes()).isEmpty()) {
            sb.append("  extends/implements: " + CollectionsKt.joinToString$default((Iterable)clazz.getSuperTypes(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).append('\n');
        }
        Iterable $this$forEach$iv = clazz.getMethods();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String annotations;
            ApiMethod method = (ApiMethod)element$iv;
            boolean bl = false;
            String params = CollectionsKt.joinToString$default((Iterable)method.getParameters(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            String string2 = annotations = !((Collection)method.getAnnotations()).isEmpty() ? " @" + CollectionsKt.joinToString$default((Iterable)method.getAnnotations(), (CharSequence)" @", null, null, (int)0, null, ApiReference::formatClass$lambda$10$lambda$8, (int)30, null) : "";
            if (method.getComment() != null) {
                String comment;
                boolean bl2 = false;
                sb.append("    // " + comment).append('\n');
            }
            sb.append("  " + method.getName() + "(" + params + "): " + method.getReturnType() + annotations).append('\n');
        }
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    private static final CharSequence findClassSignatureByFqn$lambda$2(ApiReference this$0, ApiClass it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.formatClass(it);
    }

    private static final CharSequence formatClass$lambda$10$lambda$8(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.substringAfterLast$default((String)it, (char)'.', null, (int)2, null);
    }
}

