/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.coding.tools.git;

import com.embabel.agent.api.common.LlmReference;
import com.embabel.agent.domain.library.code.SymbolSearch;
import com.embabel.agent.tools.file.DefaultFileReadLog;
import com.embabel.agent.tools.file.FileReadLog;
import com.embabel.agent.tools.file.FileReadTools;
import com.embabel.agent.tools.file.FileReads;
import com.embabel.agent.tools.file.WellKnownFileContentTransformers;
import com.embabel.coding.tools.git.FileFormatLimits;
import com.embabel.common.util.StringTransformer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006B3\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0002J\u0013\u0010*\u001a\u00020\r2\b\u0010+\u001a\u0004\u0018\u00010,H\u0096\u0002J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\bH\u0016J\u0006\u00100\u001a\u00020\bJ\b\u00101\u001a\u00020\bH\u0016J\t\u00102\u001a\u00020(H\u0096\u0001J\u000f\u00103\u001a\b\u0012\u0004\u0012\u00020\b0\u001eH\u0096\u0001J\u000f\u00104\u001a\b\u0012\u0004\u0012\u0002050\u001eH\u0096\u0001J\u0011\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\bH\u0096\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0013R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0013R\u000e\u0010$\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/embabel/coding/tools/git/ClonedRepositoryReference;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Lcom/embabel/agent/tools/file/FileReadTools;", "Lcom/embabel/agent/domain/library/code/SymbolSearch;", "Lcom/embabel/agent/tools/file/FileReadLog;", "Lcom/embabel/agent/api/common/LlmReference;", "url", "", "description", "localPath", "Ljava/nio/file/Path;", "deleteOnClose", "", "fileFormatLimits", "Lcom/embabel/coding/tools/git/FileFormatLimits;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;ZLcom/embabel/coding/tools/git/FileFormatLimits;)V", "getUrl", "()Ljava/lang/String;", "getDescription", "getLocalPath", "()Ljava/nio/file/Path;", "getDeleteOnClose", "()Z", "getFileFormatLimits", "()Lcom/embabel/coding/tools/git/FileFormatLimits;", "name", "getName", "fileContentTransformers", "", "Lcom/embabel/common/util/StringTransformer;", "getFileContentTransformers", "()Ljava/util/List;", "root", "getRoot", "isClosed", "shutdownHook", "Ljava/lang/Thread;", "close", "", "cleanupRepository", "equals", "other", "", "hashCode", "", "toString", "writeAllFilesToString", "notes", "flushReads", "getPathsRead", "getReads", "Lcom/embabel/agent/tools/file/FileReads;", "recordRead", "path", "embabel-agent-code"})
@SourceDebugExtension(value={"SMAP\nClonedRepositoryReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClonedRepositoryReference.kt\ncom/embabel/coding/tools/git/ClonedRepositoryReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n1863#2,2:209\n*S KotlinDebug\n*F\n+ 1 ClonedRepositoryReference.kt\ncom/embabel/coding/tools/git/ClonedRepositoryReference\n*L\n167#1:209,2\n*E\n"})
public final class ClonedRepositoryReference
implements AutoCloseable,
FileReadTools,
SymbolSearch,
FileReadLog,
LlmReference {
    private final /* synthetic */ DefaultFileReadLog $$delegate_0;
    @NotNull
    private final String url;
    @NotNull
    private final String description;
    @NotNull
    private final Path localPath;
    private final boolean deleteOnClose;
    @NotNull
    private final FileFormatLimits fileFormatLimits;
    @NotNull
    private final String root;
    private boolean isClosed;
    @Nullable
    private final Thread shutdownHook;

    public ClonedRepositoryReference(@NotNull String url, @NotNull String description, @NotNull Path localPath, boolean deleteOnClose, @NotNull FileFormatLimits fileFormatLimits) {
        Thread thread;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        Intrinsics.checkNotNullParameter((Object)fileFormatLimits, (String)"fileFormatLimits");
        this.$$delegate_0 = new DefaultFileReadLog(null, 1, null);
        this.url = url;
        this.description = description;
        this.localPath = localPath;
        this.deleteOnClose = deleteOnClose;
        this.fileFormatLimits = fileFormatLimits;
        this.root = ((Object)this.localPath.toAbsolutePath()).toString();
        if (this.deleteOnClose) {
            Thread hook = new Thread(() -> ClonedRepositoryReference._init_$lambda$0(this));
            Runtime.getRuntime().addShutdownHook(hook);
            thread = hook;
        } else {
            thread = null;
        }
        this.shutdownHook = thread;
    }

    public /* synthetic */ ClonedRepositoryReference(String string, String string2, Path path, boolean bl, FileFormatLimits fileFormatLimits, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            fileFormatLimits = new FileFormatLimits(0, 0L, 3, null);
        }
        this(string, string2, path, bl, fileFormatLimits);
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public final Path getLocalPath() {
        return this.localPath;
    }

    public final boolean getDeleteOnClose() {
        return this.deleteOnClose;
    }

    @NotNull
    public final FileFormatLimits getFileFormatLimits() {
        return this.fileFormatLimits;
    }

    @NotNull
    public String getName() {
        return StringsKt.substringAfterLast$default((String)this.url, (char)'/', null, (int)2, null);
    }

    @NotNull
    public List<StringTransformer> getFileContentTransformers() {
        return CollectionsKt.listOf((Object)WellKnownFileContentTransformers.INSTANCE.getRemoveApacheLicenseHeader());
    }

    @NotNull
    public String getRoot() {
        return this.root;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            Thread thread = this.shutdownHook;
            if (thread != null) {
                Thread hook = thread;
                boolean bl = false;
                try {
                    Boolean bl2 = Runtime.getRuntime().removeShutdownHook(hook);
                }
                catch (IllegalStateException e) {
                    Unit unit = Unit.INSTANCE;
                }
            }
            if (this.deleteOnClose) {
                this.cleanupRepository();
            }
        }
    }

    private final void cleanupRepository() {
        if (Files.exists(this.localPath, new LinkOption[0])) {
            try {
                File file = this.localPath.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                FilesKt.deleteRecursively((File)file);
            }
            catch (Exception e) {
                System.err.println("Warning: Could not delete temporary git repository at " + this.localPath + ": " + e.getMessage());
            }
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClonedRepositoryReference)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.localPath, (Object)((ClonedRepositoryReference)other).localPath);
    }

    public int hashCode() {
        return ((Object)this.localPath).hashCode();
    }

    @NotNull
    public String toString() {
        return "ClonedRepositoryReference(localPath=" + this.localPath + ", shouldDeleteOnClose=" + this.deleteOnClose + ")";
    }

    @NotNull
    public final String writeAllFilesToString() {
        StringBuilder result = new StringBuilder();
        List files = new ArrayList();
        try {
            Files.walkFileTree(this.localPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((List<Path>)files){
                final /* synthetic */ List<Path> $files;
                {
                    this.$files = $files;
                }

                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    Path path = dir.getFileName();
                    String dirName = path != null ? ((Object)path).toString() : null;
                    return Intrinsics.areEqual((Object)dirName, (Object)".git") ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    if (attrs.isRegularFile()) {
                        this.$files.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
                    return FileVisitResult.CONTINUE;
                }
            });
            Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)files);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                Path path = (Path)element$iv;
                boolean bl = false;
                Path relativePath = this.localPath.relativize(path);
                try {
                    Object object;
                    if (Files.size(path) > this.fileFormatLimits.getFileSizeLimit()) {
                        object = "// File too large to read: " + relativePath;
                    } else {
                        String rawContent = Files.readString(path);
                        StringTransformer stringTransformer = WellKnownFileContentTransformers.INSTANCE.getRemoveApacheLicenseHeader();
                        Intrinsics.checkNotNull((Object)rawContent);
                        object = stringTransformer.transform(rawContent);
                    }
                    string = object;
                }
                catch (Exception e) {
                    string = "// Error reading file: " + e.getMessage();
                }
                String content = string;
                result.append("=== " + relativePath + " ===\n");
                result.append(content);
                result.append("\n\n");
            }
        }
        catch (Exception e) {
            result.append("Error walking repository: " + e.getMessage());
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public String notes() {
        if (this.fileCount() > this.fileFormatLimits.getFileCountLimit() || (long)this.writeAllFilesToString().length() > this.fileFormatLimits.getFileSizeLimit()) {
            return "Use exposed tools. The repository is too large to include in the prompt.";
        }
        return StringsKt.trimMargin$default((String)("\n                |Cloned repository.\n                |Use file tools to read files in the repository relative to the root.\n                |Read limit is set to " + this.fileFormatLimits.getFileSizeLimit() + " bytes.\n                "), null, (int)1, null);
    }

    public void flushReads() {
        this.$$delegate_0.flushReads();
    }

    public void recordRead(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.$$delegate_0.recordRead(path);
    }

    @NotNull
    public List<FileReads> getReads() {
        return this.$$delegate_0.getReads();
    }

    @NotNull
    public List<String> getPathsRead() {
        return this.$$delegate_0.getPathsRead();
    }

    private static final void _init_$lambda$0(ClonedRepositoryReference this$0) {
        if (!this$0.isClosed) {
            this$0.cleanupRepository();
        }
    }
}

