/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.domain.library.code;

import com.embabel.agent.api.annotation.LlmTool;
import com.embabel.agent.api.common.LlmReference;
import com.embabel.agent.domain.library.code.SymbolSearch;
import com.embabel.agent.tools.file.DefaultFileChangeLog;
import com.embabel.agent.tools.file.DefaultFileReadLog;
import com.embabel.agent.tools.file.FileChangeLog;
import com.embabel.agent.tools.file.FileModification;
import com.embabel.agent.tools.file.FileReadLog;
import com.embabel.agent.tools.file.FileReads;
import com.embabel.agent.tools.file.FileTools;
import com.embabel.agent.tools.file.PatternSearch;
import com.embabel.agent.tools.file.WellKnownFileContentTransformers;
import com.embabel.coding.tools.ci.BuildOptions;
import com.embabel.coding.tools.ci.BuildResult;
import com.embabel.coding.tools.ci.Ci;
import com.embabel.coding.tools.git.GitOperations;
import com.embabel.common.util.StringTransformer;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallback;

@JsonClassDescription(value="Analysis of a technology project")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 @2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0001@BO\b\u0007\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\"H\u0007J\u0012\u0010+\u001a\u00020\b2\b\b\u0001\u0010\u001b\u001a\u00020\bH\u0007J\u001c\u0010,\u001a\u00020\b2\b\b\u0001\u0010-\u001a\u00020\b2\b\b\u0001\u0010.\u001a\u00020\bH\u0007J\u0010\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\bH\u0007J\u0006\u0010/\u001a\u000201J\b\u00102\u001a\u00020\bH\u0016J\b\u00103\u001a\u00020\bH\u0016J\t\u00104\u001a\u000205H\u0096\u0001J\t\u00106\u001a\u000205H\u0096\u0001J\u000f\u00107\u001a\b\u0012\u0004\u0012\u0002080\"H\u0096\u0001J\u000f\u00109\u001a\b\u0012\u0004\u0012\u00020\b0\"H\u0096\u0001J\u000f\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\"H\u0096\u0001J\u0011\u0010<\u001a\u0002052\u0006\u0010=\u001a\u000208H\u0096\u0001J\u0011\u0010>\u001a\u0002052\u0006\u0010?\u001a\u00020\bH\u0096\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0013\u0010\n\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0013\u0010\f\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0013R\u0014\u0010\u001d\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0013R\u0011\u0010\u001f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0013R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006A"}, d2={"Lcom/embabel/agent/domain/library/code/SoftwareProject;", "Lcom/embabel/agent/api/common/LlmReference;", "Lcom/embabel/agent/tools/file/FileTools;", "Lcom/embabel/agent/domain/library/code/SymbolSearch;", "Lcom/embabel/coding/tools/git/GitOperations;", "Lcom/embabel/agent/tools/file/FileChangeLog;", "Lcom/embabel/agent/tools/file/FileReadLog;", "root", "", "url", "tech", "defaultCodingStyle", "buildCommand", "streamOutput", "", "wasCreated", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZ)V", "getRoot", "()Ljava/lang/String;", "getUrl", "getTech", "getDefaultCodingStyle", "getBuildCommand", "getStreamOutput", "()Z", "getWasCreated", "name", "getName", "description", "getDescription", "codingStyle", "getCodingStyle", "fileContentTransformers", "", "Lcom/embabel/common/util/StringTransformer;", "getFileContentTransformers", "()Ljava/util/List;", "ci", "Lcom/embabel/coding/tools/ci/Ci;", "getCi", "()Lcom/embabel/coding/tools/ci/Ci;", "findJavaFiles", "findClass", "findPattern", "regex", "globPattern", "build", "command", "Lcom/embabel/coding/tools/ci/BuildResult;", "toString", "notes", "flushChanges", "", "flushReads", "getChanges", "Lcom/embabel/agent/tools/file/FileModification;", "getPathsRead", "getReads", "Lcom/embabel/agent/tools/file/FileReads;", "recordChange", "c", "recordRead", "path", "Companion", "embabel-agent-code"})
@SourceDebugExtension(value={"SMAP\nSoftwareProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoftwareProject.kt\ncom/embabel/agent/domain/library/code/SoftwareProject\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n27#2:149\n27#2:154\n27#2:155\n1557#3:150\n1628#3,3:151\n*S KotlinDebug\n*F\n+ 1 SoftwareProject.kt\ncom/embabel/agent/domain/library/code/SoftwareProject\n*L\n57#1:149\n72#1:154\n74#1:155\n59#1:150\n59#1:151,3\n*E\n"})
public class SoftwareProject
implements LlmReference,
FileTools,
SymbolSearch,
GitOperations,
FileChangeLog,
FileReadLog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ DefaultFileChangeLog $$delegate_0;
    private final /* synthetic */ DefaultFileReadLog $$delegate_1;
    @NotNull
    private final String root;
    @Nullable
    private final String url;
    @NotNull
    private final String tech;
    @NotNull
    private final String defaultCodingStyle;
    @NotNull
    private final String buildCommand;
    private final boolean streamOutput;
    private final boolean wasCreated;
    @NotNull
    private final Ci ci;
    @NotNull
    public static final String DEFAULT_CODING_STYLE_GUIDE = ".embabel/coding-style.md";

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public SoftwareProject(@NotNull String root, @Nullable String url, @NotNull String tech, @NotNull String defaultCodingStyle, @NotNull String buildCommand, boolean streamOutput, boolean wasCreated) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)tech, (String)"tech");
        Intrinsics.checkNotNullParameter((Object)defaultCodingStyle, (String)"defaultCodingStyle");
        Intrinsics.checkNotNullParameter((Object)buildCommand, (String)"buildCommand");
        this.$$delegate_0 = new DefaultFileChangeLog(null, 1, null);
        this.$$delegate_1 = new DefaultFileReadLog(null, 1, null);
        this.root = root;
        this.url = url;
        this.tech = tech;
        this.defaultCodingStyle = defaultCodingStyle;
        this.buildCommand = buildCommand;
        this.streamOutput = streamOutput;
        this.wasCreated = wasCreated;
        if (!this.exists()) {
            throw new IllegalStateException(("Directory '" + this.getRoot() + "' does not exist").toString());
        }
        boolean $i$f$loggerFor22 = false;
        Logger logger = LoggerFactory.getLogger(SoftwareProject.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Iterable $i$f$loggerFor22 = this.getToolCallbacks();
        Logger logger2 = logger;
        boolean $i$f$map = false;
        void var10_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ToolCallback toolCallback = (ToolCallback)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getToolDefinition().name());
        }
        logger2.info("Software project tools: " + CollectionsKt.sorted((Iterable)((List)destination$iv$iv)));
        this.ci = new Ci(this.getRoot(), null, 2, null);
    }

    public /* synthetic */ SoftwareProject(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = "Java,Embabel,Spring Boot,Maven";
        }
        if ((n & 8) != 0) {
            string4 = "No coding style guide found at .embabel/coding-style.md.\nTry to follow the conventions of files you read in the project.";
        }
        if ((n & 0x10) != 0) {
            string5 = "mvn clean test";
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        this(string, string2, string3, string4, string5, bl, bl2);
    }

    @NotNull
    public String getRoot() {
        return this.root;
    }

    @Nullable
    public final String getUrl() {
        return this.url;
    }

    @JsonPropertyDescription(value="The technologies used in the project. List, comma separated. Include 10")
    @NotNull
    public final String getTech() {
        return this.tech;
    }

    @NotNull
    public final String getDefaultCodingStyle() {
        return this.defaultCodingStyle;
    }

    @JsonPropertyDescription(value="Build command, such as 'mvn clean test'")
    @NotNull
    public final String getBuildCommand() {
        return this.buildCommand;
    }

    public final boolean getStreamOutput() {
        return this.streamOutput;
    }

    public final boolean getWasCreated() {
        return this.wasCreated;
    }

    @NotNull
    public String getName() {
        return StringsKt.substringAfterLast$default((String)this.getRoot(), (char)'/', null, (int)2, null);
    }

    @NotNull
    public String getDescription() {
        return "Software project at " + this.getRoot() + (String)(this.url != null ? " from " + this.url : "") + " using " + this.tech;
    }

    @NotNull
    public final String getCodingStyle() {
        String location = DEFAULT_CODING_STYLE_GUIDE;
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(SoftwareProject.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.info("Looking for coding style guide at '" + location + "'");
        String content = this.safeReadFile(location);
        boolean $i$f$loggerFor2 = false;
        Logger logger2 = LoggerFactory.getLogger(SoftwareProject.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        logger2.info("Found coding style guide at " + location);
        String string = content;
        if (string == null) {
            string = this.defaultCodingStyle;
        }
        return string;
    }

    @NotNull
    public List<StringTransformer> getFileContentTransformers() {
        return CollectionsKt.listOf((Object)WellKnownFileContentTransformers.INSTANCE.getRemoveApacheLicenseHeader());
    }

    @NotNull
    public final Ci getCi() {
        return this.ci;
    }

    @LlmTool(description="Find all Java files under src/main/java. Good for quickly getting to grips with a project")
    @NotNull
    public final List<String> findJavaFiles() {
        List files = this.findFiles("src/main/java/**.java", false);
        return files.size() > 100 ? CollectionsKt.listOf((Object)"More than 100 Java files found, please narrow your search") : files;
    }

    @LlmTool(description="Returns the file containing a class with the given name")
    @NotNull
    public final String findClass(@LlmTool.Param(description="class name") @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List matches = SymbolSearch.findClassInProject$default(this, name, "**/*.{java,kt}", false, 4, null);
        return !((Collection)matches).isEmpty() ? CollectionsKt.joinToString$default((Iterable)matches, (CharSequence)"\n", null, null, (int)0, null, SoftwareProject::findClass$lambda$1, (int)30, null) : "No class found with name " + name;
    }

    @LlmTool(description="Returns the file containing a class with the given name")
    @NotNull
    public final String findPattern(@LlmTool.Param(description="regex pattern") @NotNull String regex, @LlmTool.Param(description="glob pattern for file to search") @NotNull String globPattern) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter((Object)globPattern, (String)"globPattern");
        List matches = PatternSearch.findPatternInProject$default((PatternSearch)this, (Regex)new Regex(regex), (String)globPattern, (boolean)false, (int)4, null);
        return !((Collection)matches).isEmpty() ? CollectionsKt.joinToString$default((Iterable)matches, (CharSequence)"\n", null, null, (int)0, null, SoftwareProject::findPattern$lambda$2, (int)30, null) : "No matches for pattern '" + regex + "' in " + globPattern;
    }

    @LlmTool(description="Build the project using the given command in the root")
    @NotNull
    public final String build(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        BuildResult br = this.ci.buildAndParse(new BuildOptions(command, this.streamOutput, false, 4, null));
        return br.relevantOutput();
    }

    @NotNull
    public final BuildResult build() {
        return this.ci.buildAndParse(new BuildOptions(this.buildCommand, this.streamOutput, false, 4, null));
    }

    @NotNull
    public String toString() {
        return "SoftwareProject(" + this.getRoot() + ")";
    }

    @NotNull
    public String notes() {
        String string = this.url;
        if (string == null) {
            string = "No URL";
        }
        return StringsKt.trimMargin$default((String)("\n            |Project:\n            |" + string + "\n            |" + this.tech + "\n            |\n            |Coding style:\n            |" + this.getCodingStyle() + "\n        "), null, (int)1, null);
    }

    public void flushReads() {
        this.$$delegate_1.flushReads();
    }

    public void recordRead(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.$$delegate_1.recordRead(path);
    }

    @NotNull
    public List<FileReads> getReads() {
        return this.$$delegate_1.getReads();
    }

    @NotNull
    public List<String> getPathsRead() {
        return this.$$delegate_1.getPathsRead();
    }

    public void flushChanges() {
        this.$$delegate_0.flushChanges();
    }

    public void recordChange(@NotNull FileModification c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.$$delegate_0.recordChange(c);
    }

    @NotNull
    public List<FileModification> getChanges() {
        return this.$$delegate_0.getChanges();
    }

    @JvmOverloads
    public SoftwareProject(@NotNull String root, @Nullable String url, @NotNull String tech, @NotNull String defaultCodingStyle, @NotNull String buildCommand, boolean streamOutput) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)tech, (String)"tech");
        Intrinsics.checkNotNullParameter((Object)defaultCodingStyle, (String)"defaultCodingStyle");
        Intrinsics.checkNotNullParameter((Object)buildCommand, (String)"buildCommand");
        this(root, url, tech, defaultCodingStyle, buildCommand, streamOutput, false, 64, null);
    }

    @JvmOverloads
    public SoftwareProject(@NotNull String root, @Nullable String url, @NotNull String tech, @NotNull String defaultCodingStyle, @NotNull String buildCommand) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)tech, (String)"tech");
        Intrinsics.checkNotNullParameter((Object)defaultCodingStyle, (String)"defaultCodingStyle");
        Intrinsics.checkNotNullParameter((Object)buildCommand, (String)"buildCommand");
        this(root, url, tech, defaultCodingStyle, buildCommand, false, false, 96, null);
    }

    @JvmOverloads
    public SoftwareProject(@NotNull String root, @Nullable String url, @NotNull String tech, @NotNull String defaultCodingStyle) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)tech, (String)"tech");
        Intrinsics.checkNotNullParameter((Object)defaultCodingStyle, (String)"defaultCodingStyle");
        this(root, url, tech, defaultCodingStyle, null, false, false, 112, null);
    }

    @JvmOverloads
    public SoftwareProject(@NotNull String root, @Nullable String url, @NotNull String tech) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)tech, (String)"tech");
        this(root, url, tech, null, null, false, false, 120, null);
    }

    @JvmOverloads
    public SoftwareProject(@NotNull String root, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this(root, url, null, null, null, false, false, 124, null);
    }

    @JvmOverloads
    public SoftwareProject(@NotNull String root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this(root, null, null, null, null, false, false, 126, null);
    }

    private static final CharSequence findClass$lambda$1(PatternSearch.PatternMatch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRelativePath();
    }

    private static final CharSequence findPattern$lambda$2(PatternSearch.PatternMatch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRelativePath();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/embabel/agent/domain/library/code/SoftwareProject$Companion;", "", "<init>", "()V", "DEFAULT_CODING_STYLE_GUIDE", "", "embabel-agent-code"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

