/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.coding.tools.git;

import com.embabel.agent.core.AgentProcess;
import com.embabel.coding.tools.git.ClonedRepositoryReference;
import com.embabel.coding.tools.git.FileFormatLimits;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0001\u0010\u0012\u001a\u00020\u0010H\u0007J5\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0007\u00a2\u0006\u0002\u0010\u0017J=\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0007\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001aH\u0002J\t\u0010\u001d\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\fH\u00d6\u0001J\t\u0010#\u001a\u00020\u0010H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006%"}, d2={"Lcom/embabel/coding/tools/git/RepositoryReferenceProvider;", "", "fileFormatLimits", "Lcom/embabel/coding/tools/git/FileFormatLimits;", "<init>", "(Lcom/embabel/coding/tools/git/FileFormatLimits;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "withFileCountLimit", "limit", "", "withFileSizeLimit", "", "clone", "", "url", "description", "cloneRepository", "Lcom/embabel/coding/tools/git/ClonedRepositoryReference;", "branch", "depth", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lcom/embabel/coding/tools/git/ClonedRepositoryReference;", "cloneRepositoryTo", "targetDirectory", "Ljava/nio/file/Path;", "(Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/Integer;)Lcom/embabel/coding/tools/git/ClonedRepositoryReference;", "createTempDirectory", "component1", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "embabel-agent-code"})
@SourceDebugExtension(value={"SMAP\nRepositoryReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryReferenceProvider.kt\ncom/embabel/coding/tools/git/RepositoryReferenceProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1#2:187\n*E\n"})
public final class RepositoryReferenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileFormatLimits fileFormatLimits;
    private final Logger logger;

    public RepositoryReferenceProvider(@NotNull FileFormatLimits fileFormatLimits) {
        Intrinsics.checkNotNullParameter((Object)fileFormatLimits, (String)"fileFormatLimits");
        this.fileFormatLimits = fileFormatLimits;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public /* synthetic */ RepositoryReferenceProvider(FileFormatLimits fileFormatLimits, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fileFormatLimits = new FileFormatLimits(0, 0L, 3, null);
        }
        this(fileFormatLimits);
    }

    @NotNull
    public final RepositoryReferenceProvider withFileCountLimit(int limit) {
        return this.copy(FileFormatLimits.copy$default(this.fileFormatLimits, limit, 0L, 2, null));
    }

    @NotNull
    public final RepositoryReferenceProvider withFileSizeLimit(long limit) {
        return this.copy(FileFormatLimits.copy$default(this.fileFormatLimits, 0, limit, 1, null));
    }

    @Tool(description="Clone a Git repository from the given URL to a temporary directory")
    @NotNull
    public final String clone(@NotNull String url, @ToolParam(description="Description of the repository") @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        AgentProcess agentProcess = AgentProcess.Companion.get();
        if (agentProcess == null) {
            throw new IllegalStateException("No agent process: Cannot add cloned repository to agent process".toString());
        }
        ClonedRepositoryReference clonedRepositoryReference = RepositoryReferenceProvider.cloneRepository$default(this, url, "Different description", null, null, 12, null);
        agentProcess.plusAssign((Object)clonedRepositoryReference);
        return "Cloned repository from " + url + " to " + clonedRepositoryReference.getLocalPath() + " and added to agent process " + agentProcess.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final ClonedRepositoryReference cloneRepository(@NotNull String url, @NotNull String description, @Nullable String branch, @Nullable Integer depth) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Path tempDir = this.createTempDirectory();
        try {
            this.logger.debug("Cloning a Git repository from " + url + " into temp dir " + ((Object)tempDir.toAbsolutePath()).toString());
            CloneCommand cloneCommand = Git.cloneRepository().setURI(url).setDirectory(tempDir.toFile()).setCloneAllBranches(branch == null);
            String string = branch;
            if (string != null) {
                String it = string;
                boolean bl = false;
                cloneCommand.setBranch(it);
            }
            Integer n = depth;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                cloneCommand.setDepth(it);
            }
            AutoCloseable autoCloseable = (AutoCloseable)cloneCommand.call();
            Throwable throwable = null;
            try {
                Git git = (Git)autoCloseable;
                boolean bl = false;
                if (!Files.exists(tempDir.resolve(".git"), new LinkOption[0])) {
                    throw new IllegalStateException("Clone operation completed but .git directory not found");
                }
                git = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            this.logger.info("\u2705 Cloned Git repository from " + url + " into temp dir " + ((Object)tempDir.toAbsolutePath()).toString());
            return new ClonedRepositoryReference(url, description, tempDir, true, this.fileFormatLimits);
        }
        catch (Exception e) {
            try {
                File file = tempDir.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                FilesKt.deleteRecursively((File)file);
            }
            catch (Exception cleanupEx) {
                ExceptionsKt.addSuppressed((Throwable)e, (Throwable)cleanupEx);
            }
            throw e instanceof GitAPIException ? (Throwable)e : (Throwable)e;
        }
    }

    public static /* synthetic */ ClonedRepositoryReference cloneRepository$default(RepositoryReferenceProvider repositoryReferenceProvider, String string, String string2, String string3, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string3 = null;
        }
        if ((n2 & 8) != 0) {
            n = null;
        }
        return repositoryReferenceProvider.cloneRepository(string, string2, string3, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final ClonedRepositoryReference cloneRepositoryTo(@NotNull String url, @NotNull String description, @NotNull Path targetDirectory, @Nullable String branch, @Nullable Integer depth) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        if (Files.exists(targetDirectory, new LinkOption[0])) {
            boolean it22;
            AutoCloseable autoCloseable = Files.list(targetDirectory);
            object = null;
            try {
                Stream it22 = (Stream)autoCloseable;
                boolean bl = false;
                it22 = it22.findFirst().isPresent();
            }
            catch (Throwable bl) {
                object = bl;
                throw bl;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object);
            }
            if (it22) {
                throw new IllegalArgumentException("Target directory " + targetDirectory + " already exists and is not empty");
            }
        }
        Files.createDirectories(targetDirectory.getParent(), new FileAttribute[0]);
        CloneCommand cloneCommand = Git.cloneRepository().setURI(url).setDirectory(targetDirectory.toFile()).setCloneAllBranches(branch == null);
        String string = branch;
        if (string != null) {
            String it = string;
            boolean bl = false;
            cloneCommand.setBranch(it);
        }
        Integer n = depth;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            cloneCommand.setDepth(it);
        }
        object = (AutoCloseable)cloneCommand.call();
        Throwable throwable = null;
        try {
            Git git = (Git)object;
            boolean bl = false;
            if (!Files.exists(targetDirectory.resolve(".git"), new LinkOption[0])) {
                throw new IllegalStateException("Clone operation completed but .git directory not found");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        return new ClonedRepositoryReference(url, description, targetDirectory, false, this.fileFormatLimits);
    }

    public static /* synthetic */ ClonedRepositoryReference cloneRepositoryTo$default(RepositoryReferenceProvider repositoryReferenceProvider, String string, String string2, Path path, String string3, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        return repositoryReferenceProvider.cloneRepositoryTo(string, string2, path, string3, n);
    }

    private final Path createTempDirectory() {
        Path path = Files.createTempDirectory("embabel-git-", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        return path;
    }

    private final FileFormatLimits component1() {
        return this.fileFormatLimits;
    }

    @NotNull
    public final RepositoryReferenceProvider copy(@NotNull FileFormatLimits fileFormatLimits) {
        Intrinsics.checkNotNullParameter((Object)fileFormatLimits, (String)"fileFormatLimits");
        return new RepositoryReferenceProvider(fileFormatLimits);
    }

    public static /* synthetic */ RepositoryReferenceProvider copy$default(RepositoryReferenceProvider repositoryReferenceProvider, FileFormatLimits fileFormatLimits, int n, Object object) {
        if ((n & 1) != 0) {
            fileFormatLimits = repositoryReferenceProvider.fileFormatLimits;
        }
        return repositoryReferenceProvider.copy(fileFormatLimits);
    }

    @NotNull
    public String toString() {
        return "RepositoryReferenceProvider(fileFormatLimits=" + this.fileFormatLimits + ")";
    }

    public int hashCode() {
        return this.fileFormatLimits.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RepositoryReferenceProvider)) {
            return false;
        }
        RepositoryReferenceProvider repositoryReferenceProvider = (RepositoryReferenceProvider)other;
        return Intrinsics.areEqual((Object)this.fileFormatLimits, (Object)repositoryReferenceProvider.fileFormatLimits);
    }

    @JvmOverloads
    @NotNull
    public final ClonedRepositoryReference cloneRepository(@NotNull String url, @NotNull String description, @Nullable String branch) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return RepositoryReferenceProvider.cloneRepository$default(this, url, description, branch, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final ClonedRepositoryReference cloneRepository(@NotNull String url, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return RepositoryReferenceProvider.cloneRepository$default(this, url, description, null, null, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final ClonedRepositoryReference cloneRepositoryTo(@NotNull String url, @NotNull String description, @NotNull Path targetDirectory, @Nullable String branch) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        return RepositoryReferenceProvider.cloneRepositoryTo$default(this, url, description, targetDirectory, branch, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final ClonedRepositoryReference cloneRepositoryTo(@NotNull String url, @NotNull String description, @NotNull Path targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        return RepositoryReferenceProvider.cloneRepositoryTo$default(this, url, description, targetDirectory, null, null, 24, null);
    }

    public RepositoryReferenceProvider() {
        this(null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final RepositoryReferenceProvider create() {
        return Companion.create();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/embabel/coding/tools/git/RepositoryReferenceProvider$Companion;", "", "<init>", "()V", "create", "Lcom/embabel/coding/tools/git/RepositoryReferenceProvider;", "embabel-agent-code"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RepositoryReferenceProvider create() {
            return new RepositoryReferenceProvider(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

