/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.ux.form;

import com.embabel.ux.form.Control;
import com.embabel.ux.form.ControlValue;
import com.embabel.ux.form.FormValidator;
import com.embabel.ux.form.ValidationResult;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/embabel/ux/form/RequiredFormValidator;", "Lcom/embabel/ux/form/FormValidator;", "<init>", "()V", "validate", "Lcom/embabel/ux/form/ValidationResult;", "value", "Lcom/embabel/ux/form/ControlValue;", "control", "Lcom/embabel/ux/form/Control;", "embabel-agent-api"})
public final class RequiredFormValidator
implements FormValidator {
    @Override
    @NotNull
    public ValidationResult validate(@NotNull ControlValue value, @NotNull Control control) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        ControlValue controlValue = value;
        if (controlValue instanceof ControlValue.TextValue) {
            bl = StringsKt.isBlank((CharSequence)((ControlValue.TextValue)value).getValue());
        } else if (controlValue instanceof ControlValue.BooleanValue) {
            bl = !((ControlValue.BooleanValue)value).getValue();
        } else if (controlValue instanceof ControlValue.OptionValue) {
            bl = StringsKt.isBlank((CharSequence)((ControlValue.OptionValue)value).getValue());
        } else if (controlValue instanceof ControlValue.MultiOptionValue) {
            bl = ((ControlValue.MultiOptionValue)value).getValues().isEmpty();
        } else if (controlValue instanceof ControlValue.FileValue) {
            bl = ((ControlValue.FileValue)value).getFileIds().isEmpty();
        } else if (controlValue instanceof ControlValue.DateValue || controlValue instanceof ControlValue.TimeValue || controlValue instanceof ControlValue.NumberValue) {
            bl = false;
        } else if (controlValue instanceof ControlValue.EmptyValue) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean isEmpty = bl;
        return isEmpty ? new ValidationResult(false, "This field is required") : new ValidationResult(true, null, 2, null);
    }
}

