/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.plan.goap.astar;

import com.embabel.plan.common.condition.ConditionAction;
import com.embabel.plan.common.condition.ConditionDetermination;
import com.embabel.plan.common.condition.ConditionGoal;
import com.embabel.plan.common.condition.ConditionPlan;
import com.embabel.plan.common.condition.ConditionWorldState;
import com.embabel.plan.common.condition.WorldStateDeterminer;
import com.embabel.plan.goap.OptimizingGoapPlanner;
import com.embabel.plan.goap.astar.SearchNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J,\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J8\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u00102 \u0010\u001a\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\f0\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\tH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/embabel/plan/goap/astar/AStarGoapPlanner;", "Lcom/embabel/plan/goap/OptimizingGoapPlanner;", "worldStateDeterminer", "Lcom/embabel/plan/common/condition/WorldStateDeterminer;", "<init>", "(Lcom/embabel/plan/common/condition/WorldStateDeterminer;)V", "planToGoalFrom", "Lcom/embabel/plan/common/condition/ConditionPlan;", "startState", "Lcom/embabel/plan/common/condition/ConditionWorldState;", "actions", "", "Lcom/embabel/plan/common/condition/ConditionAction;", "goal", "Lcom/embabel/plan/common/condition/ConditionGoal;", "backwardPlanningOptimization", "", "plan", "forwardPlanningOptimization", "simulatePlan", "isGoalReachable", "", "heuristic", "", "state", "reconstructPath", "cameFrom", "", "Lkotlin/Pair;", "goalState", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nAStarGoapPlanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AStarGoapPlanner.kt\ncom/embabel/plan/goap/astar/AStarGoapPlanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,372:1\n1062#2:373\n216#3,2:374\n188#3,3:376\n205#3,4:379\n*S KotlinDebug\n*F\n+ 1 AStarGoapPlanner.kt\ncom/embabel/plan/goap/astar/AStarGoapPlanner\n*L\n111#1:373\n194#1:374,2\n233#1:376,3\n317#1:379,4\n*E\n"})
public final class AStarGoapPlanner
extends OptimizingGoapPlanner {
    public AStarGoapPlanner(@NotNull WorldStateDeterminer worldStateDeterminer) {
        Intrinsics.checkNotNullParameter((Object)worldStateDeterminer, (String)"worldStateDeterminer");
        super(worldStateDeterminer);
    }

    @Override
    @Nullable
    protected ConditionPlan planToGoalFrom(@NotNull ConditionWorldState startState, @NotNull Collection<? extends ConditionAction> actions, @NotNull ConditionGoal goal) {
        Intrinsics.checkNotNullParameter((Object)startState, (String)"startState");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        if (goal.isAchievable(startState)) {
            return new ConditionPlan(CollectionsKt.emptyList(), goal, startState);
        }
        if (!this.isGoalReachable(startState, actions, goal)) {
            return null;
        }
        PriorityQueue<SearchNode> openList = new PriorityQueue<SearchNode>();
        Map gScores = MapsKt.withDefaultMutable((Map)new LinkedHashMap(), AStarGoapPlanner::planToGoalFrom$lambda$0);
        Map cameFrom = new LinkedHashMap();
        Set closedSet = new LinkedHashSet();
        gScores.put(startState, 0.0);
        openList.add(new SearchNode(startState, 0.0, this.heuristic(startState, goal)));
        SearchNode bestGoalNode = null;
        double bestGoalScore = Double.MAX_VALUE;
        int iterationCount = 0;
        int maxIterations = 10000;
        while (!((Collection)openList).isEmpty() && iterationCount < maxIterations) {
            ++iterationCount;
            SearchNode current = (SearchNode)openList.poll();
            if (bestGoalNode != null && current.getGScore() >= bestGoalScore || closedSet.contains(current.getState())) continue;
            closedSet.add(current.getState());
            if (goal.isAchievable(current.getState())) {
                if (bestGoalNode != null && !(current.getGScore() < bestGoalScore)) continue;
                bestGoalNode = current;
                bestGoalScore = current.getGScore();
                continue;
            }
            Iterable $this$sortedByDescending$iv = actions;
            boolean $i$f$sortedByDescending = false;
            List sortedActions = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ConditionAction it = (ConditionAction)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPreconditions().size());
                    it = (ConditionAction)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPreconditions().size()));
                }
            });
            for (ConditionAction action : sortedActions) {
                boolean bl;
                ConditionWorldState nextState;
                if (!action.isAchievable(current.getState()) || Intrinsics.areEqual((Object)(nextState = current.getState().plus(action)), (Object)current.getState())) continue;
                double tentativeGScore = ((Number)MapsKt.getValue((Map)gScores, (Object)current.getState())).doubleValue() + ((Number)action.getCost().invoke((Object)startState)).doubleValue();
                if (bestGoalNode != null && tentativeGScore >= bestGoalScore || !(tentativeGScore < ((Number)MapsKt.getValue((Map)gScores, (Object)nextState)).doubleValue())) continue;
                cameFrom.put(nextState, new Pair((Object)current.getState(), (Object)action));
                Double d = tentativeGScore;
                gScores.put(nextState, d);
                if (!closedSet.contains(nextState)) {
                    bl = openList.add(new SearchNode(nextState, tentativeGScore, this.heuristic(nextState, goal)));
                    continue;
                }
                closedSet.remove(nextState);
                bl = openList.add(new SearchNode(nextState, tentativeGScore, this.heuristic(nextState, goal)));
            }
        }
        if (bestGoalNode != null) {
            List<ConditionAction> plan = this.reconstructPath(cameFrom, bestGoalNode.getState());
            List<ConditionAction> optimizedPlan = this.backwardPlanningOptimization(plan, startState, goal);
            List<ConditionAction> finalPlan = this.forwardPlanningOptimization(optimizedPlan, startState, goal);
            return new ConditionPlan(finalPlan, goal, startState);
        }
        return null;
    }

    private final List<ConditionAction> backwardPlanningOptimization(List<? extends ConditionAction> plan, ConditionWorldState startState, ConditionGoal goal) {
        if (plan.isEmpty()) {
            return plan;
        }
        Map targetConditions = MapsKt.toMutableMap(goal.getPreconditions());
        List keptActions = new ArrayList();
        for (ConditionAction action : CollectionsKt.reversed((Iterable)plan)) {
            boolean isNecessary = false;
            for (Map.Entry<String, ConditionDetermination> entry : action.getEffects().entrySet()) {
                String key = entry.getKey();
                ConditionDetermination value = entry.getValue();
                if (targetConditions.get(key) != value) continue;
                isNecessary = true;
                targetConditions.remove(key);
                Map<String, ConditionDetermination> $this$forEach$iv = action.getPreconditions();
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, ConditionDetermination>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ConditionDetermination> element$iv;
                    Map.Entry<String, ConditionDetermination> entry2 = element$iv = iterator.next();
                    boolean bl = false;
                    String precKey = entry2.getKey();
                    ConditionDetermination precValue = entry2.getValue();
                    targetConditions.put(precKey, precValue);
                }
            }
            if (!isNecessary) continue;
            keptActions.add(action);
        }
        return CollectionsKt.reversed((Iterable)keptActions);
    }

    /*
     * Unable to fully structure code
     */
    private final List<ConditionAction> forwardPlanningOptimization(List<? extends ConditionAction> plan, ConditionWorldState startState, ConditionGoal goal) {
        if (plan.isEmpty()) {
            return plan;
        }
        optimizedPlan = new ArrayList<E>();
        currentState = null;
        currentState = startState;
        for (ConditionAction action : plan) {
            block8: {
                if (!action.isAchievable(currentState)) continue;
                nextState = currentState.plus(action);
                if (Intrinsics.areEqual((Object)nextState, (Object)currentState)) ** GOTO lbl-1000
                $this$any$iv = action.getEffects();
                $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    v0 = false;
                } else {
                    var12_12 = $this$any$iv.entrySet().iterator();
                    while (var12_12.hasNext()) {
                        var14_14 = element$iv = var12_12.next();
                        $i$a$-any-AStarGoapPlanner$forwardPlanningOptimization$progressMade$1 = false;
                        key = var14_14.getKey();
                        value = var14_14.getValue();
                        if (!(goal.getPreconditions().containsKey(key) != false && currentState.getState().get(key) != goal.getPreconditions().get(key) && (value == goal.getPreconditions().get(key) || nextState.getState().containsKey(key) == false))) continue;
                        v0 = true;
                        break block8;
                    }
                    v0 = false;
                }
            }
            if (v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!(progressMade = v1)) continue;
            optimizedPlan.add(action);
            currentState = nextState;
        }
        finalState = this.simulatePlan(startState, optimizedPlan);
        if (!goal.isAchievable(finalState) && ((Collection)plan).isEmpty() == false) {
            return plan;
        }
        return optimizedPlan;
    }

    private final ConditionWorldState simulatePlan(ConditionWorldState startState, List<? extends ConditionAction> actions) {
        ConditionWorldState currentState = startState;
        for (ConditionAction conditionAction : actions) {
            if (!conditionAction.isAchievable(currentState)) continue;
            currentState = currentState.plus(conditionAction);
        }
        return currentState;
    }

    private final boolean isGoalReachable(ConditionWorldState startState, Collection<? extends ConditionAction> actions, ConditionGoal goal) {
        Set producibleEffects = new LinkedHashSet();
        for (ConditionAction entry : actions) {
            for (Map.Entry<String, ConditionDetermination> entry2 : entry.getEffects().entrySet()) {
                String key = entry2.getKey();
                ConditionDetermination value = entry2.getValue();
                producibleEffects.add(TuplesKt.to((Object)key, (Object)((Object)value)));
            }
        }
        for (Map.Entry entry : goal.getPreconditions().entrySet()) {
            String key = (String)entry.getKey();
            ConditionDetermination value = (ConditionDetermination)((Object)entry.getValue());
            if (startState.getState().get(key) == value || producibleEffects.contains(TuplesKt.to((Object)key, (Object)((Object)value)))) continue;
            return false;
        }
        return true;
    }

    private final double heuristic(ConditionWorldState state, ConditionGoal goal) {
        int n;
        Map<String, ConditionDetermination> $this$count$iv = goal.getPreconditions();
        boolean $i$f$count = false;
        if ($this$count$iv.isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            Iterator<Map.Entry<String, ConditionDetermination>> iterator = $this$count$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ConditionDetermination> element$iv;
                Map.Entry<String, ConditionDetermination> entry = element$iv = iterator.next();
                boolean bl = false;
                String key = entry.getKey();
                ConditionDetermination value = entry.getValue();
                if (!(state.getState().get(key) != value)) continue;
                ++count$iv;
            }
            n = count$iv;
        }
        return n;
    }

    private final List<ConditionAction> reconstructPath(Map<ConditionWorldState, ? extends Pair<? extends ConditionWorldState, ? extends ConditionAction>> cameFrom, ConditionWorldState goalState) {
        List actions = new ArrayList();
        ConditionWorldState currentState = goalState;
        while (cameFrom.containsKey(currentState)) {
            Pair<? extends ConditionWorldState, ? extends ConditionAction> pair;
            Intrinsics.checkNotNull(cameFrom.get(currentState));
            ConditionWorldState previousState = (ConditionWorldState)pair.component1();
            ConditionAction action = (ConditionAction)pair.component2();
            if (action != null) {
                actions.add(action);
            }
            currentState = previousState;
        }
        return CollectionsKt.reversed((Iterable)actions);
    }

    private static final double planToGoalFrom$lambda$0(ConditionWorldState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Double.MAX_VALUE;
    }
}

