/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.process;

import com.embabel.agent.api.common.ToolStats;
import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.api.tool.progressive.UnfoldingTool;
import com.embabel.agent.core.ActionInvocation;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.Budget;
import com.embabel.agent.core.Usage;
import com.embabel.agent.tools.process.AgentProcessTools;
import com.embabel.common.ai.model.LlmMetadata;
import com.embabel.plan.Goal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u0006\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/embabel/agent/tools/process/AgentProcessTools;", "", "<init>", "()V", "create", "Lcom/embabel/agent/api/tool/progressive/UnfoldingTool;", "getAgentProcessOrError", "Lkotlin/Pair;", "Lcom/embabel/agent/core/AgentProcess;", "Lcom/embabel/agent/api/tool/Tool$Result;", "formatDuration", "", "duration", "Ljava/time/Duration;", "createStatusTool", "Lcom/embabel/agent/api/tool/Tool;", "createBudgetTool", "createCostTool", "createHistoryTool", "createToolStatsTool", "createModelsUsedTool", "embabel-agent-api"})
public final class AgentProcessTools {
    @NotNull
    public final UnfoldingTool create() {
        Object[] objectArray = new Tool[]{this.createStatusTool(), this.createBudgetTool(), this.createCostTool(), this.createHistoryTool(), this.createToolStatsTool(), this.createModelsUsedTool()};
        return UnfoldingTool.Factory.of$default(UnfoldingTool.Companion, "agent_process", "Access information about the current agent process including status, budget, cost, and history. Invoke to see available operations.", CollectionsKt.listOf((Object[])objectArray), false, "Use process_status for current state and runtime. Use process_budget to check limits. Use process_cost to see spending.", 8, null);
    }

    private final Pair<AgentProcess, Tool.Result> getAgentProcessOrError() {
        AgentProcess agentProcess = AgentProcess.Companion.get();
        if (agentProcess == null) {
            return TuplesKt.to(null, (Object)Tool.Result.Companion.text("No agent process available. These tools require an active agent context."));
        }
        AgentProcess agentProcess2 = agentProcess;
        return TuplesKt.to((Object)agentProcess2, null);
    }

    private final String formatDuration(Duration duration) {
        long totalSeconds = duration.getSeconds();
        long hours = totalSeconds / (long)3600;
        long minutes = totalSeconds % (long)3600 / (long)60;
        long seconds = totalSeconds % (long)60;
        int millis = duration.toMillisPart();
        return hours > 0L ? hours + "h " + minutes + "m " + seconds + "s" : (minutes > 0L ? minutes + "m " + seconds + "s" : (seconds > 0L ? seconds + "." + millis / 100 + "s" : millis + "ms"));
    }

    private final Tool createStatusTool() {
        return new Tool(this){
            private final Tool.Definition definition;
            final /* synthetic */ AgentProcessTools this$0;
            {
                this.this$0 = $receiver;
                this.definition = Tool.Definition.Companion.invoke("process_status", "Get the current process status, ID, running time, and goal information", Tool.InputSchema.Companion.empty());
            }

            public Tool.Definition getDefinition() {
                return this.definition;
            }

            public Tool.Result call(String input) {
                Object object;
                AgentProcess p;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                        Pair pair = AgentProcessTools.access$getAgentProcessOrError(this.this$0);
                        AgentProcess process = (AgentProcess)pair.component1();
                        Tool.Result error = (Tool.Result)pair.component2();
                        if (error != null) {
                            return error;
                        }
                        AgentProcess agentProcess = process;
                        Intrinsics.checkNotNull((Object)agentProcess);
                        p = agentProcess;
                        object = p.getGoal();
                        if (object == null) break block5;
                        Goal it = object;
                        boolean bl = false;
                        String string = "Goal: " + it.getName();
                        object = string;
                        if (string != null) break block6;
                    }
                    object = "No goal (utility process)";
                }
                Object goalInfo = object;
                String string = p.getId();
                Enum enum_ = p.getStatus();
                String string2 = AgentProcessTools.access$formatDuration(this.this$0, p.getRunningTime());
                String string3 = p.getParentId();
                if (string3 == null) {
                    string3 = "none (root process)";
                }
                return Tool.Result.Companion.text(StringsKt.trimMargin$default((String)("\n                |Process ID: " + string + "\n                |Status: " + enum_ + "\n                |Running time: " + string2 + "\n                |" + (String)goalInfo + "\n                |Parent ID: " + string3 + "\n                "), null, (int)1, null));
            }
        };
    }

    private final Tool createBudgetTool() {
        return new Tool(this){
            private final Tool.Definition definition;
            final /* synthetic */ AgentProcessTools this$0;
            {
                this.this$0 = $receiver;
                this.definition = Tool.Definition.Companion.invoke("process_budget", "Get the budget limits and current usage against those limits", Tool.InputSchema.Companion.empty());
            }

            public Tool.Definition getDefinition() {
                return this.definition;
            }

            public Tool.Result call(String input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Pair pair = AgentProcessTools.access$getAgentProcessOrError(this.this$0);
                AgentProcess process = (AgentProcess)pair.component1();
                Tool.Result error = (Tool.Result)pair.component2();
                if (error != null) {
                    return error;
                }
                AgentProcess agentProcess = process;
                Intrinsics.checkNotNull((Object)agentProcess);
                AgentProcess p = agentProcess;
                Budget budget = p.getProcessOptions().getBudget();
                double currentCost = p.cost();
                Usage usage = p.usage();
                int actionsUsed = p.getHistory().size();
                double costRemaining = budget.getCost() - currentCost;
                Integer n = usage.getPromptTokens();
                Integer n2 = usage.getCompletionTokens();
                int tokensRemaining = budget.getTokens() - (n != null ? n : 0) - (n2 != null ? n2 : 0);
                int actionsRemaining = budget.getActions() - actionsUsed;
                Object[] objectArray = "%.4f";
                Object[] objectArray2 = new Object[]{budget.getCost()};
                String string = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                objectArray = "%.4f";
                objectArray2 = new Object[]{currentCost};
                String string2 = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                objectArray = "%.4f";
                objectArray2 = new Object[]{costRemaining};
                String string3 = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                String string4 = "%,d";
                objectArray = new Object[]{budget.getTokens()};
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
                string4 = "%,d";
                objectArray = new Object[1];
                Integer n3 = usage.getPromptTokens();
                Integer n4 = usage.getCompletionTokens();
                objectArray[0] = (n3 != null ? n3 : 0) + (n4 != null ? n4 : 0);
                String string6 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
                string4 = "%,d";
                objectArray = new Object[]{tokensRemaining};
                String string7 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
                return Tool.Result.Companion.text(StringsKt.trimMargin$default((String)("\n                |Budget Status:\n                |\n                |Cost limit: $" + string + "\n                |  Used: $" + string2 + "\n                |  Remaining: $" + string3 + "\n                |\n                |Token limit: " + string5 + "\n                |  Used: " + string6 + "\n                |  Remaining: " + string7 + "\n                |\n                |Action limit: " + budget.getActions() + "\n                |  Used: " + actionsUsed + "\n                |  Remaining: " + actionsRemaining + "\n                "), null, (int)1, null));
            }
        };
    }

    private final Tool createCostTool() {
        return new Tool(this){
            private final Tool.Definition definition;
            final /* synthetic */ AgentProcessTools this$0;
            {
                this.this$0 = $receiver;
                this.definition = Tool.Definition.Companion.invoke("process_cost", "Get detailed cost and token usage information", Tool.InputSchema.Companion.empty());
            }

            public Tool.Definition getDefinition() {
                return this.definition;
            }

            public Tool.Result call(String input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Pair pair = AgentProcessTools.access$getAgentProcessOrError(this.this$0);
                AgentProcess process = (AgentProcess)pair.component1();
                Tool.Result error = (Tool.Result)pair.component2();
                if (error != null) {
                    return error;
                }
                AgentProcess agentProcess = process;
                Intrinsics.checkNotNull((Object)agentProcess);
                AgentProcess p = agentProcess;
                Usage usage = p.usage();
                double totalCost = p.cost();
                int invocationCount = p.getLlmInvocations().size();
                Object[] objectArray = "%.6f";
                Object[] objectArray2 = new Object[]{totalCost};
                String string = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                String string2 = "%,d";
                objectArray = new Object[1];
                Integer n = usage.getPromptTokens();
                objectArray[0] = n != null ? n : 0;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                string2 = "%,d";
                objectArray = new Object[1];
                Integer n2 = usage.getCompletionTokens();
                objectArray[0] = n2 != null ? n2 : 0;
                String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                string2 = "%,d";
                objectArray = new Object[1];
                Integer n3 = usage.getPromptTokens();
                Integer n4 = usage.getCompletionTokens();
                objectArray[0] = (n3 != null ? n3 : 0) + (n4 != null ? n4 : 0);
                String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
                return Tool.Result.Companion.text(StringsKt.trimMargin$default((String)("\n                |Cost and Usage:\n                |\n                |Total cost: $" + string + "\n                |LLM invocations: " + invocationCount + "\n                |\n                |Tokens used:\n                |  Prompt tokens: " + string3 + "\n                |  Completion tokens: " + string4 + "\n                |  Total tokens: " + string5 + "\n                "), null, (int)1, null));
            }
        };
    }

    private final Tool createHistoryTool() {
        return new Tool(this){
            private final Tool.Definition definition;
            final /* synthetic */ AgentProcessTools this$0;
            {
                this.this$0 = $receiver;
                this.definition = Tool.Definition.Companion.invoke("process_history", "Get the history of actions taken in this process", Tool.InputSchema.Companion.empty());
            }

            public Tool.Definition getDefinition() {
                return this.definition;
            }

            /*
             * WARNING - void declaration
             */
            public Tool.Result call(String input) {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Tool.Result error;
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Pair pair = AgentProcessTools.access$getAgentProcessOrError(this.this$0);
                AgentProcess process = (AgentProcess)pair.component1();
                Tool.Result result = error = (Tool.Result)pair.component2();
                if (result != null) {
                    return result;
                }
                AgentProcess agentProcess = process;
                Intrinsics.checkNotNull((Object)agentProcess);
                AgentProcess p = agentProcess;
                List<ActionInvocation> history = p.getHistory();
                if (history.isEmpty()) {
                    return Tool.Result.Companion.text("No actions have been executed yet.");
                }
                Iterable iterable = history;
                AgentProcessTools agentProcessTools = this.this$0;
                boolean $i$f$mapIndexed = false;
                void var11_10 = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void action;
                    void index;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    ActionInvocation actionInvocation = (ActionInvocation)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((int)(index + true) + ". " + action.getActionName() + " (" + AgentProcessTools.access$formatDuration(agentProcessTools, action.getRunningTime()) + ")");
                }
                String historyText = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                return Tool.Result.Companion.text(StringsKt.trimMargin$default((String)("\n                |Action history (" + history.size() + " action(s)):\n                |\n                |" + historyText + "\n                "), null, (int)1, null));
            }
        };
    }

    private final Tool createToolStatsTool() {
        return new Tool(this){
            private final Tool.Definition definition;
            final /* synthetic */ AgentProcessTools this$0;
            {
                this.this$0 = $receiver;
                this.definition = Tool.Definition.Companion.invoke("process_tools_stats", "Get statistics about tool usage in this process", Tool.InputSchema.Companion.empty());
            }

            public Tool.Definition getDefinition() {
                return this.definition;
            }

            /*
             * WARNING - void declaration
             */
            public Tool.Result call(String input) {
                void $this$sortedByDescending$iv;
                Tool.Result error;
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Pair pair = AgentProcessTools.access$getAgentProcessOrError(this.this$0);
                AgentProcess process = (AgentProcess)pair.component1();
                Tool.Result result = error = (Tool.Result)pair.component2();
                if (result != null) {
                    return result;
                }
                AgentProcess agentProcess = process;
                Intrinsics.checkNotNull((Object)agentProcess);
                AgentProcess p = agentProcess;
                Map<String, ToolStats> stats = p.getToolsStats().getToolsStats();
                if (stats.isEmpty()) {
                    return Tool.Result.Companion.text("No tools have been called yet.");
                }
                Iterable iterable = stats.values();
                int n = 0;
                for (T t : iterable) {
                    void it;
                    ToolStats toolStats = (ToolStats)t;
                    int n2 = n;
                    boolean bl = false;
                    int n3 = it.getCalls();
                    n = n2 + n3;
                }
                int totalCalls = n;
                Iterable iterable2 = stats.values();
                boolean $i$f$sortedByDescending = false;
                String toolsSummary = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ToolStats it = (ToolStats)b;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getCalls());
                        it = (ToolStats)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getCalls()));
                    }
                }), (CharSequence)"\n", null, null, (int)0, null, createToolStatsTool.1::call$lambda$2, (int)30, null);
                return Tool.Result.Companion.text(StringsKt.trimMargin$default((String)("\n                |Tool Usage Statistics:\n                |\n                |Total tool calls: " + totalCalls + "\n                |Unique tools used: " + stats.size() + "\n                |\n                |Calls by tool:\n                |" + toolsSummary + "\n                "), null, (int)1, null));
            }

            private static final CharSequence call$lambda$2(ToolStats it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "  " + it.getName() + ": " + it.getCalls() + " calls";
            }
        };
    }

    private final Tool createModelsUsedTool() {
        return new Tool(this){
            private final Tool.Definition definition;
            final /* synthetic */ AgentProcessTools this$0;
            {
                this.this$0 = $receiver;
                this.definition = Tool.Definition.Companion.invoke("process_models", "Get information about which LLM models have been used", Tool.InputSchema.Companion.empty());
            }

            public Tool.Definition getDefinition() {
                return this.definition;
            }

            public Tool.Result call(String input) {
                Tool.Result error;
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Pair pair = AgentProcessTools.access$getAgentProcessOrError(this.this$0);
                AgentProcess process = (AgentProcess)pair.component1();
                Tool.Result result = error = (Tool.Result)pair.component2();
                if (result != null) {
                    return result;
                }
                AgentProcess agentProcess = process;
                Intrinsics.checkNotNull((Object)agentProcess);
                AgentProcess p = agentProcess;
                List models = p.modelsUsed();
                if (models.isEmpty()) {
                    return Tool.Result.Companion.text("No LLM models have been used yet.");
                }
                String modelsText = CollectionsKt.joinToString$default((Iterable)models, (CharSequence)"\n", null, null, (int)0, null, createModelsUsedTool.1::call$lambda$0, (int)30, null);
                return Tool.Result.Companion.text(StringsKt.trimMargin$default((String)("\n                |Models used (" + models.size() + "):\n                |\n                |" + modelsText + "\n                "), null, (int)1, null));
            }

            private static final CharSequence call$lambda$0(LlmMetadata model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                return "- " + model.getName() + " (" + model.getProvider() + ")";
            }
        };
    }

    public static final /* synthetic */ Pair access$getAgentProcessOrError(AgentProcessTools $this) {
        return $this.getAgentProcessOrError();
    }

    public static final /* synthetic */ String access$formatDuration(AgentProcessTools $this, Duration duration) {
        return $this.formatDuration(duration);
    }
}

