/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.math;

import com.embabel.agent.api.annotation.LlmTool;
import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.api.tool.ToolObject;
import com.embabel.agent.api.tool.progressive.UnfoldingTool;
import com.embabel.agent.core.CoreToolGroups;
import com.embabel.agent.core.ToolGroup;
import com.embabel.agent.core.ToolGroupDescription;
import com.embabel.agent.core.ToolGroupMetadata;
import com.embabel.agent.core.ToolGroupPermission;
import com.embabel.agent.core.support.SpringAiUtilsKt;
import com.embabel.common.core.types.AssetCoordinates;
import com.embabel.common.core.types.Semver;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u000f\u0018\u00002\u00020\u00012\u00020\u0002:\u0001:B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,J\u0016\u0010/\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,J\u0016\u00100\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,J\u0016\u00101\u001a\u00020\f2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,J\u0014\u00102\u001a\u00020,2\f\u00103\u001a\b\u0012\u0004\u0012\u00020,0\u001fJ\u0014\u00104\u001a\u00020,2\f\u00103\u001a\b\u0012\u0004\u0012\u00020,0\u001fJ\u0014\u00105\u001a\u00020,2\f\u00103\u001a\b\u0012\u0004\u0012\u00020,0\u001fJ\u000e\u00106\u001a\u00020,2\u0006\u00107\u001a\u00020,J\u000e\u00108\u001a\u00020,2\u0006\u00107\u001a\u00020,J\u000e\u00109\u001a\u00020,2\u0006\u00107\u001a\u00020,R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR!\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u001b\u0010%\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010$\u001a\u0004\b&\u0010'R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020 0\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\"\u00a8\u0006;"}, d2={"Lcom/embabel/agent/tools/math/MathTools;", "Lcom/embabel/agent/core/ToolGroup;", "Lcom/embabel/common/core/types/AssetCoordinates;", "<init>", "()V", "create", "Lcom/embabel/agent/api/tool/progressive/UnfoldingTool;", "groupDescription", "Lcom/embabel/agent/core/ToolGroupDescription;", "getGroupDescription", "()Lcom/embabel/agent/core/ToolGroupDescription;", "provider", "", "getProvider", "()Ljava/lang/String;", "version", "Lcom/embabel/common/core/types/Semver;", "getVersion-Id9oKnY", "Ljava/lang/String;", "name", "getName", "permissions", "", "Lcom/embabel/agent/core/ToolGroupPermission;", "getPermissions", "()Ljava/util/Set;", "metadata", "Lcom/embabel/agent/core/ToolGroupMetadata;", "getMetadata", "()Lcom/embabel/agent/core/ToolGroupMetadata;", "innerTools", "", "Lcom/embabel/agent/api/tool/Tool;", "getInnerTools", "()Ljava/util/List;", "innerTools$delegate", "Lkotlin/Lazy;", "unfoldingTool", "getUnfoldingTool", "()Lcom/embabel/agent/api/tool/progressive/UnfoldingTool;", "unfoldingTool$delegate", "tools", "getTools", "add", "", "a", "b", "subtract", "multiply", "divide", "mean", "numbers", "min", "max", "floor", "number", "ceiling", "round", "MathOperations", "embabel-agent-api"})
public final class MathTools
implements ToolGroup,
AssetCoordinates {
    @NotNull
    private final ToolGroupDescription groupDescription = CoreToolGroups.INSTANCE.getMATH_DESCRIPTION();
    @NotNull
    private final String provider;
    @NotNull
    private final String version = Semver.constructor-impl((int)0, (int)1, (int)0);
    @NotNull
    private final Set<ToolGroupPermission> permissions = SetsKt.emptySet();
    @NotNull
    private final Lazy innerTools$delegate = LazyKt.lazy(MathTools::innerTools_delegate$lambda$0);
    @NotNull
    private final Lazy unfoldingTool$delegate = LazyKt.lazy(() -> MathTools.unfoldingTool_delegate$lambda$1(this));

    public MathTools() {
        this.provider = "embabel";
    }

    @NotNull
    public final UnfoldingTool create() {
        return this.getUnfoldingTool();
    }

    @NotNull
    public final ToolGroupDescription getGroupDescription() {
        return this.groupDescription;
    }

    @NotNull
    public String getProvider() {
        return this.provider;
    }

    @NotNull
    public String getVersion-Id9oKnY() {
        return this.version;
    }

    @NotNull
    public String getName() {
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public final Set<ToolGroupPermission> getPermissions() {
        return this.permissions;
    }

    @Override
    @NotNull
    public ToolGroupMetadata getMetadata() {
        return ToolGroupMetadata.Companion.invoke-bYD-3ao(this.groupDescription, this.getName(), this.getProvider(), this.permissions, this.getVersion-Id9oKnY());
    }

    @NotNull
    public final List<Tool> getInnerTools() {
        Lazy lazy = this.innerTools$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final UnfoldingTool getUnfoldingTool() {
        Lazy lazy = this.unfoldingTool$delegate;
        return (UnfoldingTool)lazy.getValue();
    }

    @Override
    @NotNull
    public List<Tool> getTools() {
        return CollectionsKt.listOf((Object)this.getUnfoldingTool());
    }

    public final double add(double a, double b) {
        return a + b;
    }

    public final double subtract(double a, double b) {
        return a - b;
    }

    public final double multiply(double a, double b) {
        return a * b;
    }

    @NotNull
    public final String divide(double a, double b) {
        return b == 0.0 ? "Cannot divide by zero" : "" + a / b;
    }

    public final double mean(@NotNull List<Double> numbers) {
        Intrinsics.checkNotNullParameter(numbers, (String)"numbers");
        return numbers.isEmpty() ? 0.0 : CollectionsKt.sumOfDouble((Iterable)numbers) / (double)numbers.size();
    }

    public final double min(@NotNull List<Double> numbers) {
        Intrinsics.checkNotNullParameter(numbers, (String)"numbers");
        Double d = CollectionsKt.minOrNull((Iterable)numbers);
        return d != null ? d : Double.NaN;
    }

    public final double max(@NotNull List<Double> numbers) {
        Intrinsics.checkNotNullParameter(numbers, (String)"numbers");
        Double d = CollectionsKt.maxOrNull((Iterable)numbers);
        return d != null ? d : Double.NaN;
    }

    public final double floor(double number) {
        return Math.floor(number);
    }

    public final double ceiling(double number) {
        return Math.ceil(number);
    }

    public final double round(double number) {
        return Math.rint(number);
    }

    private static final List innerTools_delegate$lambda$0() {
        return SpringAiUtilsKt.safelyGetToolsFrom(new ToolObject(new MathOperations()));
    }

    private static final UnfoldingTool unfoldingTool_delegate$lambda$1(MathTools this$0) {
        return UnfoldingTool.Factory.of$default(UnfoldingTool.Companion, "math", "Mathematical operations. Invoke to see available operations including arithmetic, statistics, and rounding functions.", this$0.getInnerTools(), false, "Use add/subtract/multiply/divide for basic arithmetic. Use mean/min/max for statistics on lists. Use floor/ceiling/round for rounding.", 8, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007J\u0016\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0007J\u0016\u0010\u000f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0007J\u0016\u0010\u0010\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0007J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/embabel/agent/tools/math/MathTools$MathOperations;", "", "<init>", "()V", "add", "", "a", "b", "subtract", "multiply", "divide", "", "mean", "numbers", "", "min", "max", "floor", "number", "ceiling", "round", "embabel-agent-api"})
    private static final class MathOperations {
        @LlmTool(description="add two numbers")
        public final double add(double a, double b) {
            return a + b;
        }

        @LlmTool(description="subtract the second number from the first")
        public final double subtract(double a, double b) {
            return a - b;
        }

        @LlmTool(description="multiply two numbers")
        public final double multiply(double a, double b) {
            return a * b;
        }

        @LlmTool(description="divide the first number by the second")
        @NotNull
        public final String divide(double a, double b) {
            return b == 0.0 ? "Cannot divide by zero" : "" + a / b;
        }

        @LlmTool(description="find the mean of this list of numbers")
        public final double mean(@NotNull List<Double> numbers) {
            Intrinsics.checkNotNullParameter(numbers, (String)"numbers");
            return numbers.isEmpty() ? 0.0 : CollectionsKt.sumOfDouble((Iterable)numbers) / (double)numbers.size();
        }

        @LlmTool(description="find the minimum value in a list of numbers")
        public final double min(@NotNull List<Double> numbers) {
            Intrinsics.checkNotNullParameter(numbers, (String)"numbers");
            Double d = CollectionsKt.minOrNull((Iterable)numbers);
            return d != null ? d : Double.NaN;
        }

        @LlmTool(description="find the maximum value in a list of numbers")
        public final double max(@NotNull List<Double> numbers) {
            Intrinsics.checkNotNullParameter(numbers, (String)"numbers");
            Double d = CollectionsKt.maxOrNull((Iterable)numbers);
            return d != null ? d : Double.NaN;
        }

        @LlmTool(description="round down to the nearest integer")
        public final double floor(double number) {
            return Math.floor(number);
        }

        @LlmTool(description="round up to the nearest integer")
        public final double ceiling(double number) {
            return Math.ceil(number);
        }

        @LlmTool(description="round to the nearest integer")
        public final double round(double number) {
            return Math.rint(number);
        }
    }
}

