/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.blackboard;

import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.api.tool.progressive.UnfoldingTool;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.Blackboard;
import com.embabel.agent.core.BlackboardKt;
import com.embabel.chat.agent.BlackboardEntryFormatter;
import com.embabel.chat.agent.DefaultBlackboardEntryFormatter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\u001e\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/embabel/agent/tools/blackboard/BlackboardTools;", "", "<init>", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "create", "Lcom/embabel/agent/api/tool/progressive/UnfoldingTool;", "entryFormatter", "Lcom/embabel/chat/agent/BlackboardEntryFormatter;", "getBlackboardOrError", "Lkotlin/Pair;", "Lcom/embabel/agent/core/Blackboard;", "Lcom/embabel/agent/api/tool/Tool$Result;", "createListTool", "Lcom/embabel/agent/api/tool/Tool;", "createGetTool", "createLastTool", "createDescribeTool", "createCountTool", "parseParams", "", "", "input", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nBlackboardTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlackboardTools.kt\ncom/embabel/agent/tools/blackboard/BlackboardTools\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n116#2:227\n54#2:228\n117#2:229\n61#2,8:230\n71#2:239\n1#3:238\n*S KotlinDebug\n*F\n+ 1 BlackboardTools.kt\ncom/embabel/agent/tools/blackboard/BlackboardTools\n*L\n220#1:227\n220#1:228\n220#1:229\n220#1:230,8\n220#1:239\n220#1:238\n*E\n"})
public final class BlackboardTools {
    @NotNull
    private final ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();

    @JvmOverloads
    @NotNull
    public final UnfoldingTool create(@NotNull BlackboardEntryFormatter entryFormatter) {
        Intrinsics.checkNotNullParameter((Object)entryFormatter, (String)"entryFormatter");
        Object[] objectArray = new Tool[]{this.createListTool(), this.createGetTool(entryFormatter), this.createLastTool(entryFormatter), this.createDescribeTool(entryFormatter), this.createCountTool()};
        return UnfoldingTool.Factory.of$default(UnfoldingTool.Companion, "blackboard", "Access objects in the current process context. Invoke to see available operations for listing, getting, and describing objects.", CollectionsKt.listOf((Object[])objectArray), false, "Use blackboard_list to see what's available. Use blackboard_get for named bindings, blackboard_last for the most recent of a type.", 8, null);
    }

    public static /* synthetic */ UnfoldingTool create$default(BlackboardTools blackboardTools, BlackboardEntryFormatter blackboardEntryFormatter, int n, Object object) {
        if ((n & 1) != 0) {
            blackboardEntryFormatter = DefaultBlackboardEntryFormatter.INSTANCE;
        }
        return blackboardTools.create(blackboardEntryFormatter);
    }

    private final Pair<Blackboard, Tool.Result> getBlackboardOrError() {
        AgentProcess agentProcess = AgentProcess.Companion.get();
        if (agentProcess == null) {
            return TuplesKt.to(null, (Object)Tool.Result.Companion.text("No agent process available. Blackboard tools require an active agent context."));
        }
        AgentProcess agentProcess2 = agentProcess;
        return TuplesKt.to((Object)agentProcess2.getBlackboard(), null);
    }

    private final Tool createListTool() {
        return new Tool(this){
            private final Tool.Definition definition;
            final /* synthetic */ BlackboardTools this$0;
            {
                this.this$0 = $receiver;
                this.definition = Tool.Definition.Companion.invoke("blackboard_list", "List all objects currently in the blackboard with their types and indices", Tool.InputSchema.Companion.empty());
            }

            public Tool.Definition getDefinition() {
                return this.definition;
            }

            /*
             * WARNING - void declaration
             */
            public Tool.Result call(String input) {
                void $this$mapIndexedTo$iv$iv;
                Tool.Result error;
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Pair pair = BlackboardTools.access$getBlackboardOrError(this.this$0);
                Blackboard blackboard = (Blackboard)pair.component1();
                Tool.Result result = error = (Tool.Result)pair.component2();
                if (result != null) {
                    return result;
                }
                Blackboard blackboard2 = blackboard;
                Intrinsics.checkNotNull((Object)blackboard2);
                List<Object> objects = blackboard2.getObjects();
                if (objects.isEmpty()) {
                    return Tool.Result.Companion.text("Blackboard is empty - no objects available.");
                }
                Iterable $this$mapIndexed$iv = objects;
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void index;
                    void obj;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    T t = item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = Reflection.getOrCreateKotlinClass(obj.getClass()).getSimpleName();
                    if (string == null) {
                        string = obj.getClass().getName();
                    }
                    String typeName = string;
                    collection.add("[" + (int)index + "] " + typeName);
                }
                String listing = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                return Tool.Result.Companion.text("Blackboard contains " + objects.size() + " object(s):\n" + listing);
            }
        };
    }

    private final Tool createGetTool(BlackboardEntryFormatter entryFormatter) {
        return new Tool(this, entryFormatter){
            private final Tool.Definition definition;
            final /* synthetic */ BlackboardTools this$0;
            final /* synthetic */ BlackboardEntryFormatter $entryFormatter;
            {
                this.this$0 = $receiver;
                this.$entryFormatter = $entryFormatter;
                Tool.Parameter[] parameterArray = new Tool.Parameter[]{Tool.Parameter.Companion.string$default(Tool.Parameter.Companion, "name", "The binding name to look up", true, null, 8, null)};
                this.definition = Tool.Definition.Companion.invoke("blackboard_get", "Get an object by its binding name", Tool.InputSchema.Companion.of(parameterArray));
            }

            public Tool.Definition getDefinition() {
                return this.definition;
            }

            public Tool.Result call(String input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Pair pair = BlackboardTools.access$getBlackboardOrError(this.this$0);
                Blackboard blackboard = (Blackboard)pair.component1();
                Tool.Result error = (Tool.Result)pair.component2();
                if (error != null) {
                    return error;
                }
                Map params = BlackboardTools.access$parseParams(this.this$0, input);
                V v = params.get("name");
                String string = v instanceof String ? (String)v : null;
                if (string == null) {
                    return Tool.Result.Companion.text("Missing required parameter: name");
                }
                String name = string;
                Blackboard blackboard2 = blackboard;
                Intrinsics.checkNotNull((Object)blackboard2);
                Object value = blackboard2.get(name);
                if (value == null) {
                    return Tool.Result.Companion.text("No object found with binding name '" + name + "'");
                }
                String formatted = this.$entryFormatter.format(value);
                String string2 = Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName();
                if (string2 == null) {
                    string2 = value.getClass().getName();
                }
                String typeName = string2;
                return Tool.Result.Companion.text(typeName + " bound to '" + name + "':\n" + formatted);
            }
        };
    }

    private final Tool createLastTool(BlackboardEntryFormatter entryFormatter) {
        return new Tool(this, entryFormatter){
            private final Tool.Definition definition;
            final /* synthetic */ BlackboardTools this$0;
            final /* synthetic */ BlackboardEntryFormatter $entryFormatter;
            {
                this.this$0 = $receiver;
                this.$entryFormatter = $entryFormatter;
                Tool.Parameter[] parameterArray = new Tool.Parameter[]{Tool.Parameter.Companion.string$default(Tool.Parameter.Companion, "typeName", "The type name (e.g., 'User' or 'com.example.User')", true, null, 8, null)};
                this.definition = Tool.Definition.Companion.invoke("blackboard_last", "Get the most recent object of a given type. Matches by simple class name or fully qualified name.", Tool.InputSchema.Companion.of(parameterArray));
            }

            public Tool.Definition getDefinition() {
                return this.definition;
            }

            public Tool.Result call(String input) {
                Object last;
                String typeName;
                block5: {
                    Object object;
                    Tool.Result error;
                    Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                    Pair pair = BlackboardTools.access$getBlackboardOrError(this.this$0);
                    Blackboard blackboard = (Blackboard)pair.component1();
                    Tool.Result result = error = (Tool.Result)pair.component2();
                    if (result != null) {
                        return result;
                    }
                    Map params = BlackboardTools.access$parseParams(this.this$0, input);
                    V v = params.get("typeName");
                    String string = v instanceof String ? (String)v : null;
                    if (string == null) {
                        return Tool.Result.Companion.text("Missing required parameter: typeName");
                    }
                    typeName = string;
                    Blackboard blackboard2 = blackboard;
                    Intrinsics.checkNotNull((Object)blackboard2);
                    List<Object> $this$lastOrNull$iv = blackboard2.getObjects();
                    boolean $i$f$lastOrNull = false;
                    ListIterator<Object> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv;
                        Object it = element$iv = iterator$iv.previous();
                        boolean bl = false;
                        if (!BlackboardKt.satisfiesType(it, typeName)) continue;
                        object = element$iv;
                        break block5;
                    }
                    object = last = null;
                }
                if (last == null) {
                    return Tool.Result.Companion.text("No object of type '" + typeName + "' found in blackboard");
                }
                String formatted = this.$entryFormatter.format(last);
                String string = Reflection.getOrCreateKotlinClass(last.getClass()).getSimpleName();
                if (string == null) {
                    string = last.getClass().getName();
                }
                String actualType = string;
                return Tool.Result.Companion.text("Last " + actualType + ":\n" + formatted);
            }
        };
    }

    private final Tool createDescribeTool(BlackboardEntryFormatter entryFormatter) {
        return new Tool(this, entryFormatter){
            private final Tool.Definition definition;
            final /* synthetic */ BlackboardTools this$0;
            final /* synthetic */ BlackboardEntryFormatter $entryFormatter;
            {
                this.this$0 = $receiver;
                this.$entryFormatter = $entryFormatter;
                Tool.Parameter[] parameterArray = new Tool.Parameter[]{Tool.Parameter.Companion.string$default(Tool.Parameter.Companion, "name", "The binding name of the object to describe", true, null, 8, null)};
                this.definition = Tool.Definition.Companion.invoke("blackboard_describe", "Get a detailed description/formatting of an object by its binding name", Tool.InputSchema.Companion.of(parameterArray));
            }

            public Tool.Definition getDefinition() {
                return this.definition;
            }

            public Tool.Result call(String input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Pair pair = BlackboardTools.access$getBlackboardOrError(this.this$0);
                Blackboard blackboard = (Blackboard)pair.component1();
                Tool.Result error = (Tool.Result)pair.component2();
                if (error != null) {
                    return error;
                }
                Map params = BlackboardTools.access$parseParams(this.this$0, input);
                V v = params.get("name");
                String string = v instanceof String ? (String)v : null;
                if (string == null) {
                    return Tool.Result.Companion.text("Missing required parameter: name");
                }
                String name = string;
                Blackboard blackboard2 = blackboard;
                Intrinsics.checkNotNull((Object)blackboard2);
                Object value = blackboard2.get(name);
                if (value == null) {
                    return Tool.Result.Companion.text("No object found with binding name '" + name + "'");
                }
                String formatted = this.$entryFormatter.format(value);
                String string2 = Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName();
                if (string2 == null) {
                    string2 = value.getClass().getName();
                }
                String typeName = string2;
                return Tool.Result.Companion.text("Description of " + typeName + " '" + name + "':\n" + formatted);
            }
        };
    }

    private final Tool createCountTool() {
        return new Tool(this){
            private final Tool.Definition definition;
            final /* synthetic */ BlackboardTools this$0;
            {
                this.this$0 = $receiver;
                Tool.Parameter[] parameterArray = new Tool.Parameter[]{Tool.Parameter.Companion.string$default(Tool.Parameter.Companion, "typeName", "The type name to count (e.g., 'User' or 'com.example.User')", true, null, 8, null)};
                this.definition = Tool.Definition.Companion.invoke("blackboard_count", "Count the number of objects of a given type in the blackboard", Tool.InputSchema.Companion.of(parameterArray));
            }

            public Tool.Definition getDefinition() {
                return this.definition;
            }

            public Tool.Result call(String input) {
                int n;
                Tool.Result error;
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Pair pair = BlackboardTools.access$getBlackboardOrError(this.this$0);
                Blackboard blackboard = (Blackboard)pair.component1();
                Tool.Result result = error = (Tool.Result)pair.component2();
                if (result != null) {
                    return result;
                }
                Map params = BlackboardTools.access$parseParams(this.this$0, input);
                V v = params.get("typeName");
                String string = v instanceof String ? (String)v : null;
                if (string == null) {
                    return Tool.Result.Companion.text("Missing required parameter: typeName");
                }
                String typeName = string;
                Blackboard blackboard2 = blackboard;
                Intrinsics.checkNotNull((Object)blackboard2);
                Iterable $this$count$iv = blackboard2.getObjects();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    Iterator<T> iterator = $this$count$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv;
                        T it = element$iv = iterator.next();
                        boolean bl = false;
                        if (!BlackboardKt.satisfiesType(it, typeName) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int count = n;
                return Tool.Result.Companion.text("Found " + count + " object(s) of type '" + typeName + "' in blackboard");
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> parseParams(String input) {
        Map map;
        if (StringsKt.isBlank((CharSequence)input)) {
            return MapsKt.emptyMap();
        }
        try {
            void $this$checkTypeMismatch$iv$iv;
            ObjectMapper $this$readValue$iv = this.objectMapper;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef22 = false;
            Object $i$f$jacksonTypeRef22 = $this$readValue$iv.readValue(input, (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
            boolean $i$f$checkTypeMismatch = false;
            if (!($this$checkTypeMismatch$iv$iv instanceof Map)) {
                String string;
                String nullability$iv$iv = "(non-null)";
                StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(Map.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
                void v1 = $this$checkTypeMismatch$iv$iv;
                if (v1 != null) {
                    void it$iv$iv;
                    void var7_9 = v1;
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl = false;
                    string = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                    stringBuilder = stringBuilder2;
                } else {
                    string = null;
                }
                String string2 = stringBuilder.append(string).toString();
                throw new RuntimeJsonMappingException(string2);
            }
            map = (Map)$this$checkTypeMismatch$iv$iv;
        }
        catch (Exception e) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @JvmOverloads
    @NotNull
    public final UnfoldingTool create() {
        return BlackboardTools.create$default(this, null, 1, null);
    }

    public static final /* synthetic */ Pair access$getBlackboardOrError(BlackboardTools $this) {
        return $this.getBlackboardOrError();
    }

    public static final /* synthetic */ Map access$parseParams(BlackboardTools $this, String input) {
        return $this.parseParams(input);
    }
}

