/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.validation;

import com.embabel.agent.spi.validation.ValidationPromptGenerator;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\"\u0010\n\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u000e0\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/embabel/agent/spi/validation/DefaultValidationPromptGenerator;", "Lcom/embabel/agent/spi/validation/ValidationPromptGenerator;", "<init>", "()V", "generateRequirementsPrompt", "", "validator", "Ljakarta/validation/Validator;", "outputClass", "Ljava/lang/Class;", "generateViolationsReport", "T", "violations", "", "Ljakarta/validation/ConstraintViolation;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nDefaultValidationPromptGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultValidationPromptGenerator.kt\ncom/embabel/agent/spi/validation/DefaultValidationPromptGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1863#2:70\n1863#2,2:71\n1864#2:73\n1557#2:74\n1628#2,3:75\n*S KotlinDebug\n*F\n+ 1 DefaultValidationPromptGenerator.kt\ncom/embabel/agent/spi/validation/DefaultValidationPromptGenerator\n*L\n30#1:70\n34#1:71,2\n30#1:73\n58#1:74\n58#1:75,3\n*E\n"})
public final class DefaultValidationPromptGenerator
implements ValidationPromptGenerator {
    @Override
    @NotNull
    public String generateRequirementsPrompt(@NotNull Validator validator, @NotNull Class<?> outputClass) {
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        BeanDescriptor descriptor = validator.getConstraintsForClass(outputClass);
        List requirements = new ArrayList();
        Set set = descriptor.getConstrainedProperties();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getConstrainedProperties(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)element$iv;
            boolean bl = false;
            String propertyName = propertyDescriptor.getPropertyName();
            Set constraints = propertyDescriptor.getConstraintDescriptors();
            Intrinsics.checkNotNull((Object)constraints);
            Iterable $this$forEach$iv2 = constraints;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ConstraintDescriptor constraint = (ConstraintDescriptor)element$iv2;
                boolean bl2 = false;
                String annotationType = JvmClassMappingKt.getAnnotationClass((Annotation)constraint.getAnnotation()).getSimpleName();
                String message = constraint.getMessageTemplate();
                requirements.add("- Field '" + propertyName + "': " + annotationType + " constraint (" + message + ")");
            }
        }
        return requirements.isEmpty() ? "No validation constraints defined." : "Validation Requirements:\n" + CollectionsKt.joinToString$default((Iterable)requirements, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> String generateViolationsReport(@NotNull Set<? extends ConstraintViolation<T>> violations) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(violations, (String)"violations");
        if (violations.isEmpty()) {
            return "No validation violations.";
        }
        Iterable $this$map$iv = violations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void violation;
            ConstraintViolation constraintViolation = (ConstraintViolation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String propertyPath = violation.getPropertyPath().toString();
            Object invalidValue = violation.getInvalidValue();
            String message = violation.getMessage();
            collection.add("- Field '" + propertyPath + "' with value '" + invalidValue + "': " + message);
        }
        List violationMessages = (List)destination$iv$iv;
        return "Validation Violations:\n" + CollectionsKt.joinToString$default((Iterable)violationMessages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }
}

