/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support.springai;

import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.core.Usage;
import com.embabel.agent.core.support.SpringAiUtilsKt;
import com.embabel.agent.spi.loop.LlmMessageResponse;
import com.embabel.agent.spi.loop.LlmMessageSender;
import com.embabel.agent.spi.support.springai.MessageConvertersKt;
import com.embabel.agent.spi.support.springai.SpringToolCallbackAdapterKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/embabel/agent/spi/support/springai/SpringAiLlmMessageSender;", "Lcom/embabel/agent/spi/loop/LlmMessageSender;", "chatModel", "Lorg/springframework/ai/chat/model/ChatModel;", "chatOptions", "Lorg/springframework/ai/chat/prompt/ChatOptions;", "<init>", "(Lorg/springframework/ai/chat/model/ChatModel;Lorg/springframework/ai/chat/prompt/ChatOptions;)V", "logger", "Lorg/slf4j/Logger;", "call", "Lcom/embabel/agent/spi/loop/LlmMessageResponse;", "messages", "", "Lcom/embabel/chat/Message;", "tools", "Lcom/embabel/agent/api/tool/Tool;", "findGenerationWithToolCalls", "Lorg/springframework/ai/chat/messages/AssistantMessage;", "response", "Lorg/springframework/ai/chat/model/ChatResponse;", "buildChatOptionsWithTools", "toolCallbacks", "Lorg/springframework/ai/tool/ToolCallback;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nSpringAiLlmMessageSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringAiLlmMessageSender.kt\ncom/embabel/agent/spi/support/springai/SpringAiLlmMessageSender\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n27#2:162\n1557#3:163\n1628#3,3:164\n1557#3:167\n1628#3,3:168\n1368#3:171\n1454#3,5:172\n1611#3,9:177\n1863#3:186\n1864#3:189\n1620#3:190\n1782#3,4:191\n1782#3,4:195\n1#4:187\n1#4:188\n*S KotlinDebug\n*F\n+ 1 SpringAiLlmMessageSender.kt\ncom/embabel/agent/spi/support/springai/SpringAiLlmMessageSender\n*L\n45#1:162\n52#1:163\n52#1:164,3\n103#1:167\n103#1:168,3\n107#1:171\n107#1:172,5\n115#1:177,9\n115#1:186\n115#1:189\n115#1:190\n119#1:191,4\n120#1:195,4\n115#1:188\n*E\n"})
public final class SpringAiLlmMessageSender
implements LlmMessageSender {
    @NotNull
    private final ChatModel chatModel;
    @NotNull
    private final ChatOptions chatOptions;
    @NotNull
    private final Logger logger;

    public SpringAiLlmMessageSender(@NotNull ChatModel chatModel, @NotNull ChatOptions chatOptions) {
        Intrinsics.checkNotNullParameter((Object)chatModel, (String)"chatModel");
        Intrinsics.checkNotNullParameter((Object)chatOptions, (String)"chatOptions");
        this.chatModel = chatModel;
        this.chatOptions = chatOptions;
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(SpringAiLlmMessageSender.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LlmMessageResponse call(@NotNull List<? extends com.embabel.chat.Message> messages, @NotNull List<? extends Tool> tools) {
        Usage usage;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter(tools, (String)"tools");
        Iterable $this$map$iv = messages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            com.embabel.chat.Message message = (com.embabel.chat.Message)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MessageConvertersKt.toSpringAiMessage((com.embabel.chat.Message)it));
        }
        List<Message> springAiMessages = MessageConvertersKt.mergeConsecutiveToolResponses((List)destination$iv$iv);
        List<ToolCallback> toolCallbacks = SpringToolCallbackAdapterKt.toSpringToolCallbacks(tools);
        Prompt prompt = new Prompt(springAiMessages, this.buildChatOptionsWithTools(toolCallbacks));
        ChatResponse chatResponse = this.chatModel.call(prompt);
        Intrinsics.checkNotNullExpressionValue((Object)chatResponse, (String)"call(...)");
        ChatResponse response = chatResponse;
        this.logger.debug("Prompt: {}\nResponse: {}", (Object)prompt, (Object)response);
        AssistantMessage assistantMessage = this.findGenerationWithToolCalls(response);
        if (assistantMessage == null) {
            AssistantMessage assistantMessage2 = response.getResult().getOutput();
            assistantMessage = assistantMessage2;
            Intrinsics.checkNotNullExpressionValue((Object)assistantMessage2, (String)"getOutput(...)");
        }
        AssistantMessage assistantMessage3 = assistantMessage;
        com.embabel.chat.Message embabelMessage = MessageConvertersKt.toEmbabelMessage(assistantMessage3);
        ChatResponseMetadata chatResponseMetadata = response.getMetadata();
        Usage usage2 = usage = chatResponseMetadata != null && (chatResponseMetadata = chatResponseMetadata.getUsage()) != null ? SpringAiUtilsKt.toEmbabelUsage((org.springframework.ai.chat.metadata.Usage)chatResponseMetadata) : null;
        String string = assistantMessage3.getText();
        if (string == null) {
            string = "";
        }
        return new LlmMessageResponse(embabelMessage, string, usage);
    }

    /*
     * WARNING - void declaration
     */
    private final AssistantMessage findGenerationWithToolCalls(ChatResponse response) {
        int generationsWithText;
        int n;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$mapTo$iv$iv;
        List list = response.getResults();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResults(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Generation generation = (Generation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOutput());
        }
        List allOutputs = (List)destination$iv$iv;
        Iterable $i$f$map22 = allOutputs;
        boolean $i$f$flatMap22 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            AssistantMessage it = (AssistantMessage)element$iv$iv;
            boolean bl = false;
            List list2 = it.getToolCalls();
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List allToolCalls = (List)destination$iv$iv2;
        if (allToolCalls.isEmpty()) {
            return null;
        }
        Iterable $i$f$flatMap22 = allOutputs;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            String string;
            Object element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            AssistantMessage it = (AssistantMessage)element$iv$iv;
            boolean bl2 = false;
            if (it.getText() != null) {
                String string2;
                String text = string2;
                boolean bl3 = false;
                string = !StringsKt.isBlank((CharSequence)text) ? string2 : null;
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl4 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        String allText = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv3), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        Iterable $this$count$iv = allOutputs;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Object element$iv$iv$iv;
                AssistantMessage it = (AssistantMessage)element$iv;
                boolean bl = false;
                element$iv$iv$iv = it.getToolCalls();
                if (!(!(element$iv$iv$iv == null || element$iv$iv$iv.isEmpty())) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int generationsWithToolCalls = n;
        Iterable $this$count$iv2 = allOutputs;
        boolean $i$f$count2 = false;
        if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
            v4 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv2) {
                AssistantMessage it = (AssistantMessage)element$iv;
                boolean bl = false;
                CharSequence charSequence = it.getText();
                if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v4 = generationsWithText = count$iv;
        }
        if (generationsWithToolCalls > 1 || generationsWithText > 1) {
            this.logger.debug("Merging content from multiple generations: {} with tool calls, {} with text", (Object)generationsWithToolCalls, (Object)generationsWithText);
        }
        return AssistantMessage.builder().content(allText).toolCalls(allToolCalls).build();
    }

    private final ChatOptions buildChatOptionsWithTools(List<? extends ToolCallback> toolCallbacks) {
        if (toolCallbacks.isEmpty()) {
            return this.chatOptions;
        }
        ToolCallingChatOptions toolCallingChatOptions = ToolCallingChatOptions.builder().model(this.chatOptions.getModel()).temperature(this.chatOptions.getTemperature()).maxTokens(this.chatOptions.getMaxTokens()).topP(this.chatOptions.getTopP()).topK(this.chatOptions.getTopK()).frequencyPenalty(this.chatOptions.getFrequencyPenalty()).presencePenalty(this.chatOptions.getPresencePenalty()).stopSequences(this.chatOptions.getStopSequences()).toolCallbacks(toolCallbacks).internalToolExecutionEnabled(Boolean.valueOf(false)).build();
        Intrinsics.checkNotNullExpressionValue((Object)toolCallingChatOptions, (String)"build(...)");
        return (ChatOptions)toolCallingChatOptions;
    }
}

