/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support.springai;

import com.embabel.agent.api.event.LlmRequestEvent;
import com.embabel.agent.spi.support.springai.ChatModelCallEventKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import reactor.core.publisher.Flux;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/embabel/agent/spi/support/springai/InstrumentedChatModel;", "Lorg/springframework/ai/chat/model/ChatModel;", "delegate", "llmRequestEvent", "Lcom/embabel/agent/api/event/LlmRequestEvent;", "<init>", "(Lorg/springframework/ai/chat/model/ChatModel;Lcom/embabel/agent/api/event/LlmRequestEvent;)V", "logger", "Lorg/slf4j/Logger;", "call", "Lorg/springframework/ai/chat/model/ChatResponse;", "prompt", "Lorg/springframework/ai/chat/prompt/Prompt;", "getDefaultOptions", "Lorg/springframework/ai/chat/prompt/ChatOptions;", "stream", "Lreactor/core/publisher/Flux;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nInstrumentedChatModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstrumentedChatModel.kt\ncom/embabel/agent/spi/support/springai/InstrumentedChatModel\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,99:1\n27#2:100\n*S KotlinDebug\n*F\n+ 1 InstrumentedChatModel.kt\ncom/embabel/agent/spi/support/springai/InstrumentedChatModel\n*L\n57#1:100\n*E\n"})
public final class InstrumentedChatModel
implements ChatModel {
    @NotNull
    private final ChatModel delegate;
    @NotNull
    private final LlmRequestEvent<?> llmRequestEvent;
    @NotNull
    private final Logger logger;

    public InstrumentedChatModel(@NotNull ChatModel delegate, @NotNull LlmRequestEvent<?> llmRequestEvent) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(llmRequestEvent, (String)"llmRequestEvent");
        this.delegate = delegate;
        this.llmRequestEvent = llmRequestEvent;
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(InstrumentedChatModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public ChatResponse call(@NotNull Prompt prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Object[] objectArray = new Object[3];
        objectArray[0] = this.llmRequestEvent.getInteraction().getId-Ti10f1E();
        objectArray[1] = prompt.getInstructions().size();
        Object object = prompt.getOptions();
        if (object == null || (object = object.getClass()) == null || (object = ((Class)object).getSimpleName()) == null) {
            object = "none";
        }
        objectArray[2] = object;
        this.logger.debug("Intercepted ChatModel.call for interaction '{}' \u2014 {} messages, options: {}", objectArray);
        this.llmRequestEvent.getAgentProcess().getProcessContext().onProcessEvent(ChatModelCallEventKt.chatModelCallEvent(this.llmRequestEvent, prompt));
        ChatResponse chatResponse = this.delegate.call(prompt);
        Intrinsics.checkNotNullExpressionValue((Object)chatResponse, (String)"call(...)");
        return chatResponse;
    }

    @NotNull
    public ChatOptions getDefaultOptions() {
        ChatOptions chatOptions = this.delegate.getDefaultOptions();
        Intrinsics.checkNotNullExpressionValue((Object)chatOptions, (String)"getDefaultOptions(...)");
        return chatOptions;
    }

    @NotNull
    public Flux<ChatResponse> stream(@NotNull Prompt prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Flux flux = this.delegate.stream(prompt);
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"stream(...)");
        return flux;
    }
}

