/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support;

import com.embabel.agent.api.common.InteractionId;
import com.embabel.agent.api.common.ranking.Ranker;
import com.embabel.agent.api.common.ranking.Ranking;
import com.embabel.agent.api.common.ranking.Rankings;
import com.embabel.agent.core.internal.LlmOperations;
import com.embabel.agent.core.support.LlmInteraction;
import com.embabel.agent.spi.support.RankedChoiceResponse;
import com.embabel.agent.spi.support.RankingProperties;
import com.embabel.agent.spi.support.RankingsResponse;
import com.embabel.common.ai.model.LlmOptions;
import com.embabel.common.ai.model.ModelSelectionCriteria;
import com.embabel.common.core.types.Described;
import com.embabel.common.core.types.Named;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.RetryContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J:\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\f\b\u0000\u0010\u0010*\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0017H\u0016J:\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\f\b\u0000\u0010\u0010*\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/embabel/agent/spi/support/LlmRanker;", "Lcom/embabel/agent/api/common/ranking/Ranker;", "llmOperations", "Lcom/embabel/agent/core/internal/LlmOperations;", "rankingProperties", "Lcom/embabel/agent/spi/support/RankingProperties;", "<init>", "(Lcom/embabel/agent/core/internal/LlmOperations;Lcom/embabel/agent/spi/support/RankingProperties;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "llm", "Lcom/embabel/common/ai/model/LlmOptions;", "rank", "Lcom/embabel/agent/api/common/ranking/Rankings;", "T", "Lcom/embabel/common/core/types/Named;", "Lcom/embabel/common/core/types/Described;", "description", "", "userInput", "rankables", "", "rankThingsInternal", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nLlmRanker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LlmRanker.kt\ncom/embabel/agent/spi/support/LlmRanker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1557#2:157\n1628#2,3:158\n2632#2,3:162\n1557#2:165\n1628#2,3:166\n1557#2:169\n1628#2,2:170\n626#2,12:172\n1630#2:184\n1053#2:185\n1#3:161\n*S KotlinDebug\n*F\n+ 1 LlmRanker.kt\ncom/embabel/agent/spi/support/LlmRanker\n*L\n123#1:157\n123#1:158,3\n125#1:162,3\n129#1:165\n129#1:166,3\n135#1:169\n135#1:170,2\n137#1:172,12\n135#1:184\n140#1:185\n*E\n"})
public final class LlmRanker
implements Ranker {
    @NotNull
    private final LlmOperations llmOperations;
    @NotNull
    private final RankingProperties rankingProperties;
    private final Logger logger;
    @NotNull
    private final LlmOptions llm;

    public LlmRanker(@NotNull LlmOperations llmOperations, @NotNull RankingProperties rankingProperties) {
        ModelSelectionCriteria modelSelectionCriteria;
        Intrinsics.checkNotNullParameter((Object)llmOperations, (String)"llmOperations");
        Intrinsics.checkNotNullParameter((Object)rankingProperties, (String)"rankingProperties");
        this.llmOperations = llmOperations;
        this.rankingProperties = rankingProperties;
        this.logger = LoggerFactory.getLogger(this.getClass());
        if (this.rankingProperties.getLlm() != null) {
            this.logger.info("Using LLM '{}' for ranking", (Object)this.rankingProperties.getLlm());
            modelSelectionCriteria = ModelSelectionCriteria.Companion.byName(this.rankingProperties.getLlm());
        } else {
            this.logger.info("Using auto LLM for ranking");
            modelSelectionCriteria = ModelSelectionCriteria.Companion.getAuto();
        }
        this.llm = LlmOptions.Companion.invoke(modelSelectionCriteria);
    }

    @Override
    @NotNull
    public <T extends Named & Described> Rankings<T> rank(@NotNull String description, @NotNull String userInput, @NotNull Collection<? extends T> rankables) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)userInput, (String)"userInput");
        Intrinsics.checkNotNullParameter(rankables, (String)"rankables");
        if (rankables.isEmpty()) {
            return new Rankings(CollectionsKt.emptyList());
        }
        Object object = this.rankingProperties.retryTemplate("ranker").execute(arg_0 -> LlmRanker.rank$lambda$0(this, description, userInput, rankables, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"execute(...)");
        return (Rankings)object;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends Named & Described> Rankings<T> rankThingsInternal(String description, String userInput, Collection<? extends T> rankables) {
        void $this$sortedBy$iv;
        Iterable $this$mapTo$iv$iv;
        Object v2;
        List thingNames;
        Object destination$iv$iv;
        RankingsResponse rankingResponse;
        Object type2;
        block13: {
            Iterable $this$mapTo$iv$iv2;
            Object object = (Named)CollectionsKt.firstOrNull((Iterable)rankables);
            if (object == null || (object = object.getClass()) == null || (object = ((Class)object).getSimpleName()) == null) {
                throw new IllegalArgumentException("Rankables must not be empty");
            }
            type2 = object;
            String prompt = StringsKt.trimIndent((String)("\n            Your job is rank objects of type " + (String)type2 + " (" + description + ") based on user input.\n            Given the user input, choose the name that best reflects the user's intent.\n\n            User input: <" + userInput + ">\n\n            Available choices, in format <name>: <description>:\n            " + CollectionsKt.joinToString$default((Iterable)rankables, (CharSequence)"\n", null, null, (int)0, null, LlmRanker::rankThingsInternal$lambda$1, (int)30, null) + "\n\n            Return the name of the chosen " + (String)type2 + " and the confidence score from 0-1.\n            IMPORTANT: The fully qualified name must be exactly the same as in the list.\n            "));
            this.logger.debug("{} ranking prompt: {}", type2, (Object)prompt);
            rankingResponse = this.llmOperations.doTransform(prompt, new LlmInteraction(InteractionId.constructor-impl("rank-" + (String)type2 + "s"), this.llm, null, null, null, null, null, null, false, false, 0, null, null, 8188, null), RankingsResponse.class, null);
            this.logger.debug("{} ranking response: {}", type2, (Object)rankingResponse);
            Iterable $this$map$iv = rankables;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Named named2 = (Named)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            thingNames = (List)destination$iv$iv;
            $this$mapTo$iv$iv2 = rankingResponse.getRankings();
            for (Object $i$f$mapTo2 : $this$mapTo$iv$iv2) {
                boolean bl;
                block12: {
                    RankedChoiceResponse rankedChoiceResponse = (RankedChoiceResponse)$i$f$mapTo2;
                    boolean bl2 = false;
                    Iterable $this$none$iv = thingNames;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)rankedChoiceResponse.getName(), (Object)it)) continue;
                            bl = false;
                            break block12;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                v2 = $i$f$mapTo2;
                break block13;
            }
            v2 = null;
        }
        RankedChoiceResponse bogusRanking = v2;
        if (bogusRanking != null) {
            Collection<CallSite> collection;
            void $this$map$iv;
            Iterable $i$f$map = thingNames;
            Object object = type2;
            RankedChoiceResponse rankedChoiceResponse = bogusRanking;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String $i$f$none = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add((CallSite)((Object)("'" + (String)it + "'")));
            }
            collection = (List)destination$iv$iv2;
            String string = "Ranker returned choice '" + rankedChoiceResponse + "' not in the list of available " + (String)object + "s: " + (List)collection + ", raw=" + rankingResponse;
            throw new IllegalStateException(string);
        }
        Iterable $this$map$iv = rankingResponse.getRankings();
        boolean $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RankedChoiceResponse it = (RankedChoiceResponse)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl = false;
            Iterable $this$single$iv = rankables;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                Named thing = (Named)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)thing.getName(), (Object)it.getName())) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            double d = it.getConfidence();
            Named named3 = single$iv;
            collection.add(new Ranking<Named>(named3, d));
        }
        $this$map$iv = (List)destination$iv$iv3;
        boolean $i$f$sortedBy = false;
        List list = CollectionsKt.reversed((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Ranking it = (Ranking)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getScore());
                it = (Ranking)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getScore()));
            }
        }));
        return new Rankings(list);
    }

    private static final Rankings rank$lambda$0(LlmRanker this$0, String $description, String $userInput, Collection $rankables, RetryContext it) {
        return this$0.rankThingsInternal($description, $userInput, $rankables);
    }

    private static final CharSequence rankThingsInternal$lambda$1(Named it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "- " + it.getName() + ": " + ((Described)it).getDescription();
    }
}

