/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.core.support;

import com.embabel.agent.api.channel.OutputChannel;
import com.embabel.agent.api.common.PlatformServices;
import com.embabel.agent.api.common.StuckHandler;
import com.embabel.agent.api.common.StuckHandlerResult;
import com.embabel.agent.api.common.StuckHandlingResultCode;
import com.embabel.agent.api.common.ToolsStats;
import com.embabel.agent.api.event.ActionExecutionStartEvent;
import com.embabel.agent.api.event.AgentProcessCompletedEvent;
import com.embabel.agent.api.event.AgentProcessFailedEvent;
import com.embabel.agent.api.event.AgentProcessPausedEvent;
import com.embabel.agent.api.event.AgentProcessReadyToPlanEvent;
import com.embabel.agent.api.event.AgentProcessStuckEvent;
import com.embabel.agent.api.event.AgentProcessWaitingEvent;
import com.embabel.agent.api.event.AgenticEventListener;
import com.embabel.agent.api.event.ObjectAddedEvent;
import com.embabel.agent.api.event.ObjectBoundEvent;
import com.embabel.agent.api.event.ProcessKilledEvent;
import com.embabel.agent.core.Action;
import com.embabel.agent.core.ActionInvocation;
import com.embabel.agent.core.ActionStatus;
import com.embabel.agent.core.ActionStatusCode;
import com.embabel.agent.core.Agent;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.AgentProcessStatusCode;
import com.embabel.agent.core.Bindable;
import com.embabel.agent.core.Blackboard;
import com.embabel.agent.core.DataDictionary;
import com.embabel.agent.core.DomainType;
import com.embabel.agent.core.EarlyTermination;
import com.embabel.agent.core.IoBinding;
import com.embabel.agent.core.LlmInvocation;
import com.embabel.agent.core.ProcessContext;
import com.embabel.agent.core.ProcessOptions;
import com.embabel.agent.core.support.Rerun;
import com.embabel.agent.spi.ActionExecutionSchedule;
import com.embabel.agent.spi.DelayedActionExecutionSchedule;
import com.embabel.agent.spi.ProntoActionExecutionSchedule;
import com.embabel.agent.spi.ScheduledActionExecutionSchedule;
import com.embabel.agent.spi.support.AgenticEventListenerToolsStats;
import com.embabel.common.core.types.HasInfoString;
import com.embabel.plan.Goal;
import com.embabel.plan.WorldState;
import com.embabel.plan.common.condition.ConditionWorldState;
import com.embabel.plan.common.condition.WorldStateDeterminer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.RetryContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\b&\u0018\u00002\u00020\u00012\u00020\u0002BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020FH\u0016J\u0010\u0010W\u001a\u00020L2\u0006\u0010N\u001a\u00020/H\u0004J\n\u0010X\u001a\u0004\u0018\u00010YH\u0016J\u0018\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u00042\u0006\u0010]\u001a\u000202H\u0016J\u001d\u0010^\u001a\u00020L2\u0012\u0010_\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002020`H\u0096\u0002J\u0019\u0010a\u001a\u00020L2\u0006\u0010\\\u001a\u00020\u00042\u0006\u0010]\u001a\u000202H\u0096\u0002J\u0010\u0010b\u001a\u00020[2\u0006\u0010]\u001a\u000202H\u0016J\u0011\u0010^\u001a\u00020L2\u0006\u0010]\u001a\u000202H\u0096\u0002J\b\u0010c\u001a\u00020dH\u0002J\b\u0010e\u001a\u00020\u0001H\u0016J\n\u0010f\u001a\u0004\u0018\u00010gH\u0004J\u0010\u0010h\u001a\u00020L2\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\b\u0010i\u001a\u00020\u0001H\u0016J\u0010\u0010j\u001a\u00020\u00012\u0006\u0010k\u001a\u00020#H$J\u0010\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020oH\u0004J\u0010\u0010p\u001a\u00020/2\u0006\u0010q\u001a\u00020mH\u0004J\u0017\u0010r\u001a\u00020L2\f\u0010s\u001a\b\u0012\u0004\u0012\u0002020HH\u0096\u0001J\u001d\u0010t\u001a\u00020L2\u0012\u0010u\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002020vH\u0096\u0001J\u0019\u0010w\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u00042\u0006\u0010]\u001a\u000202H\u0096\u0001J\t\u0010x\u001a\u00020LH\u0097\u0001J#\u0010y\u001a\u00020z\"\n\b\u0000\u0010{*\u0004\u0018\u0001022\f\u0010|\u001a\b\u0012\u0004\u0012\u0002H{0}H\u0096\u0001J\u0015\u0010~\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002020vH\u0096\u0001J\u0014\u0010\u007f\u001a\u0004\u0018\u0001022\u0007\u0010\u0080\u0001\u001a\u00020\u0004H\u0096\u0003J\u001a\u0010\u0081\u0001\u001a\u0004\u0018\u00010d2\u0006\u0010\\\u001a\u00020\u0004H\u0096\u0001\u00a2\u0006\u0003\u0010\u0082\u0001J6\u0010\u0083\u0001\u001a\u0003H\u0084\u0001\"\t\b\u0000\u0010\u0084\u0001*\u0002022\u0007\u0010\u0080\u0001\u001a\u00020\u00042\u000f\u0010\u0085\u0001\u001a\n\u0012\u0005\u0012\u0003H\u0084\u00010\u0086\u0001H\u0096\u0001\u00a2\u0006\u0003\u0010\u0087\u0001J(\u0010\u0088\u0001\u001a\u0004\u0018\u0001022\u0007\u0010\u0089\u0001\u001a\u00020\u00042\u0007\u0010\u008a\u0001\u001a\u00020\u00042\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0096\u0001J&\u0010\u008d\u0001\u001a\u00020d2\u0007\u0010\u0089\u0001\u001a\u00020\u00042\u0007\u0010\u008a\u0001\u001a\u00020\u00042\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0096\u0001J\u0013\u0010\u008e\u0001\u001a\u00020L2\u0007\u0010\u008f\u0001\u001a\u000202H\u0096\u0001J$\u0010\u0090\u0001\u001a\u00020\u00042\t\u0010\u0091\u0001\u001a\u0004\u0018\u00010d2\u0007\u0010\u0092\u0001\u001a\u00020zH\u0096\u0001\u00a2\u0006\u0003\u0010\u0093\u0001J,\u0010\u0094\u0001\u001a\u0004\u0018\u0001H{\"\n\b\u0000\u0010{*\u0004\u0018\u0001022\f\u0010|\u001a\b\u0012\u0004\u0012\u0002H{0}H\u0096\u0001\u00a2\u0006\u0003\u0010\u0095\u0001J\f\u0010\u0096\u0001\u001a\u0004\u0018\u000102H\u0096\u0001J*\u0010\u0097\u0001\u001a\b\u0012\u0004\u0012\u0002H{0H\"\n\b\u0000\u0010{*\u0004\u0018\u0001022\f\u0010|\u001a\b\u0012\u0004\u0012\u0002H{0}H\u0096\u0001J\u001d\u0010^\u001a\u00020L2\u0012\u0010u\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002020vH\u0096\u0003J\u001a\u0010\u0098\u0001\u001a\u00020\u00022\u0006\u0010\\\u001a\u00020\u00042\u0006\u0010]\u001a\u00020dH\u0096\u0001J\n\u0010\u0099\u0001\u001a\u00020\u0002H\u0096\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\n\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u000b\u001a\u00020\f8EX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010-\u001a\u0010\u0012\f\u0012\n 0*\u0004\u0018\u00010/0/0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00103\u001a\u0004\u0018\u0001028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0016\u00106\u001a\u0004\u0018\u00010#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010;\u001a\u0004\u0018\u00010%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010'R\u0014\u0010=\u001a\u00020>X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0012\u0010A\u001a\u00020BX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0014\u0010E\u001a\b\u0012\u0004\u0012\u00020F0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010G\u001a\b\u0012\u0004\u0012\u00020F0H8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0014\u0010N\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010PR\u001a\u0010Q\u001a\b\u0012\u0004\u0012\u00020,0H8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010JR\u0014\u0010S\u001a\u00020T8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010VR\u0014\u0010\u009a\u0001\u001a\u00020\u0004X\u0096\u0005\u00a2\u0006\u0007\u001a\u0005\b\u009b\u0001\u0010\u0012R\u0019\u0010s\u001a\b\u0012\u0004\u0012\u0002020HX\u0096\u0005\u00a2\u0006\u0007\u001a\u0005\b\u009c\u0001\u0010J\u00a8\u0006\u009d\u0001"}, d2={"Lcom/embabel/agent/core/support/AbstractAgentProcess;", "Lcom/embabel/agent/core/AgentProcess;", "Lcom/embabel/agent/core/Blackboard;", "id", "", "parentId", "agent", "Lcom/embabel/agent/core/Agent;", "processOptions", "Lcom/embabel/agent/core/ProcessOptions;", "blackboard", "platformServices", "Lcom/embabel/agent/api/common/PlatformServices;", "timestamp", "Ljava/time/Instant;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/embabel/agent/core/Agent;Lcom/embabel/agent/core/ProcessOptions;Lcom/embabel/agent/core/Blackboard;Lcom/embabel/agent/api/common/PlatformServices;Ljava/time/Instant;)V", "getId", "()Ljava/lang/String;", "getParentId", "getAgent", "()Lcom/embabel/agent/core/Agent;", "getProcessOptions", "()Lcom/embabel/agent/core/ProcessOptions;", "getBlackboard", "()Lcom/embabel/agent/core/Blackboard;", "getPlatformServices", "()Lcom/embabel/agent/api/common/PlatformServices;", "getTimestamp", "()Ljava/time/Instant;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "_lastWorldState", "Lcom/embabel/plan/WorldState;", "_goal", "Lcom/embabel/plan/Goal;", "get_goal", "()Lcom/embabel/plan/Goal;", "set_goal", "(Lcom/embabel/plan/Goal;)V", "_history", "", "Lcom/embabel/agent/core/ActionInvocation;", "_status", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/embabel/agent/core/AgentProcessStatusCode;", "kotlin.jvm.PlatformType", "_failureInfo", "", "failureInfo", "getFailureInfo", "()Ljava/lang/Object;", "lastWorldState", "getLastWorldState", "()Lcom/embabel/plan/WorldState;", "agenticEventListenerToolsStats", "Lcom/embabel/agent/spi/support/AgenticEventListenerToolsStats;", "goal", "getGoal", "processContext", "Lcom/embabel/agent/core/ProcessContext;", "getProcessContext", "()Lcom/embabel/agent/core/ProcessContext;", "worldStateDeterminer", "Lcom/embabel/plan/common/condition/WorldStateDeterminer;", "getWorldStateDeterminer", "()Lcom/embabel/plan/common/condition/WorldStateDeterminer;", "_llmInvocations", "Lcom/embabel/agent/core/LlmInvocation;", "llmInvocations", "", "getLlmInvocations", "()Ljava/util/List;", "recordLlmInvocation", "", "llmInvocation", "status", "getStatus", "()Lcom/embabel/agent/core/AgentProcessStatusCode;", "history", "getHistory", "toolsStats", "Lcom/embabel/agent/api/common/ToolsStats;", "getToolsStats", "()Lcom/embabel/agent/api/common/ToolsStats;", "setStatus", "kill", "Lcom/embabel/agent/api/event/ProcessKilledEvent;", "bind", "Lcom/embabel/agent/core/Bindable;", "key", "value", "plusAssign", "pair", "Lkotlin/Pair;", "set", "addObject", "makeRunning", "", "run", "identifyEarlyTermination", "Lcom/embabel/agent/core/EarlyTermination;", "handleStuck", "tick", "formulateAndExecutePlan", "worldState", "executeAction", "Lcom/embabel/agent/core/ActionStatus;", "action", "Lcom/embabel/agent/core/Action;", "actionStatusToAgentProcessStatus", "actionStatus", "addAll", "objects", "bindAll", "bindings", "", "bindProtected", "clear", "count", "", "T", "clazz", "Ljava/lang/Class;", "expressionEvaluationModel", "get", "name", "getCondition", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getOrPut", "V", "creator", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getValue", "variable", "type", "dataDictionary", "Lcom/embabel/agent/core/DataDictionary;", "hasValue", "hide", "what", "infoString", "verbose", "indent", "(Ljava/lang/Boolean;I)Ljava/lang/String;", "last", "(Ljava/lang/Class;)Ljava/lang/Object;", "lastResult", "objectsOfType", "setCondition", "spawn", "blackboardId", "getBlackboardId", "getObjects", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nAbstractAgentProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractAgentProcess.kt\ncom/embabel/agent/core/support/AbstractAgentProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 AgentProcess.kt\ncom/embabel/agent/core/AgentProcess$Companion\n*L\n1#1,442:1\n1216#2,2:443\n1246#2,4:445\n2632#2,3:460\n223#3,11:449\n*S KotlinDebug\n*F\n+ 1 AbstractAgentProcess.kt\ncom/embabel/agent/core/support/AbstractAgentProcess\n*L\n330#1:443,2\n330#1:445,4\n400#1:460,3\n377#1:449,11\n*E\n"})
public abstract class AbstractAgentProcess
implements AgentProcess,
Blackboard {
    @NotNull
    private final String id;
    @Nullable
    private final String parentId;
    @NotNull
    private final Agent agent;
    @NotNull
    private final ProcessOptions processOptions;
    @NotNull
    private final Blackboard blackboard;
    @NotNull
    private final PlatformServices platformServices;
    @NotNull
    private final Instant timestamp;
    @NotNull
    private final Logger logger;
    @Nullable
    private WorldState _lastWorldState;
    @Nullable
    private Goal _goal;
    @NotNull
    private final List<ActionInvocation> _history;
    @NotNull
    private final AtomicReference<AgentProcessStatusCode> _status;
    @Nullable
    private Object _failureInfo;
    @NotNull
    private final AgenticEventListenerToolsStats agenticEventListenerToolsStats;
    @NotNull
    private final ProcessContext processContext;
    @NotNull
    private final List<LlmInvocation> _llmInvocations;

    public AbstractAgentProcess(@NotNull String id, @Nullable String parentId, @NotNull Agent agent, @NotNull ProcessOptions processOptions, @NotNull Blackboard blackboard, @NotNull PlatformServices platformServices, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        Intrinsics.checkNotNullParameter((Object)processOptions, (String)"processOptions");
        Intrinsics.checkNotNullParameter((Object)blackboard, (String)"blackboard");
        Intrinsics.checkNotNullParameter((Object)platformServices, (String)"platformServices");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        this.id = id;
        this.parentId = parentId;
        this.agent = agent;
        this.processOptions = processOptions;
        this.blackboard = blackboard;
        this.platformServices = platformServices;
        this.timestamp = timestamp;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this._history = new ArrayList();
        this._status = new AtomicReference<AgentProcessStatusCode>(AgentProcessStatusCode.NOT_STARTED);
        this.agenticEventListenerToolsStats = new AgenticEventListenerToolsStats();
        PlatformServices platformServices2 = this.platformServices.withEventListener(this.agenticEventListenerToolsStats);
        ProcessOptions processOptions2 = this.getProcessOptions();
        OutputChannel outputChannel = this.platformServices.getOutputChannel().plus(this.getProcessOptions().getOutputChannel());
        this.processContext = new ProcessContext(processOptions2, platformServices2, outputChannel, this);
        this._llmInvocations = new ArrayList();
    }

    public /* synthetic */ AbstractAgentProcess(String string, String string2, Agent agent, ProcessOptions processOptions, Blackboard blackboard, PlatformServices platformServices, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            instant = Instant.now();
        }
        this(string, string2, agent, processOptions, blackboard, platformServices, instant);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getParentId() {
        return this.parentId;
    }

    @Override
    @NotNull
    public Agent getAgent() {
        return this.agent;
    }

    @Override
    @NotNull
    public ProcessOptions getProcessOptions() {
        return this.processOptions;
    }

    @Override
    @NotNull
    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    @JsonIgnore
    @NotNull
    protected final PlatformServices getPlatformServices() {
        return this.platformServices;
    }

    @NotNull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    protected final Goal get_goal() {
        return this._goal;
    }

    protected final void set_goal(@Nullable Goal goal) {
        this._goal = goal;
    }

    @Override
    @Nullable
    public Object getFailureInfo() {
        return this._failureInfo;
    }

    @Override
    @Nullable
    public WorldState getLastWorldState() {
        return this._lastWorldState;
    }

    @Override
    @Nullable
    public Goal getGoal() {
        return this._goal;
    }

    @Override
    @NotNull
    public ProcessContext getProcessContext() {
        return this.processContext;
    }

    @NotNull
    protected abstract WorldStateDeterminer getWorldStateDeterminer();

    @Override
    @NotNull
    public List<LlmInvocation> getLlmInvocations() {
        return CollectionsKt.toList((Iterable)this._llmInvocations);
    }

    @Override
    public void recordLlmInvocation(@NotNull LlmInvocation llmInvocation) {
        Intrinsics.checkNotNullParameter((Object)llmInvocation, (String)"llmInvocation");
        this._llmInvocations.add(llmInvocation);
    }

    @Override
    @NotNull
    public AgentProcessStatusCode getStatus() {
        AgentProcessStatusCode agentProcessStatusCode = this._status.get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)agentProcessStatusCode), (String)"get(...)");
        return agentProcessStatusCode;
    }

    @Override
    @NotNull
    public List<ActionInvocation> getHistory() {
        return CollectionsKt.toList((Iterable)this._history);
    }

    @Override
    @NotNull
    public ToolsStats getToolsStats() {
        return this.agenticEventListenerToolsStats;
    }

    protected final void setStatus(@NotNull AgentProcessStatusCode status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this._status.set(status);
    }

    @Override
    @Nullable
    public ProcessKilledEvent kill() {
        this.setStatus(AgentProcessStatusCode.KILLED);
        return new ProcessKilledEvent(this);
    }

    @Override
    @NotNull
    public Bindable bind(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getBlackboard().set(key, value);
        this.getProcessContext().onProcessEvent(new ObjectBoundEvent(this, key, value));
        return this;
    }

    @Override
    public void plusAssign(@NotNull Pair<String, ? extends Object> pair) {
        Intrinsics.checkNotNullParameter(pair, (String)"pair");
        this.bind((String)pair.getFirst(), pair.getSecond());
    }

    @Override
    public void set(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bind(key, value);
    }

    @Override
    @NotNull
    public Bindable addObject(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getBlackboard().addObject(value);
        this.getProcessContext().onProcessEvent(new ObjectAddedEvent(this, value));
        return this;
    }

    @Override
    public void plusAssign(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.addObject(value);
    }

    private final boolean makeRunning() {
        AgentProcessStatusCode currentStatus;
        AgentProcessStatusCode agentProcessStatusCode = currentStatus = this._status.get();
        switch (agentProcessStatusCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[agentProcessStatusCode.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                this.logger.warn("Process {} Cannot be made RUNNING as its status is {}", (Object)this.getId(), (Object)this.getStatus());
                return false;
            }
        }
        this._status.compareAndSet(currentStatus, AgentProcessStatusCode.RUNNING);
        return true;
    }

    @Override
    @NotNull
    public AgentProcess run() {
        if (!this.makeRunning()) {
            return this;
        }
        if (this.getAgent().getGoals().isEmpty() && this.getProcessOptions().getPlannerType().getNeedsGoals()) {
            this.logger.info("\ud83d\uded1 Process {} has no goals: {}", (Object)this.getId(), this.getAgent().getGoals());
            throw new IllegalStateException(("Agent " + this.getAgent().getName() + " has no goals: " + HasInfoString.infoString$default((HasInfoString)this.getAgent(), (Boolean)true, (int)0, (int)2, null)).toString());
        }
        this.tick();
        while (this.getStatus() == AgentProcessStatusCode.RUNNING) {
            EarlyTermination earlyTermination = this.identifyEarlyTermination();
            if (earlyTermination != null) {
                return this;
            }
            this.tick();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.getStatus().ordinal()]) {
            case 4: {
                this.logger.debug("Process {} is not started: {}", (Object)this.getId(), (Object)this.getStatus());
                break;
            }
            case 5: {
                this.logger.debug("Process {} is happily running: {}", (Object)this.getId(), (Object)this.getStatus());
                break;
            }
            case 1: {
                this.platformServices.getEventListener().onProcessEvent(new AgentProcessCompletedEvent(this));
                break;
            }
            case 6: {
                this.platformServices.getEventListener().onProcessEvent(new AgentProcessFailedEvent(this));
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 7: {
                this.platformServices.getEventListener().onProcessEvent(new AgentProcessWaitingEvent(this));
                break;
            }
            case 8: {
                this.platformServices.getEventListener().onProcessEvent(new AgentProcessPausedEvent(this));
                this.handleStuck(this.getAgent());
                break;
            }
            case 9: {
                this.platformServices.getEventListener().onProcessEvent(new AgentProcessStuckEvent(this));
                this.handleStuck(this.getAgent());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this;
    }

    @Nullable
    protected final EarlyTermination identifyEarlyTermination() {
        EarlyTermination earlyTermination = this.getProcessOptions().getProcessControl().getEarlyTerminationPolicy().shouldTerminate(this);
        if (earlyTermination != null) {
            Object[] objectArray = new Object[]{this.getId(), earlyTermination.getPolicy(), earlyTermination.getReason()};
            this.logger.debug("Process {} terminated by {} because {}", objectArray);
            this.platformServices.getEventListener().onProcessEvent(earlyTermination);
            this._failureInfo = earlyTermination;
            this.setStatus(AgentProcessStatusCode.TERMINATED);
            return earlyTermination;
        }
        return null;
    }

    protected final void handleStuck(@NotNull Agent agent) {
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        StuckHandler stuckHandler = agent.getStuckHandler();
        if (stuckHandler == null) {
            if (this.getProcessOptions().getPlannerType().getNeedsGoals()) {
                Object[] objectArray = new Object[]{this.getId(), this.getHistory().size(), CollectionsKt.joinToString$default((Iterable)this.getHistory(), (CharSequence)"\n\t", null, null, (int)0, null, AbstractAgentProcess::handleStuck$lambda$0, (int)30, null)};
                this.logger.warn("Process {} is stuck with no StuckHandler. This may or may not be an error. History ({}):\n\t{}", objectArray);
            } else {
                this.logger.debug("Process {} is paused, with no available actions", (Object)this.getId());
            }
            return;
        }
        StuckHandlerResult result = stuckHandler.handleStuck(this);
        this.platformServices.getEventListener().onProcessEvent(result);
        switch (WhenMappings.$EnumSwitchMapping$1[result.getCode().ordinal()]) {
            case 1: {
                if (this.getFinished()) {
                    this.logger.info("Process {} is {} during stuck handling, will not replan", (Object)this.getId(), (Object)this.getStatus());
                    return;
                }
                this.logger.info("Process {} unstuck and will replan: {}", (Object)this.getId(), (Object)result.getMessage());
                this.setStatus(AgentProcessStatusCode.RUNNING);
                this.run();
                break;
            }
            case 2: {
                this.logger.warn("Process {} stuck: {}", (Object)this.getId(), (Object)result.getMessage());
                this.setStatus(AgentProcessStatusCode.STUCK);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    @NotNull
    public AgentProcess tick() {
        if (!this.makeRunning()) {
            return this;
        }
        ConditionWorldState worldState = this.getWorldStateDeterminer().determineWorldState();
        this._lastWorldState = worldState;
        this.platformServices.getEventListener().onProcessEvent(new AgentProcessReadyToPlanEvent(this, worldState));
        Object object = new Object[]{this.getId(), worldState, HasInfoString.infoString$default((HasInfoString)this.getBlackboard(), (Boolean)false, (int)0, (int)2, null)};
        this.logger.debug("Process {} tick (about to plan): {}, blackboard={}", object);
        Object $this$tick_u24lambda_u241 = object = this.formulateAndExecutePlan(worldState);
        boolean bl = false;
        this.platformServices.getAgentProcessRepository().update((AgentProcess)$this$tick_u24lambda_u241);
        return object;
    }

    @NotNull
    protected abstract AgentProcess formulateAndExecutePlan(@NotNull WorldState var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    protected final ActionStatus executeAction(@NotNull Action action) {
        boolean blackboardWasCleared;
        ActionStatus actionStatus;
        ActionExecutionStartEvent actionExecutionStartEvent;
        block17: {
            ActionStatus actionStatus2;
            void this_$iv;
            ActionExecutionSchedule actionExecutionSchedule;
            boolean bl;
            Object[] $this$associateByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Object[] $this$associateBy$iv = (Object[])action.getOutputs();
            boolean $i$f$associateBy = false;
            int capacity$iv232 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Object[] objectArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv232);
            boolean $i$f$associateByTo232 = false;
            for (Object t : $this$associateByTo$iv$iv) {
                String string = ((IoBinding)t).unbox-impl();
                Map map = destination$iv$iv;
                bl = false;
                String it = ((IoBinding)t).unbox-impl();
                String string2 = IoBinding.getName-impl(it);
                boolean bl2 = false;
                DomainType domainType = this.getAgent().resolveType(IoBinding.getType-impl(it));
                map.put(string2, domainType);
            }
            Map outputTypes = destination$iv$iv;
            $this$associateBy$iv = new Object[]{this.getId(), action.getName(), outputTypes};
            this.logger.debug("\u2699\ufe0f Process {} executing action {}: outputTypes={}", $this$associateBy$iv);
            actionExecutionStartEvent = new ActionExecutionStartEvent(this, action);
            this.platformServices.getEventListener().onProcessEvent(actionExecutionStartEvent);
            ActionExecutionSchedule capacity$iv232 = actionExecutionSchedule = this.platformServices.getOperationScheduler().scheduleAction(actionExecutionStartEvent);
            if (!(capacity$iv232 instanceof ProntoActionExecutionSchedule)) {
                if (capacity$iv232 instanceof DelayedActionExecutionSchedule) {
                    $this$associateByTo$iv$iv = new Object[]{this.getId(), action.getName(), actionExecutionSchedule};
                    this.logger.debug("Process {} delayed action {}: {}", $this$associateByTo$iv$iv);
                    try {
                        Thread.sleep(((DelayedActionExecutionSchedule)actionExecutionSchedule).getDelay().toMillis());
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        this._status.set(AgentProcessStatusCode.TERMINATED);
                        Duration duration = Duration.between(actionExecutionStartEvent.getTimestamp(), Instant.now());
                        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
                        return new ActionStatus(duration, ActionStatusCode.FAILED);
                    }
                    this.logger.debug("Process {} delayed action {}: done", (Object)this.getId(), (Object)action.getName());
                } else {
                    if (capacity$iv232 instanceof ScheduledActionExecutionSchedule) {
                        Duration duration = Duration.between(actionExecutionStartEvent.getTimestamp(), Instant.now());
                        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
                        return new ActionStatus(duration, ActionStatusCode.PAUSED);
                    }
                    throw new NoWhenBranchMatchedException();
                }
            }
            List blackboardObjectsBefore = CollectionsKt.toList((Iterable)this.getBlackboard().getObjects());
            Instant timestamp = Instant.now();
            AgentProcess.Companion $i$f$associateByTo232 = AgentProcess.Companion;
            AgentProcess $this$withCurrent$iv = this;
            boolean bl2 = false;
            AgentProcess previous$iv = this_$iv.get();
            try {
                this_$iv.set($this$withCurrent$iv);
                bl = false;
                actionStatus2 = (ActionStatus)action.getQos().retryTemplate("Action-" + action.getName()).execute(arg_0 -> AbstractAgentProcess.executeAction$lambda$5$lambda$4(action, this, arg_0));
            }
            finally {
                if (previous$iv != null) {
                    this_$iv.set(previous$iv);
                } else {
                    this_$iv.remove();
                }
            }
            actionStatus = actionStatus2;
            Duration runningTime = Duration.between(timestamp, Instant.now());
            Collection collection = this._history;
            String string = action.getName();
            Intrinsics.checkNotNull((Object)timestamp);
            Intrinsics.checkNotNull((Object)runningTime);
            collection.add(new ActionInvocation(string, timestamp, runningTime));
            Iterable iterable = this.getBlackboard().getObjects();
            boolean $i$f$none = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                v4 = true;
            } else {
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl3 = false;
                    if (!blackboardObjectsBefore.contains(it)) continue;
                    v4 = false;
                    break block17;
                }
                v4 = blackboardWasCleared = true;
            }
        }
        if (!blackboardWasCleared) {
            this.getBlackboard().setCondition(Rerun.INSTANCE.hasRunCondition(action), true);
        }
        AgenticEventListener agenticEventListener = this.platformServices.getEventListener();
        Intrinsics.checkNotNull((Object)actionStatus);
        agenticEventListener.onProcessEvent(actionExecutionStartEvent.resultEvent(actionStatus));
        this.logger.debug("New world state: {}", (Object)this.getWorldStateDeterminer().determineWorldState());
        return actionStatus;
    }

    @NotNull
    protected final AgentProcessStatusCode actionStatusToAgentProcessStatus(@NotNull ActionStatus actionStatus) {
        Intrinsics.checkNotNullParameter((Object)actionStatus, (String)"actionStatus");
        return switch (WhenMappings.$EnumSwitchMapping$2[actionStatus.getStatus().ordinal()]) {
            case 1 -> {
                this.logger.debug("Process {} action {} is running", (Object)this.getId(), (Object)actionStatus.getStatus());
                yield AgentProcessStatusCode.RUNNING;
            }
            case 2 -> {
                this.logger.debug("\u274c Process {} action {} failed", (Object)this.getId(), (Object)actionStatus.getStatus());
                yield AgentProcessStatusCode.FAILED;
            }
            case 3 -> {
                this.logger.debug("\u23f3 Process {} action {} waiting", (Object)this.getId(), (Object)actionStatus.getStatus());
                yield AgentProcessStatusCode.WAITING;
            }
            case 4 -> {
                this.logger.debug("\u23f3 Process {} action {} paused", (Object)this.getId(), (Object)actionStatus.getStatus());
                yield AgentProcessStatusCode.PAUSED;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @Nullable
    public Object getValue(@NotNull String variable, @NotNull String type2, @NotNull DataDictionary dataDictionary) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)dataDictionary, (String)"dataDictionary");
        return this.blackboard.getValue(variable, type2, dataDictionary);
    }

    @Override
    @NotNull
    public String getBlackboardId() {
        return this.blackboard.getBlackboardId();
    }

    @Override
    @Nullable
    public Object get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.blackboard.get(name);
    }

    @Override
    public void hide(@NotNull Object what) {
        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
        this.blackboard.hide(what);
    }

    @Override
    @NotNull
    public <V> V getOrPut(@NotNull String name, @NotNull Function0<? extends V> creator) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(creator, (String)"creator");
        return this.blackboard.getOrPut(name, creator);
    }

    @Override
    public boolean hasValue(@NotNull String variable, @NotNull String type2, @NotNull DataDictionary dataDictionary) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)dataDictionary, (String)"dataDictionary");
        return this.blackboard.hasValue(variable, type2, dataDictionary);
    }

    @Override
    public <T> int count(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return this.blackboard.count(clazz);
    }

    @Override
    @Nullable
    public <T> T last(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return this.blackboard.last(clazz);
    }

    @Override
    @NotNull
    public <T> List<T> objectsOfType(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return this.blackboard.objectsOfType(clazz);
    }

    @Override
    @NotNull
    public List<Object> getObjects() {
        return this.blackboard.getObjects();
    }

    @Override
    @NotNull
    public Blackboard spawn() {
        return this.blackboard.spawn();
    }

    @Override
    @NotNull
    public Blackboard setCondition(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.blackboard.setCondition(key, value);
    }

    @Override
    @Nullable
    public Boolean getCondition(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.blackboard.getCondition(key);
    }

    @Override
    @Nullable
    public Object lastResult() {
        return this.blackboard.lastResult();
    }

    @Override
    @NotNull
    public Map<String, Object> expressionEvaluationModel() {
        return this.blackboard.expressionEvaluationModel();
    }

    @Override
    @ApiStatus.Internal
    public void clear() {
        this.blackboard.clear();
    }

    @Override
    @NotNull
    public Bindable bindProtected(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.blackboard.bindProtected(key, value);
    }

    @Override
    public void addAll(@NotNull List<? extends Object> objects) {
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        this.blackboard.addAll(objects);
    }

    @Override
    public void plusAssign(@NotNull Map<String, ? extends Object> bindings) {
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        this.blackboard.plusAssign(bindings);
    }

    @Override
    public void bindAll(@NotNull Map<String, ? extends Object> bindings) {
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        this.blackboard.bindAll(bindings);
    }

    @NotNull
    public String infoString(@Nullable Boolean verbose, int indent) {
        return this.blackboard.infoString(verbose, indent);
    }

    private static final CharSequence handleStuck$lambda$0(ActionInvocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getActionName();
    }

    private static final ActionStatus executeAction$lambda$5$lambda$4(Action $action, AbstractAgentProcess this$0, RetryContext it) {
        return $action.execute(this$0.getProcessContext());
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[AgentProcessStatusCode.values().length];
            try {
                nArray[AgentProcessStatusCode.COMPLETED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentProcessStatusCode.KILLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentProcessStatusCode.TERMINATED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentProcessStatusCode.NOT_STARTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentProcessStatusCode.RUNNING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentProcessStatusCode.FAILED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentProcessStatusCode.WAITING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentProcessStatusCode.PAUSED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AgentProcessStatusCode.STUCK.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[StuckHandlingResultCode.values().length];
            try {
                nArray[StuckHandlingResultCode.REPLAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StuckHandlingResultCode.NO_RESOLUTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ActionStatusCode.values().length];
            try {
                nArray[ActionStatusCode.SUCCEEDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionStatusCode.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionStatusCode.WAITING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionStatusCode.PAUSED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

