/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.tool.agentic.state;

import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.api.tool.agentic.DomainToolTracker;
import com.embabel.agent.api.tool.agentic.state.StateHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B;\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\b\u0010\u0006\u001a\u0004\u0018\u00018\u0000\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\b\u0010\u001b\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0012\u0010\u0006\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lcom/embabel/agent/api/tool/agentic/state/StateBoundTool;", "S", "", "Lcom/embabel/agent/api/tool/Tool;", "delegate", "availableInState", "transitionsTo", "stateHolder", "Lcom/embabel/agent/api/tool/agentic/state/StateHolder;", "domainToolTracker", "Lcom/embabel/agent/api/tool/agentic/DomainToolTracker;", "<init>", "(Lcom/embabel/agent/api/tool/Tool;Ljava/lang/Enum;Ljava/lang/Enum;Lcom/embabel/agent/api/tool/agentic/state/StateHolder;Lcom/embabel/agent/api/tool/agentic/DomainToolTracker;)V", "Ljava/lang/Enum;", "definition", "Lcom/embabel/agent/api/tool/Tool$Definition;", "getDefinition", "()Lcom/embabel/agent/api/tool/Tool$Definition;", "buildDescription", "", "metadata", "Lcom/embabel/agent/api/tool/Tool$Metadata;", "getMetadata", "()Lcom/embabel/agent/api/tool/Tool$Metadata;", "call", "Lcom/embabel/agent/api/tool/Tool$Result;", "input", "toString", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nStateBoundTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateBoundTool.kt\ncom/embabel/agent/api/tool/agentic/state/StateBoundTool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,156:1\n1#2:157\n27#3:158\n27#3:159\n*S KotlinDebug\n*F\n+ 1 StateBoundTool.kt\ncom/embabel/agent/api/tool/agentic/state/StateBoundTool\n*L\n74#1:158\n86#1:159\n*E\n"})
public final class StateBoundTool<S extends Enum<S>>
implements Tool {
    @NotNull
    private final Tool delegate;
    @NotNull
    private final S availableInState;
    @Nullable
    private final S transitionsTo;
    @NotNull
    private final StateHolder<S> stateHolder;
    @Nullable
    private final DomainToolTracker domainToolTracker;
    @NotNull
    private final Tool.Definition definition;
    @NotNull
    private final Tool.Metadata metadata;

    public StateBoundTool(@NotNull Tool delegate, @NotNull S availableInState, @Nullable S transitionsTo, @NotNull StateHolder<S> stateHolder, @Nullable DomainToolTracker domainToolTracker) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(availableInState, (String)"availableInState");
        Intrinsics.checkNotNullParameter(stateHolder, (String)"stateHolder");
        this.delegate = delegate;
        this.availableInState = availableInState;
        this.transitionsTo = transitionsTo;
        this.stateHolder = stateHolder;
        this.domainToolTracker = domainToolTracker;
        this.definition = new Tool.Definition(this){
            private final String name;
            private final String description;
            private final Tool.InputSchema inputSchema;
            {
                this.name = StateBoundTool.access$getDelegate$p($receiver).getDefinition().getName();
                this.description = StateBoundTool.access$buildDescription($receiver);
                this.inputSchema = StateBoundTool.access$getDelegate$p($receiver).getDefinition().getInputSchema();
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }

            public Tool.InputSchema getInputSchema() {
                return this.inputSchema;
            }
        };
        this.metadata = this.delegate.getMetadata();
    }

    public /* synthetic */ StateBoundTool(Tool tool, Enum enum_, Enum enum_2, StateHolder stateHolder, DomainToolTracker domainToolTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            domainToolTracker = null;
        }
        this(tool, enum_, enum_2, stateHolder, domainToolTracker);
    }

    @Override
    @NotNull
    public Tool.Definition getDefinition() {
        return this.definition;
    }

    private final String buildDescription() {
        Object object;
        String stateNote;
        block3: {
            block2: {
                stateNote = "[Available in state: " + this.availableInState + "]";
                object = this.transitionsTo;
                if (object == null) break block2;
                S it = object;
                boolean bl = false;
                String string = " [Transitions to: " + it + "]";
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        Object transitionNote = object;
        return this.delegate.getDefinition().getDescription() + "\n\n" + stateNote + transitionNote;
    }

    @Override
    @NotNull
    public Tool.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public Tool.Result call(@NotNull String input) {
        Object artifact;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        S currentState = this.stateHolder.getCurrentState();
        if (!Intrinsics.areEqual(currentState, this.availableInState)) {
            boolean $i$f$loggerFor22 = false;
            Logger logger = LoggerFactory.getLogger(StateBoundTool.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            Object[] $i$f$loggerFor22 = new Object[]{this.delegate.getDefinition().getName(), currentState, this.availableInState};
            logger.debug("Tool '{}' not available in state {} (requires {})", $i$f$loggerFor22);
            return Tool.Result.Companion.text("This tool is not available in the current state (" + currentState + "). It is only available in state: " + this.availableInState);
        }
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(StateBoundTool.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.info("Executing tool '{}' in state {}", (Object)this.delegate.getDefinition().getName(), currentState);
        Tool.Result result = this.delegate.call(input);
        if (result instanceof Tool.Result.WithArtifact && !((artifact = ((Tool.Result.WithArtifact)result).getArtifact()) instanceof Iterable)) {
            DomainToolTracker domainToolTracker = this.domainToolTracker;
            if (domainToolTracker != null) {
                domainToolTracker.tryBindArtifact(artifact);
            }
        }
        if (this.transitionsTo != null && !(result instanceof Tool.Result.Error)) {
            this.stateHolder.transitionTo(this.transitionsTo);
        }
        return result;
    }

    @NotNull
    public String toString() {
        return "StateBoundTool(" + this.delegate.getDefinition().getName() + ", state=" + this.availableInState + ", transitionsTo=" + this.transitionsTo + ")";
    }

    public static final /* synthetic */ Tool access$getDelegate$p(StateBoundTool $this) {
        return $this.delegate;
    }

    public static final /* synthetic */ String access$buildDescription(StateBoundTool $this) {
        return $this.buildDescription();
    }
}

