/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.api.tool;

import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.api.tool.ToolControlFlowSignal;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0004B[\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u001e\u001a\u00028\u00012\u0006\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0015\u0010#\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\u0006H\u0014\u00a2\u0006\u0002\u0010$J\u0015\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010'R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006("}, d2={"Lcom/embabel/agent/api/tool/TypedTool;", "I", "", "O", "Lcom/embabel/agent/api/tool/Tool;", "name", "", "description", "inputType", "Ljava/lang/Class;", "outputType", "metadata", "Lcom/embabel/agent/api/tool/Tool$Metadata;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "function", "Ljava/util/function/Function;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Class;Lcom/embabel/agent/api/tool/Tool$Metadata;Lcom/fasterxml/jackson/databind/ObjectMapper;Ljava/util/function/Function;)V", "getInputType", "()Ljava/lang/Class;", "getOutputType", "getMetadata", "()Lcom/embabel/agent/api/tool/Tool$Metadata;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "definition", "Lcom/embabel/agent/api/tool/Tool$Definition;", "getDefinition", "()Lcom/embabel/agent/api/tool/Tool$Definition;", "typedCall", "input", "(Ljava/lang/Object;)Ljava/lang/Object;", "call", "Lcom/embabel/agent/api/tool/Tool$Result;", "parseInput", "(Ljava/lang/String;)Ljava/lang/Object;", "convertResult", "result", "(Ljava/lang/Object;)Lcom/embabel/agent/api/tool/Tool$Result;", "embabel-agent-api"})
public class TypedTool<I, O>
implements Tool {
    @NotNull
    private final Class<I> inputType;
    @NotNull
    private final Class<O> outputType;
    @NotNull
    private final Tool.Metadata metadata;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Function<I, O> function;
    @NotNull
    private final Tool.Definition definition;

    public TypedTool(@NotNull String name, @NotNull String description, @NotNull Class<I> inputType, @NotNull Class<O> outputType, @NotNull Tool.Metadata metadata2, @NotNull ObjectMapper objectMapper, @NotNull Function<I, O> function) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(inputType, (String)"inputType");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.inputType = inputType;
        this.outputType = outputType;
        this.metadata = metadata2;
        this.objectMapper = objectMapper;
        this.function = function;
        this.definition = Tool.Definition.Companion.invoke(name, description, Tool.InputSchema.Companion.of(this.inputType));
    }

    public /* synthetic */ TypedTool(String string, String string2, Class clazz, Class clazz2, Tool.Metadata metadata2, ObjectMapper objectMapper, Function function, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            metadata2 = Tool.Metadata.DEFAULT;
        }
        if ((n & 0x20) != 0) {
            objectMapper = ExtensionsKt.jacksonObjectMapper();
        }
        this(string, string2, clazz, clazz2, metadata2, objectMapper, function);
    }

    @NotNull
    protected final Class<I> getInputType() {
        return this.inputType;
    }

    @NotNull
    protected final Class<O> getOutputType() {
        return this.outputType;
    }

    @Override
    @NotNull
    public Tool.Metadata getMetadata() {
        return this.metadata;
    }

    @NotNull
    protected final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    @NotNull
    public Tool.Definition getDefinition() {
        return this.definition;
    }

    @NotNull
    public O typedCall(@NotNull I input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        O o = this.function.apply(input);
        Intrinsics.checkNotNullExpressionValue(o, (String)"apply(...)");
        return o;
    }

    @Override
    @NotNull
    public Tool.Result call(@NotNull String input) {
        Tool.Result result;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            I parsed = this.parseInput(input);
            O result2 = this.typedCall(parsed);
            result = this.convertResult(result2);
        }
        catch (Exception e) {
            if (e instanceof ToolControlFlowSignal) {
                throw e;
            }
            String string = e.getMessage();
            if (string == null) {
                string = "Tool invocation failed";
            }
            String message = string;
            result = Tool.Result.Companion.error(message, e);
        }
        return result;
    }

    @NotNull
    protected I parseInput(@NotNull String input) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (StringsKt.isBlank((CharSequence)input)) {
            I i2;
            try {
                i2 = this.inputType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Empty input provided but " + this.inputType.getSimpleName() + " has no no-arg constructor");
            }
            I i3 = i2;
            Intrinsics.checkNotNull(i3);
            object = i3;
        } else {
            Object object2 = this.objectMapper.readValue(input, this.inputType);
            Intrinsics.checkNotNull((Object)object2);
            object = object2;
        }
        return (I)object;
    }

    @NotNull
    protected Tool.Result convertResult(@NotNull O result) {
        Tool.Result result2;
        Intrinsics.checkNotNullParameter(result, (String)"result");
        O o = result;
        if (o instanceof Tool.Result) {
            result2 = (Tool.Result)result;
        } else if (o instanceof String) {
            result2 = Tool.Result.Companion.text((String)result);
        } else {
            String string = this.objectMapper.writeValueAsString(result);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            result2 = Tool.Result.Companion.text(string);
        }
        return result2;
    }
}

