/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.chat.support;

import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.spi.support.DelegatingTool;
import com.embabel.chat.Asset;
import com.embabel.chat.AssetTracker;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010!R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/embabel/chat/support/AssetAddingTool;", "T", "Lcom/embabel/agent/spi/support/DelegatingTool;", "delegate", "Lcom/embabel/agent/api/tool/Tool;", "assetTracker", "Lcom/embabel/chat/AssetTracker;", "converter", "Lkotlin/Function1;", "Lcom/embabel/chat/Asset;", "clazz", "Ljava/lang/Class;", "<init>", "(Lcom/embabel/agent/api/tool/Tool;Lcom/embabel/chat/AssetTracker;Lkotlin/jvm/functions/Function1;Ljava/lang/Class;)V", "getDelegate", "()Lcom/embabel/agent/api/tool/Tool;", "getAssetTracker", "()Lcom/embabel/chat/AssetTracker;", "getConverter", "()Lkotlin/jvm/functions/Function1;", "getClazz", "()Ljava/lang/Class;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "call", "Lcom/embabel/agent/api/tool/Tool$Result;", "input", "", "addAsset", "", "item", "(Ljava/lang/Object;)V", "definition", "Lcom/embabel/agent/api/tool/Tool$Definition;", "getDefinition", "()Lcom/embabel/agent/api/tool/Tool$Definition;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nAssetAddingTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssetAddingTool.kt\ncom/embabel/chat/support/AssetAddingTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1863#2,2:85\n*S KotlinDebug\n*F\n+ 1 AssetAddingTool.kt\ncom/embabel/chat/support/AssetAddingTool\n*L\n51#1:85,2\n*E\n"})
public final class AssetAddingTool<T>
implements DelegatingTool {
    @NotNull
    private final Tool delegate;
    @NotNull
    private final AssetTracker assetTracker;
    @NotNull
    private final Function1<T, Asset> converter;
    @NotNull
    private final Class<T> clazz;
    private final Logger logger;
    @NotNull
    private final Tool.Definition definition;

    public AssetAddingTool(@NotNull Tool delegate, @NotNull AssetTracker assetTracker, @NotNull Function1<? super T, ? extends Asset> converter, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)assetTracker, (String)"assetTracker");
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.delegate = delegate;
        this.assetTracker = assetTracker;
        this.converter = converter;
        this.clazz = clazz;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.definition = this.getDelegate().getDefinition();
    }

    @Override
    @NotNull
    public Tool getDelegate() {
        return this.delegate;
    }

    @NotNull
    public final AssetTracker getAssetTracker() {
        return this.assetTracker;
    }

    @NotNull
    public final Function1<T, Asset> getConverter() {
        return this.converter;
    }

    @NotNull
    public final Class<T> getClazz() {
        return this.clazz;
    }

    @Override
    @NotNull
    public Tool.Result call(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Tool.Result result = this.getDelegate().call(input);
        if (result instanceof Tool.Result.WithArtifact) {
            Object artifact = ((Tool.Result.WithArtifact)result).getArtifact();
            if (artifact instanceof Iterable) {
                Iterable $this$forEach$iv = CollectionsKt.filterIsInstance((Iterable)((Iterable)artifact), this.clazz);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object item = element$iv = iterator.next();
                    boolean bl = false;
                    this.addAsset(item);
                }
            } else if (this.clazz.isInstance(artifact)) {
                this.addAsset(artifact);
            }
        }
        return result;
    }

    private final void addAsset(T item) {
        Asset asset = (Asset)this.converter.invoke(item);
        this.assetTracker.addAsset(asset);
        Object[] objectArray = new Object[]{asset.getClass().getName(), asset.getId(), this.getDefinition().getName()};
        this.logger.info("Added asset of class {} with id={} from tool={}", objectArray);
    }

    @Override
    @NotNull
    public Tool.Definition getDefinition() {
        return this.definition;
    }
}

