/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.tools.file;

import com.embabel.common.util.StringTransformer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/embabel/agent/tools/file/WellKnownFileContentTransformers;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "removeApacheLicenseHeader", "Lcom/embabel/common/util/StringTransformer;", "getRemoveApacheLicenseHeader", "()Lcom/embabel/common/util/StringTransformer;", "removeDocComments", "getRemoveDocComments", "removeSingleLineComments", "getRemoveSingleLineComments", "removeImports", "getRemoveImports", "removeEmptyLines", "getRemoveEmptyLines", "compressWhitespace", "getCompressWhitespace", "allSanitizers", "", "minimalSanitizers", "commentRemovalSanitizers", "whitespaceCleanupSanitizers", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nWellKnownFileContentTransformers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WellKnownFileContentTransformers.kt\ncom/embabel/agent/tools/file/WellKnownFileContentTransformers\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,166:1\n27#2:167\n*S KotlinDebug\n*F\n+ 1 WellKnownFileContentTransformers.kt\ncom/embabel/agent/tools/file/WellKnownFileContentTransformers\n*L\n29#1:167\n*E\n"})
public final class WellKnownFileContentTransformers {
    @NotNull
    public static final WellKnownFileContentTransformers INSTANCE = new WellKnownFileContentTransformers();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final StringTransformer removeApacheLicenseHeader;
    @NotNull
    private static final StringTransformer removeDocComments;
    @NotNull
    private static final StringTransformer removeSingleLineComments;
    @NotNull
    private static final StringTransformer removeImports;
    @NotNull
    private static final StringTransformer removeEmptyLines;
    @NotNull
    private static final StringTransformer compressWhitespace;

    private WellKnownFileContentTransformers() {
    }

    @NotNull
    public final StringTransformer getRemoveApacheLicenseHeader() {
        return removeApacheLicenseHeader;
    }

    @NotNull
    public final StringTransformer getRemoveDocComments() {
        return removeDocComments;
    }

    @NotNull
    public final StringTransformer getRemoveSingleLineComments() {
        return removeSingleLineComments;
    }

    @NotNull
    public final StringTransformer getRemoveImports() {
        return removeImports;
    }

    @NotNull
    public final StringTransformer getRemoveEmptyLines() {
        return removeEmptyLines;
    }

    @NotNull
    public final StringTransformer getCompressWhitespace() {
        return compressWhitespace;
    }

    @NotNull
    public final List<StringTransformer> allSanitizers() {
        logger.debug("Creating all sanitizers list");
        Object[] objectArray = new StringTransformer[]{removeApacheLicenseHeader, removeDocComments, removeSingleLineComments, removeImports, removeEmptyLines, compressWhitespace};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<StringTransformer> minimalSanitizers() {
        logger.debug("Creating minimal sanitizers list");
        Object[] objectArray = new StringTransformer[]{removeApacheLicenseHeader, removeDocComments, compressWhitespace};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<StringTransformer> commentRemovalSanitizers() {
        logger.debug("Creating comment removal sanitizers list");
        Object[] objectArray = new StringTransformer[]{removeApacheLicenseHeader, removeDocComments, removeSingleLineComments};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<StringTransformer> whitespaceCleanupSanitizers() {
        logger.debug("Creating whitespace cleanup sanitizers list");
        Object[] objectArray = new StringTransformer[]{removeEmptyLines, compressWhitespace};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final String removeApacheLicenseHeader$lambda$0(String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Regex apacheLicensePattern = new Regex("/\\*\\s*\\n \\* Copyright .*?\\n(?:.|\\n)*? \\* limitations under the License\\.\\s*\\n \\*/\\s*\\n", RegexOption.MULTILINE);
        String result = apacheLicensePattern.replace((CharSequence)content, "");
        logger.debug("Apache License Header sanitizer: removed {} characters", (Object)(content.length() - result.length()));
        return result;
    }

    private static final String removeDocComments$lambda$1(String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Regex docCommentPattern = new Regex("/\\*\\*\\s*\\n(?:.|\\n)*?\\s*\\*/", RegexOption.MULTILINE);
        String result = docCommentPattern.replace((CharSequence)content, "");
        logger.debug("Doc comments sanitizer: removed {} characters", (Object)(content.length() - result.length()));
        return result;
    }

    private static final String removeSingleLineComments$lambda$2(String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Regex singleLineCommentPattern = new Regex("\\s*//.*$", RegexOption.MULTILINE);
        String result = singleLineCommentPattern.replace((CharSequence)content, "");
        logger.debug("Single line comments sanitizer: removed {} characters", (Object)(content.length() - result.length()));
        return result;
    }

    private static final String removeImports$lambda$3(String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Regex importPattern = new Regex("import .*$\\n", RegexOption.MULTILINE);
        String result = importPattern.replace((CharSequence)content, "");
        logger.debug("Import statements sanitizer: removed {} characters", (Object)(content.length() - result.length()));
        return result;
    }

    private static final String removeEmptyLines$lambda$4(String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Regex emptyLinePattern = new Regex("^\\s*$\\n", RegexOption.MULTILINE);
        String result = emptyLinePattern.replace((CharSequence)content, "");
        logger.debug("Empty lines sanitizer: removed {} characters", (Object)(content.length() - result.length()));
        return result;
    }

    private static final String compressWhitespace$lambda$5(String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Regex multipleSpacesPattern = new Regex("[ \\t]+");
        Regex multipleEmptyLinesPattern = new Regex("\\n{3,}");
        String intermediate = multipleSpacesPattern.replace((CharSequence)content, " ");
        String result = multipleEmptyLinesPattern.replace((CharSequence)intermediate, "\n\n");
        logger.debug("Whitespace compression sanitizer: removed {} characters", (Object)(content.length() - result.length()));
        return result;
    }

    static {
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(WellKnownFileContentTransformers.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        WellKnownFileContentTransformers.logger = logger;
        removeApacheLicenseHeader = WellKnownFileContentTransformers::removeApacheLicenseHeader$lambda$0;
        removeDocComments = WellKnownFileContentTransformers::removeDocComments$lambda$1;
        removeSingleLineComments = WellKnownFileContentTransformers::removeSingleLineComments$lambda$2;
        removeImports = WellKnownFileContentTransformers::removeImports$lambda$3;
        removeEmptyLines = WellKnownFileContentTransformers::removeEmptyLines$lambda$4;
        compressWhitespace = WellKnownFileContentTransformers::compressWhitespace$lambda$5;
    }
}

