/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support.springai;

import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.core.Usage;
import com.embabel.agent.core.support.SpringAiUtilsKt;
import com.embabel.agent.spi.loop.LlmMessageResponse;
import com.embabel.agent.spi.loop.LlmMessageSender;
import com.embabel.agent.spi.support.springai.MessageConvertersKt;
import com.embabel.agent.spi.support.springai.SpringToolCallbackAdapterKt;
import com.embabel.chat.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0016J\u0016\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/embabel/agent/spi/support/springai/SpringAiLlmMessageSender;", "Lcom/embabel/agent/spi/loop/LlmMessageSender;", "chatModel", "Lorg/springframework/ai/chat/model/ChatModel;", "chatOptions", "Lorg/springframework/ai/chat/prompt/ChatOptions;", "<init>", "(Lorg/springframework/ai/chat/model/ChatModel;Lorg/springframework/ai/chat/prompt/ChatOptions;)V", "logger", "Lorg/slf4j/Logger;", "call", "Lcom/embabel/agent/spi/loop/LlmMessageResponse;", "messages", "", "Lcom/embabel/chat/Message;", "tools", "Lcom/embabel/agent/api/tool/Tool;", "buildChatOptionsWithTools", "toolCallbacks", "Lorg/springframework/ai/tool/ToolCallback;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nSpringAiLlmMessageSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringAiLlmMessageSender.kt\ncom/embabel/agent/spi/support/springai/SpringAiLlmMessageSender\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n27#2:109\n1557#3:110\n1628#3,3:111\n*S KotlinDebug\n*F\n+ 1 SpringAiLlmMessageSender.kt\ncom/embabel/agent/spi/support/springai/SpringAiLlmMessageSender\n*L\n45#1:109\n52#1:110\n52#1:111,3\n*E\n"})
public final class SpringAiLlmMessageSender
implements LlmMessageSender {
    @NotNull
    private final ChatModel chatModel;
    @NotNull
    private final ChatOptions chatOptions;
    @NotNull
    private final Logger logger;

    public SpringAiLlmMessageSender(@NotNull ChatModel chatModel, @NotNull ChatOptions chatOptions) {
        Intrinsics.checkNotNullParameter((Object)chatModel, (String)"chatModel");
        Intrinsics.checkNotNullParameter((Object)chatOptions, (String)"chatOptions");
        this.chatModel = chatModel;
        this.chatOptions = chatOptions;
        boolean $i$f$loggerFor = false;
        Logger logger = LoggerFactory.getLogger(SpringAiLlmMessageSender.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LlmMessageResponse call(@NotNull List<? extends Message> messages, @NotNull List<? extends Tool> tools) {
        Usage usage;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter(tools, (String)"tools");
        Iterable $this$map$iv = messages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Message message = (Message)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MessageConvertersKt.toSpringAiMessage((Message)it));
        }
        List springAiMessages = (List)destination$iv$iv;
        List<ToolCallback> toolCallbacks = SpringToolCallbackAdapterKt.toSpringToolCallbacks(tools);
        Prompt prompt = new Prompt(springAiMessages, this.buildChatOptionsWithTools(toolCallbacks));
        ChatResponse chatResponse = this.chatModel.call(prompt);
        Intrinsics.checkNotNullExpressionValue((Object)chatResponse, (String)"call(...)");
        ChatResponse response = chatResponse;
        this.logger.debug("Prompt: {}\nResponse: {}", (Object)prompt, (Object)response);
        AssistantMessage assistantMessage = response.getResult().getOutput();
        Intrinsics.checkNotNullExpressionValue((Object)assistantMessage, (String)"getOutput(...)");
        AssistantMessage assistantMessage2 = assistantMessage;
        Message embabelMessage = MessageConvertersKt.toEmbabelMessage(assistantMessage2);
        ChatResponseMetadata chatResponseMetadata = response.getMetadata();
        Usage usage2 = usage = chatResponseMetadata != null && (chatResponseMetadata = chatResponseMetadata.getUsage()) != null ? SpringAiUtilsKt.toEmbabelUsage((org.springframework.ai.chat.metadata.Usage)chatResponseMetadata) : null;
        String string = assistantMessage2.getText();
        if (string == null) {
            string = "";
        }
        return new LlmMessageResponse(embabelMessage, string, usage);
    }

    private final ChatOptions buildChatOptionsWithTools(List<? extends ToolCallback> toolCallbacks) {
        if (toolCallbacks.isEmpty()) {
            return this.chatOptions;
        }
        ToolCallingChatOptions toolCallingChatOptions = ToolCallingChatOptions.builder().model(this.chatOptions.getModel()).temperature(this.chatOptions.getTemperature()).maxTokens(this.chatOptions.getMaxTokens()).topP(this.chatOptions.getTopP()).topK(this.chatOptions.getTopK()).frequencyPenalty(this.chatOptions.getFrequencyPenalty()).presencePenalty(this.chatOptions.getPresencePenalty()).stopSequences(this.chatOptions.getStopSequences()).toolCallbacks(toolCallbacks).internalToolExecutionEnabled(Boolean.valueOf(false)).build();
        Intrinsics.checkNotNullExpressionValue((Object)toolCallingChatOptions, (String)"build(...)");
        return (ChatOptions)toolCallingChatOptions;
    }
}

