/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support.springai;

import com.embabel.agent.core.ToolGroupMetadata;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.ToolDefinition;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/embabel/agent/spi/support/springai/MetadataEnrichedToolCallback;", "Lorg/springframework/ai/tool/ToolCallback;", "toolGroupMetadata", "Lcom/embabel/agent/core/ToolGroupMetadata;", "delegate", "<init>", "(Lcom/embabel/agent/core/ToolGroupMetadata;Lorg/springframework/ai/tool/ToolCallback;)V", "getToolGroupMetadata", "()Lcom/embabel/agent/core/ToolGroupMetadata;", "getToolDefinition", "Lorg/springframework/ai/tool/definition/ToolDefinition;", "call", "", "toolInput", "toString", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nMetadataEnrichedToolCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataEnrichedToolCallback.kt\ncom/embabel/agent/spi/support/springai/MetadataEnrichedToolCallback\n+ 2 GetLogger.kt\ncom/embabel/common/util/GetLoggerKt\n*L\n1#1,50:1\n27#2:51\n*S KotlinDebug\n*F\n+ 1 MetadataEnrichedToolCallback.kt\ncom/embabel/agent/spi/support/springai/MetadataEnrichedToolCallback\n*L\n38#1:51\n*E\n"})
public final class MetadataEnrichedToolCallback
implements ToolCallback {
    @Nullable
    private final ToolGroupMetadata toolGroupMetadata;
    @NotNull
    private final ToolCallback delegate;

    public MetadataEnrichedToolCallback(@Nullable ToolGroupMetadata toolGroupMetadata, @NotNull ToolCallback delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.toolGroupMetadata = toolGroupMetadata;
        this.delegate = delegate;
    }

    @Nullable
    public final ToolGroupMetadata getToolGroupMetadata() {
        return this.toolGroupMetadata;
    }

    @NotNull
    public ToolDefinition getToolDefinition() {
        ToolDefinition toolDefinition = this.delegate.getToolDefinition();
        Intrinsics.checkNotNullExpressionValue((Object)toolDefinition, (String)"getToolDefinition(...)");
        return toolDefinition;
    }

    @NotNull
    public String call(@NotNull String toolInput) {
        Intrinsics.checkNotNullParameter((Object)toolInput, (String)"toolInput");
        try {
            String string = this.delegate.call(toolInput);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"call(...)");
            return string;
        }
        catch (Throwable t) {
            boolean $i$f$loggerFor = false;
            Logger logger = LoggerFactory.getLogger(MetadataEnrichedToolCallback.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.warn("Tool call failure on " + this.delegate.getToolDefinition().name() + ": input from LLM was <" + toolInput + ">", t);
            throw t;
        }
    }

    @NotNull
    public String toString() {
        return "MetadataEnrichedToolCallback(toolGroupMetadata=" + this.toolGroupMetadata + ", delegate=" + this.delegate.getToolDefinition().name() + ")";
    }
}

