/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support;

import com.embabel.agent.spi.support.AgentScanningBeanPostProcessorEvent;
import com.embabel.agent.spi.support.AgentScanningPostProcessorDelegate;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!test"})
@Order(value=0x7FFFFFFF)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0011\u0018\u00002\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002:\u0001\u001dB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0012J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0092.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/embabel/agent/spi/support/DelegatingAgentScanningBeanPostProcessor;", "Lorg/springframework/beans/factory/config/BeanPostProcessor;", "Lorg/springframework/context/ApplicationListener;", "Lorg/springframework/context/event/ContextRefreshedEvent;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "<init>", "(Lorg/springframework/context/ApplicationContext;Lorg/springframework/context/ApplicationEventPublisher;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "agentScanningBeanPostProcessor", "Lcom/embabel/agent/spi/support/AgentScanningPostProcessorDelegate;", "pendingBeans", "Ljava/util/Queue;", "Lcom/embabel/agent/spi/support/DelegatingAgentScanningBeanPostProcessor$BeanProcessingInfo;", "onApplicationEvent", "", "event", "postProcessAfterInitialization", "", "bean", "beanName", "", "processPendingBeans", "processBean", "BeanProcessingInfo", "embabel-agent-api"})
public class DelegatingAgentScanningBeanPostProcessor
implements BeanPostProcessor,
ApplicationListener<ContextRefreshedEvent> {
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    private final Logger logger;
    private AgentScanningPostProcessorDelegate agentScanningBeanPostProcessor;
    @NotNull
    private final Queue<BeanProcessingInfo> pendingBeans;

    public DelegatingAgentScanningBeanPostProcessor(@NotNull ApplicationContext applicationContext, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.applicationContext = applicationContext;
        this.applicationEventPublisher = applicationEventPublisher;
        this.logger = LoggerFactory.getLogger(DelegatingAgentScanningBeanPostProcessor.class);
        this.pendingBeans = new ConcurrentLinkedQueue();
    }

    public void onApplicationEvent(@NotNull ContextRefreshedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.logger.info("Application context has been refreshed and all beans are initialized.");
        this.agentScanningBeanPostProcessor = (AgentScanningPostProcessorDelegate)this.applicationContext.getBean(AgentScanningPostProcessorDelegate.class);
        this.processPendingBeans();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new AgentScanningBeanPostProcessorEvent("Post-processing completed"));
        this.logger.info("All deferred beans were post-processed.");
    }

    @Nullable
    public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) throws BeansException {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        if (this.agentScanningBeanPostProcessor != null) {
            return this.processBean(bean, beanName);
        }
        this.pendingBeans.offer(new BeanProcessingInfo(bean, beanName));
        return bean;
    }

    private void processPendingBeans() {
        while (this.pendingBeans.poll() != null) {
            BeanProcessingInfo beanInfo;
            Object object = this.processBean(beanInfo.getBean(), beanInfo.getBeanName());
        }
    }

    private Object processBean(Object bean, String beanName) {
        AgentScanningPostProcessorDelegate agentScanningPostProcessorDelegate = this.agentScanningBeanPostProcessor;
        if (agentScanningPostProcessorDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"agentScanningBeanPostProcessor");
            agentScanningPostProcessorDelegate = null;
        }
        return agentScanningPostProcessorDelegate.postProcessAfterInitialization(bean, beanName);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/embabel/agent/spi/support/DelegatingAgentScanningBeanPostProcessor$BeanProcessingInfo;", "", "bean", "beanName", "", "<init>", "(Ljava/lang/Object;Ljava/lang/String;)V", "getBean", "()Ljava/lang/Object;", "getBeanName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "embabel-agent-api"})
    private static final class BeanProcessingInfo {
        @NotNull
        private final Object bean;
        @NotNull
        private final String beanName;

        public BeanProcessingInfo(@NotNull Object bean, @NotNull String beanName) {
            Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
            Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
            this.bean = bean;
            this.beanName = beanName;
        }

        @NotNull
        public final Object getBean() {
            return this.bean;
        }

        @NotNull
        public final String getBeanName() {
            return this.beanName;
        }

        @NotNull
        public final Object component1() {
            return this.bean;
        }

        @NotNull
        public final String component2() {
            return this.beanName;
        }

        @NotNull
        public final BeanProcessingInfo copy(@NotNull Object bean, @NotNull String beanName) {
            Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
            Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
            return new BeanProcessingInfo(bean, beanName);
        }

        public static /* synthetic */ BeanProcessingInfo copy$default(BeanProcessingInfo beanProcessingInfo, Object object, String string, int n, Object object2) {
            if ((n & 1) != 0) {
                object = beanProcessingInfo.bean;
            }
            if ((n & 2) != 0) {
                string = beanProcessingInfo.beanName;
            }
            return beanProcessingInfo.copy(object, string);
        }

        @NotNull
        public String toString() {
            return "BeanProcessingInfo(bean=" + this.bean + ", beanName=" + this.beanName + ")";
        }

        public int hashCode() {
            int result = this.bean.hashCode();
            result = result * 31 + this.beanName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BeanProcessingInfo)) {
                return false;
            }
            BeanProcessingInfo beanProcessingInfo = (BeanProcessingInfo)other;
            if (!Intrinsics.areEqual((Object)this.bean, (Object)beanProcessingInfo.bean)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.beanName, (Object)beanProcessingInfo.beanName);
        }
    }
}

