/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.spi.support;

import com.embabel.agent.api.event.LlmRequestEvent;
import com.embabel.agent.api.tool.Tool;
import com.embabel.agent.core.Action;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.ProcessContext;
import com.embabel.agent.core.support.InvalidLlmReturnTypeException;
import com.embabel.agent.core.support.LlmInteraction;
import com.embabel.agent.spi.AutoLlmSelectionCriteriaResolver;
import com.embabel.agent.spi.LlmOperations;
import com.embabel.agent.spi.LlmService;
import com.embabel.agent.spi.ToolDecorator;
import com.embabel.agent.spi.ToolGroupResolver;
import com.embabel.agent.spi.support.LlmDataBindingProperties;
import com.embabel.agent.spi.support.LlmOperationsPromptsProperties;
import com.embabel.agent.spi.validation.DefaultValidationPromptGenerator;
import com.embabel.agent.spi.validation.ValidationPromptGenerator;
import com.embabel.chat.Message;
import com.embabel.chat.UserMessage;
import com.embabel.common.ai.model.AutoModelSelectionCriteria;
import com.embabel.common.ai.model.LlmOptions;
import com.embabel.common.ai.model.ModelProvider;
import com.embabel.common.ai.model.ModelSelectionCriteria;
import com.embabel.common.util.TimeKt;
import jakarta.validation.Validator;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.RetryContext;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0004J;\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H!0'H\u0004\u00a2\u0006\u0002\u0010(JG\u0010)\u001a\u0002H*\"\u0004\b\u0000\u0010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H*012\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u000105\u00a2\u0006\u0002\u00106JO\u00107\u001a\b\u0012\u0004\u0012\u0002H*08\"\u0004\b\u0000\u0010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H*012\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u000105\u00a2\u0006\u0004\b9\u00106J\u0014\u0010:\u001a\u0006\u0012\u0002\b\u00030;2\u0006\u0010\u001e\u001a\u00020\u001fH\u0004JM\u0010<\u001a\b\u0012\u0004\u0012\u0002H*08\"\u0004\b\u0000\u0010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H*012\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H*0>H$\u00a2\u0006\u0004\b?\u0010@J\\\u0010A\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020C0,\u0012\n\u0012\b\u0012\u0004\u0012\u0002H*0>0B\"\u0004\b\u0000\u0010*2\u0006\u00102\u001a\u0002032\u0006\u0010.\u001a\u00020/2\b\u00104\u001a\u0004\u0018\u0001052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H*01H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006D"}, d2={"Lcom/embabel/agent/spi/support/AbstractLlmOperations;", "Lcom/embabel/agent/spi/LlmOperations;", "toolDecorator", "Lcom/embabel/agent/spi/ToolDecorator;", "modelProvider", "Lcom/embabel/common/ai/model/ModelProvider;", "validator", "Ljakarta/validation/Validator;", "validationPromptGenerator", "Lcom/embabel/agent/spi/validation/ValidationPromptGenerator;", "autoLlmSelectionCriteriaResolver", "Lcom/embabel/agent/spi/AutoLlmSelectionCriteriaResolver;", "dataBindingProperties", "Lcom/embabel/agent/spi/support/LlmDataBindingProperties;", "promptsProperties", "Lcom/embabel/agent/spi/support/LlmOperationsPromptsProperties;", "<init>", "(Lcom/embabel/agent/spi/ToolDecorator;Lcom/embabel/common/ai/model/ModelProvider;Ljakarta/validation/Validator;Lcom/embabel/agent/spi/validation/ValidationPromptGenerator;Lcom/embabel/agent/spi/AutoLlmSelectionCriteriaResolver;Lcom/embabel/agent/spi/support/LlmDataBindingProperties;Lcom/embabel/agent/spi/support/LlmOperationsPromptsProperties;)V", "getToolDecorator", "()Lcom/embabel/agent/spi/ToolDecorator;", "getDataBindingProperties", "()Lcom/embabel/agent/spi/support/LlmDataBindingProperties;", "getPromptsProperties", "()Lcom/embabel/agent/spi/support/LlmOperationsPromptsProperties;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "getTimeoutMillis", "", "llmOptions", "Lcom/embabel/common/ai/model/LlmOptions;", "executeWithTimeout", "T", "interactionId", "", "attempt", "", "operation", "Lkotlin/Function0;", "(Ljava/lang/String;Lcom/embabel/common/ai/model/LlmOptions;ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "createObject", "O", "messages", "", "Lcom/embabel/chat/Message;", "interaction", "Lcom/embabel/agent/core/support/LlmInteraction;", "outputClass", "Ljava/lang/Class;", "agentProcess", "Lcom/embabel/agent/core/AgentProcess;", "action", "Lcom/embabel/agent/core/Action;", "(Ljava/util/List;Lcom/embabel/agent/core/support/LlmInteraction;Ljava/lang/Class;Lcom/embabel/agent/core/AgentProcess;Lcom/embabel/agent/core/Action;)Ljava/lang/Object;", "createObjectIfPossible", "Lkotlin/Result;", "createObjectIfPossible-yxL6bBk", "chooseLlm", "Lcom/embabel/agent/spi/LlmService;", "doTransformIfPossible", "llmRequestEvent", "Lcom/embabel/agent/api/event/LlmRequestEvent;", "doTransformIfPossible-BWLJW6A", "(Ljava/util/List;Lcom/embabel/agent/core/support/LlmInteraction;Ljava/lang/Class;Lcom/embabel/agent/api/event/LlmRequestEvent;)Ljava/lang/Object;", "getToolsAndEvent", "Lkotlin/Pair;", "Lcom/embabel/agent/api/tool/Tool;", "embabel-agent-api"})
@SourceDebugExtension(value={"SMAP\nAbstractLlmOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractLlmOperations.kt\ncom/embabel/agent/spi/support/AbstractLlmOperations\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,312:1\n1557#2:313\n1628#2,3:314\n1557#2:317\n1628#2,3:318\n1557#2:321\n1628#2,3:322\n1557#2:325\n1628#2,3:326\n*S KotlinDebug\n*F\n+ 1 AbstractLlmOperations.kt\ncom/embabel/agent/spi/support/AbstractLlmOperations\n*L\n145#1:313\n145#1:314,3\n307#1:317\n307#1:318,3\n308#1:321\n308#1:322,3\n246#1:325\n246#1:326,3\n*E\n"})
public abstract class AbstractLlmOperations
implements LlmOperations {
    @NotNull
    private final ToolDecorator toolDecorator;
    @NotNull
    private final ModelProvider modelProvider;
    @NotNull
    private final Validator validator;
    @NotNull
    private final ValidationPromptGenerator validationPromptGenerator;
    @NotNull
    private final AutoLlmSelectionCriteriaResolver autoLlmSelectionCriteriaResolver;
    @NotNull
    private final LlmDataBindingProperties dataBindingProperties;
    @NotNull
    private final LlmOperationsPromptsProperties promptsProperties;
    @NotNull
    private final Logger logger;

    public AbstractLlmOperations(@NotNull ToolDecorator toolDecorator, @NotNull ModelProvider modelProvider, @NotNull Validator validator, @NotNull ValidationPromptGenerator validationPromptGenerator, @NotNull AutoLlmSelectionCriteriaResolver autoLlmSelectionCriteriaResolver, @NotNull LlmDataBindingProperties dataBindingProperties, @NotNull LlmOperationsPromptsProperties promptsProperties) {
        Intrinsics.checkNotNullParameter((Object)toolDecorator, (String)"toolDecorator");
        Intrinsics.checkNotNullParameter((Object)modelProvider, (String)"modelProvider");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter((Object)validationPromptGenerator, (String)"validationPromptGenerator");
        Intrinsics.checkNotNullParameter((Object)autoLlmSelectionCriteriaResolver, (String)"autoLlmSelectionCriteriaResolver");
        Intrinsics.checkNotNullParameter((Object)dataBindingProperties, (String)"dataBindingProperties");
        Intrinsics.checkNotNullParameter((Object)promptsProperties, (String)"promptsProperties");
        this.toolDecorator = toolDecorator;
        this.modelProvider = modelProvider;
        this.validator = validator;
        this.validationPromptGenerator = validationPromptGenerator;
        this.autoLlmSelectionCriteriaResolver = autoLlmSelectionCriteriaResolver;
        this.dataBindingProperties = dataBindingProperties;
        this.promptsProperties = promptsProperties;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public /* synthetic */ AbstractLlmOperations(ToolDecorator toolDecorator, ModelProvider modelProvider, Validator validator, ValidationPromptGenerator validationPromptGenerator, AutoLlmSelectionCriteriaResolver autoLlmSelectionCriteriaResolver, LlmDataBindingProperties llmDataBindingProperties, LlmOperationsPromptsProperties llmOperationsPromptsProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            validationPromptGenerator = new DefaultValidationPromptGenerator();
        }
        if ((n & 0x40) != 0) {
            llmOperationsPromptsProperties = new LlmOperationsPromptsProperties();
        }
        this(toolDecorator, modelProvider, validator, validationPromptGenerator, autoLlmSelectionCriteriaResolver, llmDataBindingProperties, llmOperationsPromptsProperties);
    }

    @NotNull
    protected final ToolDecorator getToolDecorator() {
        return this.toolDecorator;
    }

    @NotNull
    protected final LlmDataBindingProperties getDataBindingProperties() {
        return this.dataBindingProperties;
    }

    @NotNull
    protected final LlmOperationsPromptsProperties getPromptsProperties() {
        return this.promptsProperties;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    protected final long getTimeoutMillis(@NotNull LlmOptions llmOptions) {
        Intrinsics.checkNotNullParameter((Object)llmOptions, (String)"llmOptions");
        Duration duration = llmOptions.getTimeout();
        if (duration == null) {
            duration = this.promptsProperties.getDefaultTimeout();
        }
        return duration.toMillis();
    }

    protected final <T> T executeWithTimeout(@NotNull String interactionId, @NotNull LlmOptions llmOptions, int attempt, @NotNull Function0<? extends T> operation) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)interactionId, (String)"interactionId");
        Intrinsics.checkNotNullParameter((Object)llmOptions, (String)"llmOptions");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        long timeoutMillis = this.getTimeoutMillis(llmOptions);
        CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> AbstractLlmOperations.executeWithTimeout$lambda$0(operation));
        try {
            object = future.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            Object[] objectArray = new Object[]{interactionId, attempt, timeoutMillis};
            this.logger.warn("LLM {}: attempt {} timed out after {}ms", objectArray);
            throw new RuntimeException("LLM call for interaction " + interactionId + " timed out after " + timeoutMillis + "ms", e);
        }
        catch (InterruptedException e) {
            future.cancel(true);
            Thread.currentThread().interrupt();
            this.logger.warn("LLM {}: attempt {} was interrupted", (Object)interactionId, (Object)attempt);
            throw new RuntimeException("LLM call for interaction " + interactionId + " was interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause;
            future.cancel(true);
            Throwable throwable = cause = e.getCause();
            if (throwable instanceof RuntimeException) {
                throw cause;
            }
            if (throwable instanceof Exception) {
                throw new RuntimeException("LLM call for interaction " + interactionId + " failed", cause);
            }
            throw new RuntimeException("LLM call for interaction " + interactionId + " failed with unknown error", e);
        }
        return (T)object;
    }

    public static /* synthetic */ Object executeWithTimeout$default(AbstractLlmOperations abstractLlmOperations, String string, LlmOptions llmOptions, int n, Function0 function0, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeWithTimeout");
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return abstractLlmOperations.executeWithTimeout(string, llmOptions, n, function0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <O> O createObject(@NotNull List<? extends Message> messages, @NotNull LlmInteraction interaction, @NotNull Class<O> outputClass, @NotNull AgentProcess agentProcess, @Nullable Action action) {
        Collection<Tool> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
        Pair<List<Tool>, LlmRequestEvent<O>> pair = this.getToolsAndEvent(agentProcess, interaction, action, messages, outputClass);
        List allTools = (List)pair.component1();
        LlmRequestEvent llmRequestEvent = (LlmRequestEvent)pair.component2();
        Iterable iterable = allTools;
        Set set = null;
        LlmOptions llmOptions = null;
        String string = null;
        LlmInteraction llmInteraction = interaction;
        boolean $i$f$map = false;
        void var12_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tool tool = (Tool)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toolDecorator.decorate((Tool)it, agentProcess, action, interaction.getLlm()));
        }
        collection = (List)destination$iv$iv;
        LlmInteraction interactionWithToolDecoration = LlmInteraction.copy-mT3eGQc$default(llmInteraction, string, llmOptions, set, (List)collection, null, null, null, null, false, false, 0, null, 4087, null);
        iterable = TimeKt.time(() -> AbstractLlmOperations.createObject$lambda$6(interaction, this, outputClass, messages, interactionWithToolDecoration, llmRequestEvent));
        Object createdObject = iterable.component1();
        long ms = ((Number)iterable.component2()).longValue();
        this.logger.debug("LLM response={}", createdObject);
        ProcessContext processContext = agentProcess.getProcessContext();
        Duration duration = Duration.ofMillis(ms);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        processContext.onProcessEvent(llmRequestEvent.responseEvent(createdObject, duration));
        return (O)createdObject;
    }

    @Override
    @NotNull
    public final <O> Object createObjectIfPossible-yxL6bBk(@NotNull List<? extends Message> messages, @NotNull LlmInteraction interaction, @NotNull Class<O> outputClass, @NotNull AgentProcess agentProcess, @Nullable Action action) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(outputClass, (String)"outputClass");
        Intrinsics.checkNotNullParameter((Object)agentProcess, (String)"agentProcess");
        Pair<List<Tool>, LlmRequestEvent<O>> pair = this.getToolsAndEvent(agentProcess, interaction, action, messages, outputClass);
        List allTools = (List)pair.component1();
        LlmRequestEvent llmRequestEvent = (LlmRequestEvent)pair.component2();
        Pair pair2 = TimeKt.time(() -> AbstractLlmOperations.createObjectIfPossible_yxL6bBk$lambda$8(this, messages, interaction, allTools, outputClass, llmRequestEvent, agentProcess, action));
        Object response = ((Result)pair2.component1()).unbox-impl();
        long ms = ((Number)pair2.component2()).longValue();
        this.logger.debug("LLM response={}", (Object)Result.box-impl((Object)response));
        ProcessContext processContext = agentProcess.getProcessContext();
        Duration duration = Duration.ofMillis(ms);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        processContext.onProcessEvent(llmRequestEvent.maybeResponseEvent(response, duration));
        return response;
    }

    @NotNull
    protected final LlmService<?> chooseLlm(@NotNull LlmOptions llmOptions) {
        Intrinsics.checkNotNullParameter((Object)llmOptions, (String)"llmOptions");
        ModelSelectionCriteria crit = llmOptions.getCriteria() instanceof AutoModelSelectionCriteria ? this.autoLlmSelectionCriteriaResolver.resolveAutoLlm() : llmOptions.getCriteria();
        return this.modelProvider.getLlm(crit);
    }

    @NotNull
    protected abstract <O> Object doTransformIfPossible-BWLJW6A(@NotNull List<? extends Message> var1, @NotNull LlmInteraction var2, @NotNull Class<O> var3, @NotNull LlmRequestEvent<O> var4);

    private final <O> Pair<List<Tool>, LlmRequestEvent<O>> getToolsAndEvent(AgentProcess agentProcess, LlmInteraction interaction, Action action, List<? extends Message> messages, Class<O> outputClass) {
        Collection<String> collection;
        Tool it;
        Collection<String> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        ToolGroupResolver toolGroupResolver = agentProcess.getProcessContext().getPlatformServices$embabel_agent_api().getAgentPlatform().getToolGroupResolver();
        List allTools = interaction.resolveTools(toolGroupResolver);
        LlmRequestEvent<O> llmRequestEvent = new LlmRequestEvent<O>(agentProcess, action, outputClass, LlmInteraction.copy-mT3eGQc$default(interaction, null, null, null, allTools, null, null, null, null, false, false, 0, null, 4087, null), this.chooseLlm(interaction.getLlm()), messages);
        agentProcess.getProcessContext().onProcessEvent(llmRequestEvent);
        Iterable iterable = llmRequestEvent.getInteraction().getTools();
        String string = "Expanded tools from {}: {}";
        Logger logger = this.logger;
        boolean $i$f$map = false;
        void var11_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Tool tool = (Tool)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getDefinition().getName());
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = allTools;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Tool)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDefinition().getName());
        }
        collection = (List)destination$iv$iv;
        logger.debug(string, collection2, (Object)collection);
        return new Pair((Object)allTools, llmRequestEvent);
    }

    private static final Object executeWithTimeout$lambda$0(Function0 $operation) {
        return $operation.invoke();
    }

    private static final Object createObject$lambda$6$lambda$3$lambda$2(AbstractLlmOperations this$0, List $initialMessages, LlmInteraction $interactionWithToolDecoration, Class $outputClass, LlmRequestEvent $llmRequestEvent) {
        return this$0.doTransform($initialMessages, $interactionWithToolDecoration, $outputClass, $llmRequestEvent);
    }

    private static final Object createObject$lambda$6$lambda$3(AbstractLlmOperations this$0, LlmInteraction $interaction, List $initialMessages, LlmInteraction $interactionWithToolDecoration, Class $outputClass, LlmRequestEvent $llmRequestEvent, RetryContext it) {
        return AbstractLlmOperations.executeWithTimeout$default(this$0, $interaction.getId-Ti10f1E(), $interaction.getLlm(), 0, () -> AbstractLlmOperations.createObject$lambda$6$lambda$3$lambda$2(this$0, $initialMessages, $interactionWithToolDecoration, $outputClass, $llmRequestEvent), 4, null);
    }

    private static final Object createObject$lambda$6$lambda$5$lambda$4(AbstractLlmOperations this$0, List $messages, Ref.ObjectRef $constraintViolations, LlmInteraction $interactionWithToolDecoration, Class $outputClass, LlmRequestEvent $llmRequestEvent) {
        Collection collection = $messages;
        ValidationPromptGenerator validationPromptGenerator = this$0.validationPromptGenerator;
        Object object = $constraintViolations.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        return this$0.doTransform(CollectionsKt.plus((Collection)collection, (Object)new UserMessage(validationPromptGenerator.generateViolationsReport((Set)object), null, null, 6, null)), $interactionWithToolDecoration, $outputClass, $llmRequestEvent);
    }

    private static final Object createObject$lambda$6$lambda$5(AbstractLlmOperations this$0, LlmInteraction $interaction, List $messages, Ref.ObjectRef $constraintViolations, LlmInteraction $interactionWithToolDecoration, Class $outputClass, LlmRequestEvent $llmRequestEvent, RetryContext it) {
        return AbstractLlmOperations.executeWithTimeout$default(this$0, $interaction.getId-Ti10f1E(), $interaction.getLlm(), 0, () -> AbstractLlmOperations.createObject$lambda$6$lambda$5$lambda$4(this$0, $messages, $constraintViolations, $interactionWithToolDecoration, $outputClass, $llmRequestEvent), 4, null);
    }

    private static final Object createObject$lambda$6(LlmInteraction $interaction, AbstractLlmOperations this$0, Class $outputClass, List $messages, LlmInteraction $interactionWithToolDecoration, LlmRequestEvent $llmRequestEvent) {
        List initialMessages = $interaction.getValidation() && this$0.validator.getConstraintsForClass($outputClass).isBeanConstrained() && this$0.dataBindingProperties.getSendValidationInfo() ? CollectionsKt.plus((Collection)$messages, (Object)new UserMessage(this$0.validationPromptGenerator.generateRequirementsPrompt(this$0.validator, $outputClass), null, null, 6, null)) : $messages;
        Object candidate = this$0.dataBindingProperties.retryTemplate($interaction.getId-Ti10f1E()).execute(arg_0 -> AbstractLlmOperations.createObject$lambda$6$lambda$3(this$0, $interaction, initialMessages, $interactionWithToolDecoration, $outputClass, $llmRequestEvent, arg_0));
        if ($interaction.getValidation()) {
            Ref.ObjectRef constraintViolations = new Ref.ObjectRef();
            Object object = constraintViolations.element = this$0.validator.validate(candidate, new Class[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
            if (!((Collection)object).isEmpty()) {
                candidate = this$0.dataBindingProperties.retryTemplate($interaction.getId-Ti10f1E()).execute(arg_0 -> AbstractLlmOperations.createObject$lambda$6$lambda$5(this$0, $interaction, $messages, constraintViolations, $interactionWithToolDecoration, $outputClass, $llmRequestEvent, arg_0));
                Object object2 = constraintViolations.element = this$0.validator.validate(candidate, new Class[0]);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element");
                if (!((Collection)object2).isEmpty()) {
                    Object object3 = candidate;
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Any");
                    Object object4 = constraintViolations.element;
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"element");
                    throw new InvalidLlmReturnTypeException(object3, (Set)object4);
                }
            }
        }
        return candidate;
    }

    /*
     * WARNING - void declaration
     */
    private static final Result createObjectIfPossible_yxL6bBk$lambda$8(AbstractLlmOperations this$0, List $messages, LlmInteraction $interaction, List $allTools, Class $outputClass, LlmRequestEvent $llmRequestEvent, AgentProcess $agentProcess, Action $action) {
        Collection<Tool> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $allTools;
        Set set = null;
        LlmOptions llmOptions = null;
        String string = null;
        LlmInteraction llmInteraction = $interaction;
        List list = $messages;
        AbstractLlmOperations abstractLlmOperations = this$0;
        boolean $i$f$map = false;
        void var10_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tool tool = (Tool)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.toolDecorator.decorate((Tool)it, $agentProcess, $action, $interaction.getLlm()));
        }
        collection = (List)destination$iv$iv;
        return Result.box-impl((Object)abstractLlmOperations.doTransformIfPossible-BWLJW6A(list, LlmInteraction.copy-mT3eGQc$default(llmInteraction, string, llmOptions, set, collection, null, null, null, null, false, false, 0, null, 4087, null), $outputClass, $llmRequestEvent));
    }
}

